/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A3Cv
 */

// forked from Kay's [QuickBox2D] Soft Object #2
// forked from Kay's forked from: QuickBox2D sample
// forked from mash's QuickBox2D sample
package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;

    public class FlashTest extends MovieClip {
            public var circles:Array = new Array();
        public var radius:Number = 0.2;
        public var circleNum:int = 40;
        public var nColor:int = 0x66ff66;
        public function FlashTest() {
            stage.frameRate = 60;
            var sim:QuickBox2D = new QuickBox2D(this, { debug:true, gravityX:0, gravityY:20 });
            sim.createStageWalls();
            var center:Point = new Point(5,5);
            var nRadius:Number = 4;
            var centerCircle:QuickObject = sim.addCircle({x:center.x, y:center.y, radius:2.5, restitution:0.2, 
            lineAlpha:0, fillColor:0x009900 , fixedRotation:true});
            for (var i:int = 0; i < circleNum; i++) {
                    var nR:Number = Math.PI*2/circleNum*i;
                var circle:QuickObject = sim.addCircle({x:center.x+nRadius*Math.cos(nR), y:center.y+nRadius*Math.sin(nR), 
                radius:radius, lineAlpha:0, fillAlpha:0, fixedRotation:true});
                circles.push(circle);
                sim.addJoint({a:centerCircle.body, b:circle.body, frequencyHz:10, dampingRatio:0.1, collideConnected:false});
                if (i > 0) {
                    sim.addJoint({a:circles[i-1].body, b:circle.body, frequencyHz:0, dampingRatio:0.1, restitution:0});
                }
            }
            sim.addJoint({a:circles[circleNum-1].body, b:circles[0].body, length:radius*2, frequencyHz:0});
            
            sim.start();
            sim.mouseDrag();
            
            addEventListener(Event.ENTER_FRAME, xFake);                       
        }
        private function xFake(e:Event):void {
                graphics.clear();
                graphics.lineStyle(10,nColor);
                graphics.beginFill(nColor);
                var sPos:Point = new Point();
                for (var i:int = 0; i < circleNum; i++) {
                    var circle:QuickObject = circles[i];
                    if (i == 0) {
                        sPos = new Point(circle.x*30, circle.y*30);
                        graphics.moveTo(sPos.x, sPos.y);
                    } else {
                        graphics.lineTo(circle.x*30,circle.y*30);
                    }
                }
                graphics.lineTo(sPos.x, sPos.y);
                graphics.endFill();
        } 
    }
}
