/**
 * Copyright heymichsaywhat ( http://wonderfl.net/user/heymichsaywhat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A2tO
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    [SWF(stageWidth="640", stageHeight="480", frameRate="60")]
    public class Main extends Sprite
    {
        private const numChasers:int = 2;
        
        private var player:Sprite = null;
        private var chasers:Array = null;
        
        public function Main()
        {
            player = new Player();
            addChild(player);
            
            chasers = [];
            for (var chaserIndex:int = 0; chaserIndex < numChasers; chaserIndex++)
            {
                var chaser:Chaser = new Chaser();
                chasers.push(chaser);
                addChild(chaser);
                chaser.x = int(Math.random() * 640);
                chaser.y = int(Math.random() * 480);
            }
            
            stage.addEventListener(Event.ENTER_FRAME, enterFrameListener);
        }
        
        private function enterFrameListener(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0x000080);
            player.x = int(player.x + 0.1 * (stage.mouseX - player.x));
            player.y = int(player.y + 0.1 * (stage.mouseY - player.y));
            
            for (var chaserIndex:int = 1; chaserIndex < numChasers; chaserIndex++)
            {
                var chaser:Chaser = chasers[chaserIndex];
                var chasee:Chaser = chasers[chaserIndex - 1];
                chaser.chase(chasee);
            }
            var firstChaser:Chaser = chasers[0];
            firstChaser.chase(player);
        }
    }
}

import flash.display.*;
import flash.geom.*;

class ColoredCube extends Sprite
{
    public function setColor(cubeColor:uint):void
    {
        graphics.clear()
        graphics.beginFill(cubeColor);
        graphics.drawRect(-16, -16, 32, 32);
        graphics.endFill();
    }
}

class Player extends ColoredCube
{
    public function Player()
    {
        setColor(0x008000);
    }
}

class Chaser extends ColoredCube
{
    static public const STATE_CHASING:int = 0;
    static public const STATE_EVADING:int = 1;
    static public const STATE_WANDERING:int = 2;
    
    private var _movementState:int = 0;
    
    private var movementSpeed:Number = 5;
    private var chaseThreshold:Number = 50;
    private var evadeThreshold:Number = 300;
    
    private var numberOfDestinationsToWanderTo:int = 0;
    private var wanderDestination:Point = null;
    
    public function Chaser()
    {
        movementState = STATE_CHASING;
    }
    
    public function set movementState(value:int):void
    {
        _movementState = Math.random() < 0.9 ? value : STATE_WANDERING;
        switch (_movementState)
        {
            case STATE_CHASING:
                setColor(0xff1493);
                break;
            case STATE_EVADING:
                setColor(0x00bbff);
                break;
            case STATE_WANDERING:
                numberOfDestinationsToWanderTo = Math.floor(5 + 7 * Math.random());
                setColor(0x0FFE303);
                break;
        }
    }
    
    public function get movementState():int
    {
        return _movementState;
    }
    
    public function chase(sprite:Sprite):void
    {
        var destination:Point = null;
        if (movementState == STATE_WANDERING)
        {
            if (!wanderDestination)
            {
                wanderDestination = new Point(Math.floor(Math.random() * 540), Math.floor(Math.random() * 380));
            }
            destination = wanderDestination;
        }
        else
        {
            destination = new Point(sprite.x, sprite.y);
        }
        var dx:Number = destination.x - x;
        var dy:Number = destination.y - y;
        var mag:Number = Math.sqrt(dx * dx + dy * dy);
        if (mag == 0)
        {
            dx = 1;
        }
        else
        {
            dx /= mag;
            dy /= mag;
        }
        
        switch (movementState)
        {
            case STATE_CHASING:
                
               if (dx < dy)
                {  
                 if (dy == 0)
                  {
                      x += movementSpeed * dx;
                  }
                  y += movementSpeed * dy; 
                } 
                
               else if (dy < dx)
                {
                    if(dx == 0)
                    {
                        y += movementSpeed * dy;
                    }    
                    x += movementSpeed * dx; 
                }
                    

                if (mag < chaseThreshold)
                {
                    movementState = STATE_EVADING;
                }
                break;
                
            case STATE_EVADING:
                x -= movementSpeed * dx;
                y -= movementSpeed * dy;
                if (mag > evadeThreshold)
                {
                    movementState = STATE_CHASING;
                }
                break;
            case STATE_WANDERING:
                x += movementSpeed * dx;
                y += movementSpeed * dy;
                if (mag < chaseThreshold)
                {
                    numberOfDestinationsToWanderTo--;
                    wanderDestination = null;
                    if (numberOfDestinationsToWanderTo == 0)
                    {
                        movementState = Math.random() < 0.5 ? STATE_CHASING : STATE_EVADING;
                    }
                }
                break;
            default:
                break;
        }
        
        if (movementState != STATE_WANDERING)
        {
            (parent as Sprite).graphics.moveTo(x, y);
            (parent as Sprite).graphics.lineTo(destination.x, destination.y);
        }
    }
}
