/**
 * Copyright isseyimamura ( http://wonderfl.net/user/isseyimamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A1ex
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.text.*;
    import flash.media.Camera;
    import flash.media.Video;
    
    public class CirclePixelizationCamera extends Sprite {
        private var _txt1:TextField = new TextField();
        private var _txt2:TextField = new TextField();
        private var _txtFmt:TextFormat = new TextFormat();
        
        private var _camera:Camera = Camera.getCamera();
        private var _video:Video = new Video();
        private var _level:Number;
        private var _bitmap:Bitmap = new Bitmap();
        private var _bmpRef:BitmapData;
        private var _container:Sprite = new Sprite();
        private var _colorsR:Array = new Array();
        private var _colorsG:Array = new Array();
        private var _colorsB:Array = new Array();
        
        private var _row:int = 30;
        private var _col:int = 30;
        private var _radius:int = 15;
        private var _margin:int = _radius + 1;
        
        public function CirclePixelizationCamera() {
            init();
            setDotted();
            setCamera();
            //srtStatus();
        }
        
        private function init():void {
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0x000000, 1);
            bg.graphics.drawRect(0, 0, 2500, 2000);
            bg.graphics.endFill();
            addChild(bg);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }
        
        public function srtStatus():void {
            _txtFmt.color = 0xFFFFFF;
            _txt1.x = 20; _txt1.y = 20; _txt1.width = 200; _txt1.setTextFormat(_txtFmt); _txt1.defaultTextFormat = _txtFmt; addChild(_txt1);
            _txt2.x = 20; _txt2.y = 40; _txt2.width = 200; _txt2.setTextFormat(_txtFmt); _txt2.defaultTextFormat = _txtFmt; addChild(_txt2);
        }
        
        public function setCamera():void {
            if (_camera != null) {
                _video.attachCamera(_camera);
                _video.y = -300;
                _video.visible = false;
                _camera.setQuality(0, 100);
                _camera.setMotionLevel(20, 1000);
                _camera.addEventListener(ActivityEvent.ACTIVITY, activity);
                addEventListener(Event.ENTER_FRAME, enterFrame);
            } else {
                _txt1.text = "Camera Not Found";
            }
            addChild(_video);
            addChild(_bitmap);
        }
        
        private function activity(event:ActivityEvent):void {
            event.activating == true ? _txt1.text = "ACTIVITY : Register" : _txt1.text = "ACTIVITY : Undetectable";
        }
        
        private function enterFrame(event:Event):void {
            _level = _camera.activityLevel; _txt2.text = "activityLevel : " + String(_level);
            var bmpdata:BitmapData = capture(_video);
            
            /*
            // PerlinNoise
            _bitmap.bitmapData = bmpdata;
            _bitmap.x = 350;
            PerlinNoise.noise(_bitmap);
            */
            
            // CirclePixelization
            _container.x = 0;
            _container.y = _radius;
            getColor(bmpdata);
        }
        
        // ドットを並べる
        private function setDotted():void {
            addChild(_container);
            var currentRow:int = 0;
            var gap:int = 0;
            
            for (var i:int = 0; i < _row; i++) {
                //oddOrEven(currentRow) ? gap = radius : gap = 0;    // ドットを斜めにずらす
                for (var j:int = 0; j < _col; j++) {
                    var circle:Shape = new Shape();
                    circle.graphics.beginFill(0x333333);
                    circle.graphics.drawCircle(0, 0, _radius);
                    circle.graphics.endFill();
                    circle.x = (_radius + _margin) * j + gap;
                    circle.y = (_radius + _margin) * currentRow;
                    _container.addChild(circle);
                    if (j == _col - 1) currentRow++;
                }
            }
            _colorsR.length = _container.numChildren - 1;
            _colorsG.length = _container.numChildren - 1;
            _colorsB.length = _container.numChildren - 1;
        }
        
        private function oddOrEven(num:int):Boolean {
            return Boolean(num % 2);
        }
        
        private function getColor(target:BitmapData):void {
            // BitmapData.histogram(); // 平均値(Vector形式 FP10)
            // var targetImage:BitmapData = target; // そのままの状態で
            var contrast:Number = 0.08;
            var matrix:Array = adjustContarast(contrast);
            var targetImage:BitmapData = new BitmapData(320, 240);
            var bmp:Bitmap = new Bitmap(target);
            var blurFilter:BitmapFilter = new BlurFilter(16, 16);
            var colorFilter:ColorMatrixFilter  = new ColorMatrixFilter(matrix);
            bmp.filters = [blurFilter];
            bmp.filters = [colorFilter];
            
            targetImage.draw(bmp);
            
            var currentRow:int = 0;
            var rectW:int = targetImage.width / _col;  // 抽出ポイント
            var rectH:int = targetImage.height / _col; // 抽出ポイント
            var n:int = 0;
            
            for (var i:int = 0; i < _row; i++) {
                for (var j:int = 0; j < _col; j++) {
                    var pixelValue:uint = targetImage.getPixel32(rectW * (j + 1), rectH * (currentRow + 1)); // 代表点
                    _colorsR[n] = pixelValue >> 16 & 0xFF;
                    _colorsG[n] = pixelValue >> 8 & 0xFF;
                    _colorsB[n] = pixelValue & 0xFF;
                    if (j == _col - 1) currentRow++;
                    n++;
                }
            }
            setColor();
        }
        
        private function adjustContarast(value:Number):Array {
            var matrix:Array = new Array();
            matrix = matrix.concat([value + 1, 0, 0, 0, -(128 * value)]); // R
            matrix = matrix.concat([0, value + 1, 0, 0, -(128 * value)]); // G
            matrix = matrix.concat([0, 0, value + 1, 0, -(128 * value)]); // B
            matrix = matrix.concat([0, 0, 0, 1, 0]); // alpha
            return matrix;
        }
         
        private function setColor():void {
            var num:int = _container.numChildren;
            for (var i:int = 0; i < num; i++) {
                var r:uint = _colorsR[i];
                var g:uint = _colorsG[i];
                var b:uint = _colorsB[i];
                var tar:Shape = _container.getChildAt(i) as Shape;
                var color:uint = r << 16 | g << 8 | b;
                var max:Number = Math.max(r, Math.max(g, b));
                var v:Number = max / 255;
                tar.graphics.clear();
                tar.graphics.beginFill(color);
                tar.graphics.lineStyle(10, color, v, false, LineScaleMode.NONE);
                tar.graphics.drawCircle(0, 0, _radius);
                tar.graphics.endFill();
                tar.width = (_radius * 2) * ((Math.round(v * 100) * 0.01) + 0.1);
                tar.height = tar.width;
            }
        }
        
        private function capture(target:*):BitmapData {
            if (_bitmap.bitmapData != null) _bmpRef.dispose();
            var bmpData:BitmapData = new BitmapData(target.width, target.height);
            bmpData.draw(target);
            _bmpRef = bmpData;
            return bmpData;
        }
    }
}