/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A1Pa
 */

package {
    //import aquioux.display.colorUtil.RGBWheel;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
    /**
     * 
     * @author Yoshida, Akio
     */
    public class Main extends Sprite {
        // 度からラジアンへ変換するための定数
        static private const DEGREE_TO_RADIAN:Number = 0.017453292519943295;    // = Math.PI / 180;

        // ステージ中心座標
        private const CENTER_X:Number = stage.stageWidth  / 2;
        private const CENTER_Y:Number = stage.stageHeight / 2;

        // 回転させるためのシフト値
        private var rotateShift_:Number = 0;
        static private const RATE_ROTATE_SHIFT:Number = DEGREE_TO_RADIAN;

        // 環の半径の最小値
        static private const MIN_RADIUS:Number = 35;

        // 周期
        private var freq_:Number;
        
        // 回転方向
        private var direction_:int;

        // 環の数
        static private const NUM_RINGS_BY_FREQ:uint = 10;
        private var numOfRings_:int;
        
        // キャンバス
        private var canvas_:Shape;
        private var g_:Graphics;


        /**
         * コンストラクタ
         */
        public function Main():void {
            setup();
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }

        /**
         * セットアップ
         */
        private function setup():void {
            freq_        = 1;
            numOfRings_  = NUM_RINGS_BY_FREQ * freq_;
            rotateShift_ = 0;
            direction_   = 1;
            
            var back:Shape = new Shape();
            addChild(back);
            g_ = back.graphics;
            g_.beginFill(0x0);
            g_.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            canvas_ = new Shape();
            addChild(canvas_);
            g_ = canvas_.graphics;
        }

        /**
         * アップデート
         */
        private function update(event:Event):void {
            if (freq_ < 0) freq_ *= -1;
            numOfRings_ = NUM_RINGS_BY_FREQ * (freq_ +1);
            g_.clear();
            for (var i:int = 0; i < numOfRings_; i++) {
                // 角度（弧度）
                var myRadian:Number = i * 360 / numOfRings_ * DEGREE_TO_RADIAN * direction_;
                // 半径と座標の計算
                var radius:Number = MIN_RADIUS * (Math.cos((myRadian + rotateShift_) * freq_) + 2);
                var posX:Number   = Math.cos(myRadian) * radius + CENTER_X;
                var posY:Number   = Math.sin(myRadian) * radius + CENTER_Y;
                // 描画
                g_.beginFill(RGBWheel.getRadianColor(myRadian), 0.25);
                g_.drawCircle(posX, posY, radius);
                g_.endFill();
            }
            // 回転
            rotateShift_ += (RATE_ROTATE_SHIFT * direction_);
        }

        /**
         * マウスムーブハンドラ
         */
        private function mouseMoveHandler(event:MouseEvent):void {
            freq_ = (this.mouseX / CENTER_X - 1) * 5;
            direction_ = freq_ < 0 ? 1 : -1;
        }
    }
}


//package aquioux.display.colorUtil {
    /**
     * コサインカーブで色相環的に RGB を計算
     * @author YOSHIDA, Akio
     */
    /*public*/ class RGBWheel {
        /**
         * 角度に応じた RGB を得る（度数法指定）
         * @param    angle    角度（度数法）
         * @return    色（0xRRGGBB）
         */
        static private const TO_RADIAN:Number = Math.PI / 180;        // 度数を弧度に
        static public function getDegreeColor(angle:Number):uint {
            var r:uint = (Math.cos( angle        * TO_RADIAN) + 1) * 0xff >> 1;
            var g:uint = (Math.cos((angle + 120) * TO_RADIAN) + 1) * 0xff >> 1;
            var b:uint = (Math.cos((angle - 120) * TO_RADIAN) + 1) * 0xff >> 1;
            return r << 16 | g << 8 | b;
        }
        /**
         * 角度に応じた RGB を得る（弧度法指定）
         * @param    radian    角度（弧度法）
         * @return    色（0xRRGGBB）
         */
        static private const RADIAN120:Number = Math.PI * 2 / 3;        // 120度を弧度で
        static public function getRadianColor(radian:Number):uint {
            var r:uint = (Math.cos(radian)             + 1) * 0xff >> 1;
            var g:uint = (Math.cos(radian + RADIAN120) + 1) * 0xff >> 1;
            var b:uint = (Math.cos(radian - RADIAN120) + 1) * 0xff >> 1;
            return r << 16 | g << 8 | b;
        }
    }
//}

