/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A0nu
 */

// forked from nutsu's BitmapDataSample4
// forked from nutsu's BitmapDataSample3
// forked from nutsu's BitmapDataSample1
package {
    
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width=465,height=465,backgroundColor=0,frameRate=30)]
    public class BitmapDataSample4 extends Sprite {
        
        private var bmpdata:BitmapData;
        private var sprite:Sprite;
        private var matrix:Matrix;
        private var colortrans:ColorTransform;
        
        public function BitmapDataSample4() {
            //BitmapDataを作�Eして表示リストに追加
            bmpdata = new BitmapData( 465, 465, false, 0 );
            addChild( new Bitmap(bmpdata) );
            //グラフィチE��の生�E
            sprite = newFig( 0, 0, 40, 0xFFFFFF );
            //Matrix,ColorTransformの初期匁E            
			matrix = new Matrix();
            colortrans = new ColorTransform();
            //イベンチE            
			addEventListener( Event.ENTER_FRAME, enterframe );
            stage.addEventListener( MouseEvent.CLICK, reset );
			matrix = new Matrix();
			matrix.translate(stage.stageWidth / 2, stage.stageHeight / 2);
			bmpdata.draw( sprite, matrix, colortrans );
        }
        
        private function enterframe(e:Event):void {

            //色変換
            colortrans.redMultiplier = mouseX / 465;
            colortrans.blueMultiplier  = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
			bmpdata.colorTransform(bmpdata.rect, colortrans);
            //BitmapDataへ描画
            
        }
        
        private function reset(e:MouseEvent):void {
            bmpdata.draw( sprite, matrix, colortrans );
        }
        
        private function newFig( cx:Number, cy:Number, size:Number, col:uint ):Sprite {          
			var shape:Sprite = new Sprite();
            shape.graphics.lineStyle( 0, 0x000000, 0.3 );
            shape.graphics.beginFill( col );
            shape.graphics.drawCircle( cx, cy, size*0.5 );
            shape.graphics.drawCircle( cx, cy, size*0.4 );
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            shape.graphics.drawRect( cx - w/2, cy - h/2, w, h );
            shape.graphics.endFill();
            return shape;
        }
    }
}