/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A0LY
 */

// forked from bradsedito's For my Mom! =)
//  BradSedito 2011
//  ...A hello for my big sis Stacey!
//  =)

package  
{
    import fl.motion.easing.*;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.Point;
    import flash.text.*;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import gs.*;
    import gs.easing.*;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]

    public class HelloStacey extends BasicView 
    {
        private static const _TEXT_SIZE:Number = 25;
        private var _root:DisplayObject3D;
        private var _defaultForm:Boolean;
        private var _pixelList:Array;
        private var _textPosList:Array;

        public function HelloStacey() 
        {
            if (!stage)
                addEventListener(Event.ADDED_TO_STAGE, init);
            else
                init();
        }

        private function init(event:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            _defaultForm = true;
            initScene();
            createText();
            
            setupInteraction();
            startRendering();
        }
        
        override protected function onRenderTick(event:Event = null):void 
        {
            super.onRenderTick(event);
          _root.rotationY += ( -viewport.containerSprite.mouseX - _root.rotationY) * 0.009;  
          _root.rotationX =  ( 540 ); 
 //       _root.rotationY += ( -viewport.containerSprite.mouseX - _root.rotationX) * 0.05;
  //        _root.rotationZ += ( -viewport.containerSprite.mouseY - _root.rotationZ) * 0.05;
        }
        private function initScene():void
        {
            _root = scene.addChild(new DisplayObject3D());
            _camera.z = -85;
        }
        
        private function createText():void
        {
            _textPosList = getTextPos();
            
            var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, "clear_pre", false, false);
            bfx.drawCommand.blendMode = BlendMode.ADD;
            bfx.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, BitmapFilterQuality.HIGH), false));
            viewport.containerSprite.addLayer(bfx);
            
            var pixels:Pixels  = new Pixels(bfx);
            _pixelList = [];
            _root.addChild(pixels);
            for (var i:int = 0, n:int = _textPosList.length; i < n; ++i) 
            {
                var pxd:PxData = _textPosList[i];
                var px:Pixel3D = new Pixel3D(pxd.color, pxd.x, pxd.y, 0);
                pixels.addPixel3D(px);
                _pixelList[i] = px;
            }
            
            bfx.addDisplayObject3D(pixels);
        }
        
        private function getTextPos():Array
        {
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 18, 0xFFFFFF, true);
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = "ART IS LIFE!";
//          var bmd:BitmapData = new BitmapData(tf.textWidth + 2, tf.textHeight, true, 0xFFEC54C2);        
            var bmd:BitmapData = new BitmapData(tf.textWidth + 1.0, tf.textHeight, true, 0xFF000000);
            bmd.draw(tf);
            
            var result:Array = [];
            for (var i:int = 0, n:int = bmd.width; i < n; ++i) 
            {
                for (var j:int = 0, m:int = bmd.height; j < m; ++j) 
                {
                    var color:uint = bmd.getPixel(i, j);
                    if (color)
                    {
                        switch (i % 3) 
                        {
                            case 0:
                                color = 0xFFEC54C2;
                                break;
                            case 1:
                                color = 0xFFEC54C2;
                                break;
                            case 2:
                                color = 0xFFEC54C2;
                                break;
                        }
                        result.push(new PxData(i  - n * 0.5, j - m * 0.5, color));
                    }
                }
            }
            return result;
        }
        
        private function setupInteraction():void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            scatterPixels();
        }
 
        private function downHandler(event:MouseEvent):void 
        {
            if (_defaultForm)
                explosion();
            else 
                defaultPosition()
        }
         
        private function scatterPixels():void
        {
            _defaultForm = false;
            for (var i:int = 0, n:int = _pixelList.length; i < n; ++i) 
            {
                var px:Pixel3D = _pixelList[i];
                TweenMax.to(px, 1.5, { x: Math.random() * 300 - 150, y: Math.random() * 300 - 150, z: Math.random() * 300 - 150, ease: Quintic.easeOut, delay: 0.0001 * i, overwrite: true});
            }

        }

        
        private function explosion():void
        {
            _defaultForm = false;
            for (var i:int = 0, n:int = _pixelList.length; i < n; ++i) 
            {
                var px:Pixel3D = _pixelList[i];
                TweenMax.to(px, 1.5, { x: Math.random() * 300 - 150, y: Math.random() * 300 - 150, z: Math.random() * 300 - 150, ease: Quintic.easeOut, delay: 0.0001 * i, overwrite: true});
            }
        }
        
        private function defaultPosition():void
        {
            _defaultForm = true;
            for (var i:int = 0, n:int = _pixelList.length; i < n; ++i) 
            {
                var px:Pixel3D = _pixelList[i];
                var pxd:PxData = _textPosList[i];
                TweenMax.to(px, 1.5, { x: pxd.x, y: pxd.y, z:0, ease:Quintic.easeOut, delay:.001*i, overwrite: true }); 
            }
        }
        
    }
    
}
class PxData
{
    public var x:Number;
    public var y:Number;
    public var color:uint;
    function PxData(x:Number, y:Number, color:uint)
    {
        this.x = x;
        this.y = y;
        this.color = color;
    }
    
}
