/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9zOk
 */

package 
{
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    [SWF(width = 465, height = 465)]
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var arr:Array = [];
        private var sp_array:Array = [];
        
        public function Main():void 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            sp_array = circleDraw();
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            for (var i:int = 0; i < 512; i++)
            {
                var sp:Sprite = sp_array[i] as Sprite;
                var data:Number = bytes.readFloat() * 300;
                sp.x += (data - sp.x) + 465 / 2;
                
                if (sp.x > stage.stageWidth)
                {
                    sp.x = 0;
                }
                
            }
        }
        
        private function circleDraw():Array
        {
        var master_arr:Array = [];
            for (var j:int = 0; j < 512; j++)
            {
                var sp:Sprite = new Sprite();
                sp.graphics.beginFill(0xFFFFFF);
                sp.graphics.drawCircle(3, 3, 3);
                sp.graphics.endFill();
                sp.y = j * stage.stageHeight / 512;
                sp.z = 0;
                sp.blendMode = BlendMode.INVERT;
                addChild(sp);
                master_arr.push(sp);
            }
        return master_arr;
        }
    }
}