/**
 * Copyright takishiki ( http://wonderfl.net/user/takishiki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9zGk
 */

package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    
    // SWFメタデータタグ
    [SWF(width = "400", height = "400", frameRate = "30", backgroundColor = "0x000000")]
    public class Main extends Sprite 
    {
        private const NUM:int = 3;
        private const STAR_NUM:int = 10;
        
        private var COLOR:Vector.<uint> = new Vector.<uint>(NUM);
        private var _sp:Vector.<Sprite> = new Vector.<Sprite>(NUM);
        private var _deg:Vector.<int> = new Vector.<int>(NUM);
        
        // constructor
        public function Main():void {
            var g:Graphics;
            
            var sp:Sprite;
            var deg:int;
            var size:int;
            
            COLOR[0] = 0xFF0000;
            COLOR[1] = 0x00FF00;
            COLOR[2] = 0x0000FF;
            
            for (var i:int = 0; i < NUM; i++) {
                sp = new Sprite();
                
                deg = randRange(0, 10) - 5;
                g = sp.graphics;
                g.lineStyle(2, COLOR[i]);
                for (var j:int = 0; j < STAR_NUM; j++) {
                    size = randRange(10, 40);
                    drawStar(sp, 5, randRange(0, stage.stageWidth) - stage.stageWidth / 2, randRange(0, stage.stageHeight) - stage.stageHeight / 2, size, int(size * 0.5), randRange(0, 359));
                }
                sp.x = stage.stageWidth / 2;
                sp.y = stage.stageHeight / 2;
                //sp.alpha = randRange(5, 9) / 10;
                sp.filters = [new GlowFilter(COLOR[i], 0.8, 10, 10, 2, 2, true, false), new GlowFilter(COLOR[i], 0.6, 20, 20, 4, 2, false, false),];
                this.addChild(sp);
                _sp[i] = sp;
                _deg[i] = deg;
            }
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        // フレーム処理
        private function onEnterFrame(event:Event):void {
            for (var i:int = 0; i < NUM; i++) {
                _sp[i].rotation += _deg[i];
            }
        }
        
        // draw star shape
        private function drawStar(sp:Sprite, num:int, x:int, y:int, r1:int, r2:int, deg:Number):void {
            /*
             * sp:対象Sprite
             * num:頂点の数
             * x:中心のx座標
             * y:中心のy座標
             * r1:外側（山）の半径
             * r2:内側（谷）の半径
             * deg:回転角度（度）
             */
            var g:Graphics = sp.graphics;
            var rad:Number;
            var i:int;
            var step:Number = 360 / num;
            
            // 描画スタート位置に移動
            rad = deg2rad(0 + deg);
            g.moveTo(x + r1 * Math.cos(rad), y + r1 * Math.sin(rad));
            
            // 谷 -> 山 -> 谷　の順番で線を描画
            for (i = 0; i < num; i++) {
                rad = deg2rad(i * step + deg + step / 2);
                g.lineTo(x + r2 * Math.cos(rad), y + r2 * Math.sin(rad));
                rad = deg2rad((i + 1) * step + deg);
                g.lineTo(x + r1 * Math.cos(rad), y + r1 * Math.sin(rad));
            }
        }
        
        // a-bの乱数生成
        private function randRange(min:Number = 0, max:Number = 1):Number {
            var randomNum:Number = Math.floor(Math.random() * (max - min + 1)) + min;
            return randomNum;
        }
        
        // degree -> radian
        private function deg2rad(deg:Number):Number {
            deg %= 360;
            return deg / 180 * Math.PI;
        }
        
        
    }
    
}