/**
 * Copyright sw_lucchini ( http://wonderfl.net/user/sw_lucchini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9zAn
 */

package {
	import caurina.transitions.Tweener;
    import flash.events.*;
    import flash.filters.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.core.effects.view.*;
    
    [SWF(backgroundColor="0x000000",frameRate="60")]
    public class FlashTest extends ReflectionView {
    		private var rot:Number;
    		private var num:int;
    		private var flag:Boolean = false;
    		public static const MAX_NUM:int = 5;
    		private var wrap:DisplayObject3D = new DisplayObject3D();
        public function FlashTest() {
        		scene.addChild(wrap);
            var material:ColorMaterial = new ColorMaterial(0xFF0000);
            material.doubleSided = true;
            for(var i:int = 0;i < MAX_NUM;i++){
            		rot = i * 360 / MAX_NUM;
            		var plane:Plane = new Plane(material,240,135);
            		plane.x = 500 * Math.sin(rot * Math.PI / 180);
            		plane.y = 0;
            		plane.z = 500 * Math.cos(rot * Math.PI / 180);
            		plane.rotationY = rot;
            		wrap.addChild(plane);
            }
            surfaceHeight = -120;
            viewportReflection.alpha = 0.5;
            viewportReflection.filters = [new BlurFilter(8,8,9)];
            camera.zoom = 2;
            camera.focus = 300;
            camera.z = 1000; //MAX_NUMが奇数でも正面にくる
            addEventListener(Event.ENTER_FRAME,loop);
            stage.addEventListener(KeyboardEvent.KEY_DOWN,keyHandler);
        }
        
        private function loop(e:Event):void{
        		singleRender();
        }
        
        private function keyHandler(e:KeyboardEvent):void{
        		if(flag) return;
        		switch(e.keyCode){
        			case 37:
        				num--;
        				move(num);
        			break;
        			case 39:
        				num++;
        				move(num);
        			break;
        		}
        }
        
        private function move(m:int):void{
        		flag= true;
			rot = m * 360 / MAX_NUM;
			Tweener.addTween(wrap, {
				rotationY:rot,
				time:1,
				transition:"easeInOutQuint",
				onComplete:function():void{
					flag = false;
				}
			});
        }
    }
}