/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9yaH
 */

//suusiki no hyouka
package 
{
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class Main extends Sprite 
    {
        private var prompt : TextField;
        private var result : TextField;
        private var input : TextField;
        private var output : TextField;
        public function Main() 
        {
            prompt = label("> ", 0, 0);
            input = new TextField;
            input.type = "input";
            input.x = prompt.width;
            input.width = stage.stageWidth - prompt.width - 5;
            input.height = prompt.height;
            input.border = true;
            input.text = "3+3*5/6-8";
            input.addEventListener("keyDown", input_keyDown);
            addChild(input);
            result = label("= ", 0, prompt.height + 5);
            output = new TextField;
            output.autoSize = "left";
            output.width = stage.stageWidth - prompt.width - 5;
            output.x = result.width;
            output.y = result.y;
            addChild(output);
        }
        private function input_keyDown(e : KeyboardEvent) : void 
        {
            if (e.keyCode == Keyboard.ENTER)
            {
                try
                {
                    var s : String = input.text;
                    var ss : Array = [];
                    for (var i : int = 0; i < s.length; i++)
                    {
                        ss.push(s.charAt(i));
                    }
                    output.text = eval(parse(ss));
                }
                catch (err : Error)
                {
                    output.text = err.message;
                }
            }
        }
        private function label(lbl : String, x : Number, y : Number) : TextField 
        {
            var t : TextField = new TextField;
            t.autoSize = "left";
            t.x = x;
            t.y = y;
            t.text = lbl;
            addChild(t);
            return t;
        }
        public function parse(tokens : Array) : * 
        {
            var index : int = 0;
            var binaries : Object = {'' : 3, '*' : 2, '/' : 2, '+' : 1, '-' : 1};
            var stack : Array = [];
            while (tokens[index] != undefined) 
            {
                var exp : * = tokens[index++];
                var op : * = tokens[index++];
                var precedence : int = (op == undefined) ? 0 : binaries[op];
                while (stack.length && precedence <= binaries[stack[stack.length - 1]]) 
                {
                    exp = [stack.pop(), stack.pop(), exp];
                }
                stack.push(exp, op);
            }
            return exp;
        }
        public function eval(exp : *) : * 
        {
            var binaries : Object = 
            {
                '' : function(x : *, y : *) : Number 
                { 
                    return 10 * eval(x) + eval(y); 
                },
                '*' : function(x : *, y : *) : Number 
                { 
                    return eval(x) * eval(y); 
                },
                '/' : function(x : *, y : *) : Number 
                { 
                    return eval(x) / eval(y); 
                },
                '+' : function(x : *, y : *) : Number 
                { 
                    return parseInt(eval(x)) + parseInt(eval(y)); 
                },
                '-' : function(x : *, y : *) : Number 
                { 
                    return eval(x) - eval(y); 
                }
            };
            if (exp is Array) 
            {
                return binaries[exp[0]](exp[1], exp[2]);
            }
            return exp;
        }
    }
}
