/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9xzo
 */

// forked from Nicolas's 連結ばね
//連結ばねのシミュレート
//左側の赤い正方形をドラッグして離すと、２つの箱が３つのばねによる運動を始めます。
//ばね定数等の各変数はテキストフィールドにて変更できます。

//空気抵抗の項を追加

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.text.*;
    [SWF(frameRate="60")]
    public class SpringTest extends Sprite {
        public function SpringTest() {
            //ばね
            var spring1:Spring = new Spring(50, 100);          
            addChild(spring1);            
            
            var spring2:Spring = new Spring(200, 100);         
            addChild(spring2);
            
            var spring3:Spring = new Spring(350, 100);
            addChild(spring3);
            
            //箱（おもり）           
            var box1:Box = new Box(150, 75);
            box1.buttonMode = true;
            addChild(box1);
                        
            var box2:Box = new Box(300, 75);
            addChild(box2);
            
            //ばね定数入力
            var k1Text:TextField = new TextField();
            k1Text.x = 80;
            k1Text.y = 40;
            k1Text.height = 20;
            k1Text.width = 50;
            k1Text.border = true;
            k1Text.type = TextFieldType.INPUT;
            k1Text.restrict = "0-9 .";
            k1Text.text = "1";
            addChild(k1Text);
            
            var k2Text:TextField = new TextField();
            k2Text.x = 230;
            k2Text.y = 40;
            k2Text.height = 20;
            k2Text.width = 50;
            k2Text.border = true;
            k2Text.type = TextFieldType.INPUT;
            k2Text.restrict = "0-9 .";
            k2Text.text = "1";
            addChild(k2Text);
            
            var k3Text:TextField = new TextField();
            k3Text.x = 380;
            k3Text.y = 40;
            k3Text.height = 20;
            k3Text.width = 50;
            k3Text.border = true;
            k3Text.type = TextFieldType.INPUT;
            k3Text.restrict = "0-9 .";
            k3Text.text = "1";
            addChild(k3Text);
            
            //おもりの質量入力
            var m1Text:TextField = new TextField();
            m1Text.x = 150;
            m1Text.y = 150;
            m1Text.height = 20;
            m1Text.width = 50;
            m1Text.border = true;
            m1Text.type = TextFieldType.INPUT;
            m1Text.restrict = "0-9 .";
            m1Text.text = "100";
            addChild(m1Text);
            
            var m2Text:TextField = new TextField();
            m2Text.x = 300;
            m2Text.y = 150;
            m2Text.height = 20;
            m2Text.width = 50;
            m2Text.border = true;
            m2Text.type = TextFieldType.INPUT;
            m2Text.restrict = "0-9 .";
            m2Text.text = "100";
            addChild(m2Text);
            
            //箱１の初速度入力
            var v0Text:TextField = new TextField();
            v0Text.x = 150;
            v0Text.y = 200;
            v0Text.height = 20;
            v0Text.width = 50;
            v0Text.border = true;
            v0Text.type = TextFieldType.INPUT;
            v0Text.restrict = "0-9, \\-.";
            v0Text.text = "0";
            addChild(v0Text);
            
            //空気抵抗の係数
            var c:Number;
            var cText:TextField = new TextField();
            cText.x = 50;
            cText.y = 200;
            cText.height = 20;
            cText.width = 50;
            cText.border = true;
            cText.type = TextFieldType.INPUT;
            cText.restrict = "0-9, \\-.";
            cText.text = "1";
            addChild(cText);
            
            
            //つかんで動かす
            box1.addEventListener("mouseDown", drag);
            function drag(e:MouseEvent):void {
                //入力値を代入
                spring1.k = Number(k1Text.text);
                spring2.k = Number(k2Text.text);
                spring3.k = Number(k3Text.text);
                c = Number(cText.text);
                box1.m = Number(m1Text.text);
                box2.m = Number(m2Text.text);
                box1.x = 150;
                box2.x = 300;
                box1.v = Number(v0Text.text);
                box2.v = 0;
                box1.removeEventListener("enterFrame", loop2);
                box1.addEventListener("enterFrame", loop1);
            }
            
            function loop1(e:Event):void {
                if(mouseX>75 && mouseX<275)box1.x = mouseX-25;
                //ばね描画
                spring1.drawSpring(50, box1.x);
                spring2.drawSpring(box1.x+50, box2.x);
                
                stage.addEventListener("mouseUp", release);
            }
            
            function release(e:MouseEvent):void {
                box1.removeEventListener("enterFrame", loop1);
                box1.addEventListener("enterFrame", loop2);
            }
            
            function loop2(e:Event):void {
                //ばね描画
                spring1.drawSpring(50, box1.x);
                spring2.drawSpring(box1.x+50, box2.x);
                spring3.drawSpring(box2.x+50, 450);
                
                //運動方程式（箱１）　a = F/m
                //空気による抵抗力の項を追加 F = k1*x - k2*x -cv
                box1.a = (spring1.force - spring2.force - c*box1.v)/box1.m;
                //速度と位置を変更           
                box1.v += box1.a;
                box1.x += box1.v;
                
                //運動方程式（箱２） a = F/m
                //空気による抵抗力の項を追加 F = k2*x - k3*x -cv
                box2.a = (spring2.force - spring3.force - c*box2.v)/box2.m
                //速度と位置を変更
                box2.v += box2.a;
                box2.x += box2.v;
            }
            
            
            //説明用テキスト
            createTextField(60, 20, "ばね1のばね定数");
            createTextField(210, 20, "ばね2のばね定数");
            createTextField(360, 20, "ばね3のばね定数");
            createTextField(140, 130, "おもり１の質量");
            createTextField(290, 130, "おもり2の質量");
            createTextField(140, 180, "おもり1の初速度");
            createTextField(40, 180, "空気抵抗の係数");
            
            function createTextField(_x:int, _y:int, content:String):void {
                var tf:TextField = new TextField();
                tf.x = _x;
                tf.y = _y;
                tf.text = content;
                tf.height = 20;
                addChild(tf);         
            }
        }
    }
    
    
}

//ばね
import flash.display.*;
class Spring extends Sprite {
    public var k:Number = 1;//ばね定数
    public var force:Number = 0;//弾性力
    public var g:Graphics = graphics;
    public function Spring(_x:Number, _y:Number) {
        g.lineStyle(3);
        g.lineTo(100, 0);
        x = _x;
        y = _y;
    }
    public function drawSpring(startX:Number, endX:Number):void {
        g.clear();
        g.lineStyle(3);
        g.moveTo(startX-x, 0)
        g.lineTo(endX-x, 0);
        //弾性力計算　F=kx
        force = k*(100-(endX-startX));
    }
}

//箱
class Box extends Sprite {
    public var g:Graphics = graphics;
    public var m:Number =100;
    public var v:Number = 0;
    public var a:Number = 0;
    public function Box(_x:Number, _y:Number) {
        g.beginFill(0xFF0000);
        g.drawRect(0, 0, 50, 50);
        x = _x;
        y = _y;
    }
}