/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9xjS
 */

// forked from romatica's Alternative3DでCOLLADAロード（ParserCollada）
/**
 * Alternative3DでCOLLADA読み込みテスト
 * モデルはBlenderで作成
 * 
 * なんか気持ち横長に表示されている気がする　
 * PaperVision3D版はこちら　http://wonderfl.net/c/kIrA
 *-------------------------------------------------------
 * @author itoz ( http://www.romatica.com )
 */
 
package 
{
    import alternativ7.engine3d.containers.*;
    import alternativ7.engine3d.core.Face;
    import alternativ7.engine3d.core.Wrapper;
    import alternativ7.engine3d.materials.*;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3D;
       import alternativ7.engine3d.core.Object3DContainer;
           import alternativ7.engine3d.core.Vertex;
          import alternativa.engine3d.primitives.Box;
    import alternativ7.engine3d.core.View;
     import alternativ7.engine3d.objects.BSP;
         import alternativ7.engine3d.objects.Mesh;
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.loaders.ParserCollada;
    import alternativ7.engine3d.primitives.Plane;
    import alternativ7.engine3d.alternativa3d;
    use namespace alternativa3d;

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    /**
     * 
     */
    public class TestDAELoad extends Sprite
    {
        private  var COLLADA_XML : XML = new ColladaXML().xml;
        private var _parser : ParserCollada; //
        private var _camera : Camera3D;
        private var _controller : SimpleObjectController;
        private var _scene : Object3DContainer;
        private var _amazon : Object3D;


        public function TestDAELoad()
        {
            addEventListener( Event.ADDED_TO_STAGE, _init );
         
        }
        
        public  function triangulateMesh(mesh:Mesh):void 
        {
        
            var f:Face;
            var next:Face;
            var last:Face;
            var a:Vertex; var b:Vertex; var c:Vertex;
            for (f = mesh.faceList; f != null; f = next) {
                next = f.next;
                var lastTri:Face = null;
                if (f.wrapper.next.next.next != null) {
                    // for each successive vertex, fan out a new face
                    a = f.wrapper.vertex; // 'a' never changes, primary pivot hook vertex
                    b = f.wrapper.next.next.vertex;  // secondary vertex hook (ie. last valid-drawn vertex)
                    for (var w:Wrapper = f.wrapper.next.next.next; w != null; w = w.next) {
                        c = w.vertex;
                        var newTri:Face = new Face();
                        newTri.wrapper = new Wrapper();
                        newTri.wrapper.vertex = a;
                        newTri.wrapper.next = new Wrapper();
                        newTri.wrapper.next.vertex = b;
                        newTri.wrapper.next.next = new Wrapper();
                        newTri.wrapper.next.next.vertex = c;
                        newTri.material = f.material;
                        newTri.normalX = f.normalX;
                        newTri.normalY = f.normalY;
                        newTri.normalZ = f.normalZ;
                        newTri.offset = f.offset;
                        b = c;
                        if (lastTri != null) lastTri.next = newTri
                        else f.next = newTri;
                        lastTri = newTri;
                    }
                    f.wrapper.next.next.next = null;
                }
                if (lastTri != null) lastTri.next = next;
            }
        }

        private function _init(event : Event) : void
        {
            removeEventListener( Event.ADDED_TO_STAGE, _init );
        
            _scene = new Object3DContainer();
            _camera = _scene.addChild( new Camera3D() ) as Camera3D;
            
                _controller = new SimpleObjectController( stage, _camera, 512);
            addChild( _camera.diagram);
            _camera.view = new View( stage.stageWidth, stage.stageHeight );
            addChild( _camera.view  );
        
        
            
            
            loadCollada();
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　Collada読み込みスタート
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        private function loadCollada() : void
        {
          
_controller.setObjectPosXYZ(800,500,500);
_controller.lookAtXYZ(0,0,0);
            // colladaテクスチャロード
              _parser = new ParserCollada();
            _parser.parse( COLLADA_XML);

            var oldMesh:Mesh = _parser.objects[0].clone() as Mesh;
oldMesh.setMaterialToAllFaces( new FillMaterial(0xFF0000, 1, 1, 0x000000) );

var mesh:Mesh = _parser.objects[0] as Mesh;
mesh.weldVertices();
mesh.weldFaces(0, 1000, 0, true);
triangulateMesh(mesh);
mesh.setMaterialToAllFaces( new FillMaterial(0x00FF00, 1, 1, 0x000000) );

var bsp:BSP = new BSP();
bsp.createTree(mesh);
bsp.matrix = mesh.matrix;
bsp.setMaterialToAllFaces(  new FillMaterial(0x0000FF, 1, 1, 0x000000) );


            _amazon = _scene.addChild( mesh);
        _scene.addChild(oldMesh);
        oldMesh.x = 600;
         bsp.x = 1200;
         _scene.addChild(bsp);
            
           
            addEventListener(Event.ENTER_FRAME, onTick); //
            
            _controller.update();
            _camera.render();
            
        
            
            
        }

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　Collada読み込み完了
        //
        

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　 テクスチャ読み込み完了
        

        // _____________________________________________________________________
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　
        // 　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　　   　　　　　　　 update
        private function onTick(e : Event) : void
        {
   //         _amazon.rotationY += 0.05;
   _controller.update();
            _camera.render();
            //throw new Error("A");
        }
    }
}

class ColladaXML {
    public var xml:XML = <COLLADA xmlns="http://www.collada.org/2005/11/COLLADASchema" version="1.4.1">
    <asset>
        <created>2014-10-30T03:41:19.2331905Z</created>
        <modified>2014-10-30T03:41:19.2331905Z</modified>
        <up_axis>Z_UP</up_axis>
        <unit meter="0.02539999969303608" name="inch" /> 
    </asset>
    <library_geometries>
        <geometry id="model133">
            <mesh>
                <source id="model133-positions">
                    <float_array id="model133-positions-array" count="489">-192 90 14 -192 0 14 -192 0 64 -192 90 64 -192 0 64 -192 0 128 -192 129 128 -192 129 64 -64 0 -256 -64 129 -256 64 129 -256 64 0 -256 -64 129 256 -64 0 256 64 0 256 64 129 256 -192 129 -256 0 322 -256 192 129 -256 192 129 256 0 322 256 -192 129 256 -192 0 14 -192 90 14 -192 129 0 -192 129 -192 -192 0 -192 64 0 256 128 0 256 128 129 256 64 129 256 192 129 192 192 0 192 192 0 -192 192 129 -192 -64 0 -256 -128 0 -256 -128 129 -256 -64 129 -256 128 0 -256 64 0 -256 64 129 -256 128 129 -256 -192 129 64 -192 129 0 -192 90 14 -192 90 64 -192 129 192 -192 129 128 -192 0 128 -192 0 192 -128 0 256 -64 0 256 -64 129 256 -128 129 256 -192 129 -192 -192 129 -256 -192 0 -256 -192 0 -192 192 0 -256 128 0 -256 128 129 -256 192 129 -256 -192 0 256 -128 0 256 -128 129 256 -192 129 256 192 0 256 192 0 192 192 129 192 192 129 256 128 0 256 192 0 256 192 129 256 128 129 256 192 0 -256 192 129 -256 192 129 -192 192 0 -192 -192 0 256 -192 129 256 -192 129 192 -192 0 192 -128 0 -256 -192 0 -256 -192 129 -256 -128 129 -256 208 121 264 208 121 -264 0 338 -256 0 338 256 -208 121 -264 -208 121 264 0 338 256 0 338 -256 0 338 -256 96 177 -336 -96 177 -336 0 338 -256 -96 177 -336 -208 121 -264 0 338 -256 208 121 -264 96 177 -336 0 338 256 -208 121 264 -96 177 336 0 338 256 -96 177 336 96 177 336 0 338 256 96 177 336 208 121 264 -96 177 -320 96 177 -320 0 322 -256 -192 129 -256 -96 177 -320 0 322 -256 96 177 -320 192 129 -256 0 322 -256 -96 177 320 -192 129 256 0 322 256 96 177 320 -96 177 320 0 322 256 192 129 256 96 177 320 0 322 256 -208 121 264 -192 129 256 -96 177 320 -96 177 336 -96 177 336 -96 177 320 96 177 320 96 177 336 96 177 336 96 177 320 192 129 256 208 121 264 -192 129 256 -208 121 264 -208 121 -264 -192 129 -256 192 129 -256 208 121 -264 208 121 264 192 129 256 -96 177 -336 -96 177 -320 -192 129 -256 -208 121 -264 96 177 -336 96 177 -320 -96 177 -320 -96 177 -336 208 121 -264 192 129 -256 96 177 -320 96 177 -336</float_array>
                    <technique_common>
                        <accessor count="163" source="#model133-positions-array" stride="3">
                            <param name="X" type="float"/>
                            <param name="Y" type="float"/>
                            <param name="Z" type="float"/>
                        </accessor>
                    </technique_common>
                </source>
                <source id="model133-normals">
                    <float_array id="model133-normals-array" count="489">-1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 1 0 0 1 0 0 1 0 0 1 0 0 -1 0 0 -1 0 0 -1 0 0 1 0 0 1 0 0 1 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 0 0 1 0 0 1 0 0 1 0 0 1 1 0 0 1 0 0 1 0 0 1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0.722656 0.691406 0 0.722656 0.691406 0 0.722656 0.691406 0 0.722656 0.691406 0 -0.722656 0.691406 0 -0.722656 0.691406 0 -0.722656 0.691406 0 -0.722656 0.691406 0 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 -0.621094 0.613281 -0.488281 -0.621094 0.613281 -0.488281 -0.621094 0.613281 -0.488281 0.621094 0.613281 -0.488281 0.621094 0.613281 -0.488281 0.621094 0.613281 -0.488281 -0.621094 0.613281 0.488281 -0.621094 0.613281 0.488281 -0.621094 0.613281 0.488281 0 0.445313 0.894531 0 0.445313 0.894531 0 0.445313 0.894531 0.621094 0.613281 0.488281 0.621094 0.613281 0.488281 0.621094 0.613281 0.488281 0 -0.402344 0.914063 0 -0.402344 0.914063 0 -0.402344 0.914063 0.625 -0.621094 0.472656 0.625 -0.621094 0.472656 0.625 -0.621094 0.472656 -0.625 -0.621094 0.472656 -0.625 -0.621094 0.472656 -0.625 -0.621094 0.472656 0.625 -0.621094 -0.472656 0.625 -0.621094 -0.472656 0.625 -0.621094 -0.472656 0 -0.402344 -0.914063 0 -0.402344 -0.914063 0 -0.402344 -0.914063 -0.625 -0.621094 -0.472656 -0.625 -0.621094 -0.472656 -0.625 -0.621094 -0.472656 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0.445313 -0.894531 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0 -0.445313 -0.894531 0</float_array>
                    <technique_common>
                        <accessor count="163" source="#model133-normals-array" stride="3">
                            <param name="X" type="float"/>
                            <param name="Y" type="float"/>
                            <param name="Z" type="float"/>
                        </accessor>
                    </technique_common>
                </source>
                <source id="model133-uv">
                    <float_array id="model133-uv-array" count="326">0 0 0 -1 0.999023 -1 1 0 0 -1 1 -1 1 0 0 0 1 -1 1 0 -1 0 -1 -1 0 0 0 -1 2 -1 2 0 5.97949 0 2.97949 1.5 0.102539 0 5.97949 0 2.97949 1.5 0.102539 0 3.21875 -1 3.21875 -0.302246 3 0 0 0 0 -1 3 -1 4 -1 4 0 3 0 0 0 0 -1 6.01172 -1 6.01172 0 0 -1 1 -1 1 0 0 0 0 -1 1 -1 1 0 0 0 4 0 3 0 3.21875 -0.302246 4 -0.302246 6 0 5.00391 0 5.00391 -1 6 -1 0 -1 1 -1 1 0 0 0 0.979492 0 0.0400391 0 0.0400391 -1 0.979492 -1 0.0292969 -1 0.96875 -1 0.96875 0 0.0292969 0 0.0390625 -1 0.978516 -1 0.978516 0 0.0390625 0 0.0292969 -1 0.96875 -1 0.96875 0 0.0292969 0 0.969727 -1 0.00976563 -1 0.00976563 0 0.969727 0 0.0205078 -1 0.0205078 0 0.959961 0 0.959961 -1 0.0205078 -1 0.0205078 0 0.959961 0 0.959961 -1 0.979492 -1 0.0400391 -1 0.0400391 0 0.979492 0 0 -3 3.99609 -3 3.93652 0 0.0625 0 0 -3 3.99609 -3 3.93652 0 0.0625 0 1.5 0 0.808594 -3 2.19141 -3 0 0 0.0800781 -2.31738 1 -3 1 0 0 -3 0.919922 -2.31738 1 0 0 -3 0.919922 -2.31738 1.5 0 0.808594 -3 2.19141 -3 0 0 0.0800781 -2.31738 1 -3 1 -7.5 1 -2.5 0 -5 0 -5.99023 1 -3.48047 0 -0.980469 1 -2.5 0 0 0 -5 1 -2.5 0 0 0 -5 1 -7.5 1 -2.5 0 -5 0 -6 1 -3.5 0 -1 0 -0.00248979 0.00230556 -0.00248979 0.00201736 -0.000311224 0 0 0 -0.00248979 0.00230556 -0.00248979 0.00230556 0 0 0 0 -0.00248979 0.00230556 -0.00248979 0.00263428 -0.000354989 0 0 0 -0.00248979 0.00230556 -0.00248979 0.00230331 0.018051 0 0.0174285 0 -0.00248979 0.00230556 -0.00248979 0.00230331 0.018051 0 0.0174285 0 -0.00248979 0.00230556 -0.00248979 0.00263428 -0.000354989 0 0 0 -0.00248979 0.00230556 -0.00248979 0.00230556 0 0 0 0 -0.00248979 0.00230556 -0.00248979 0.00201736 -0.000311224 0 0</float_array>
                    <technique_common>
                        <accessor count="163" source="#model133-uv-array" stride="2">
                            <param name="S" type="float"/>
                            <param name="T" type="float"/>
                        </accessor>
                    </technique_common>
                </source>
                <vertices id="model133-vertices">
                    <input semantic="POSITION" source="#model133-positions"/>
                </vertices>
                <triangles count="2" material="TEXTURE.074_0-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>0 0 0 1 1 1 2 2 2 0 0 0 2 2 2 3 3 3</p>
                </triangles>
                <triangles count="8" material="TEXTURE.138_3-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>4 4 4 5 5 5 6 6 6 4 4 4 6 6 6 7 7 7 8 8 8 9 9 9 10 10 10 8 8 8 10 10 10 11 11 11 12 12 12 13 13 13 14 14 14 12 12 12 14 14 14 15 15 15 16 16 16 17 17 17 18 18 18 19 19 19 20 20 20 21 21 21</p>
                </triangles>
                <triangles count="17" material="TEXTURE.138_1-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>22 22 22 23 23 23 24 24 24 22 22 22 24 24 24 25 25 25 22 22 22 25 25 25 26 26 26 27 27 27 28 28 28 29 29 29 27 27 27 29 29 29 30 30 30 31 31 31 32 32 32 33 33 33 31 31 31 33 33 33 34 34 34 35 35 35 36 36 36 37 37 37 35 35 35 37 37 37 38 38 38 39 39 39 40 40 40 41 41 41 39 39 39 41 41 41 42 42 42 43 43 43 44 44 44 45 45 45 43 43 43 45 45 45 46 46 46 47 47 47 48 48 48 49 49 49 47 47 47 49 49 49 50 50 50 51 51 51 52 52 52 53 53 53 51 51 51 53 53 53 54 54 54</p>
                </triangles>
                <triangles count="16" material="TEXTURE.138_0-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>55 55 55 56 56 56 57 57 57 55 55 55 57 57 57 58 58 58 59 59 59 60 60 60 61 61 61 59 59 59 61 61 61 62 62 62 63 63 63 64 64 64 65 65 65 63 63 63 65 65 65 66 66 66 67 67 67 68 68 68 69 69 69 67 67 67 69 69 69 70 70 70 71 71 71 72 72 72 73 73 73 71 71 71 73 73 73 74 74 74 75 75 75 76 76 76 77 77 77 75 75 75 77 77 77 78 78 78 79 79 79 80 80 80 81 81 81 79 79 79 81 81 81 82 82 82 83 83 83 84 84 84 85 85 85 83 83 83 85 85 85 86 86 86</p>
                </triangles>
                <triangles count="10" material="TEXTURE.169_0-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>87 87 87 88 88 88 89 89 89 87 87 87 89 89 89 90 90 90 91 91 91 92 92 92 93 93 93 91 91 91 93 93 93 94 94 94 95 95 95 96 96 96 97 97 97 98 98 98 99 99 99 100 100 100 101 101 101 102 102 102 103 103 103 104 104 104 105 105 105 106 106 106 107 107 107 108 108 108 109 109 109 110 110 110 111 111 111 112 112 112</p>
                </triangles>
                <triangles count="6" material="TEXTURE.171_4-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>113 113 113 114 114 114 115 115 115 116 116 116 117 117 117 118 118 118 119 119 119 120 120 120 121 121 121 122 122 122 123 123 123 124 124 124 125 125 125 126 126 126 127 127 127 128 128 128 129 129 129 130 130 130</p>
                </triangles>
                <triangles count="16" material="TEXTURE.000_74-material">
                    <input offset="0" semantic="VERTEX" source="#model133-vertices" set="0"/>
                    <input offset="1" semantic="NORMAL" source="#model133-normals" set="0"/>
                    <input offset="2" semantic="TEXCOORD" source="#model133-uv" set="0"/>
                    <p>131 131 131 132 132 132 133 133 133 131 131 131 133 133 133 134 134 134 135 135 135 136 136 136 137 137 137 135 135 135 137 137 137 138 138 138 139 139 139 140 140 140 141 141 141 139 139 139 141 141 141 142 142 142 143 143 143 144 144 144 145 145 145 143 143 143 145 145 145 146 146 146 147 147 147 148 148 148 149 149 149 147 147 147 149 149 149 150 150 150 151 151 151 152 152 152 153 153 153 151 151 151 153 153 153 154 154 154 155 155 155 156 156 156 157 157 157 155 155 155 157 157 157 158 158 158 159 159 159 160 160 160 161 161 161 159 159 159 161 161 161 162 162 162</p>
                </triangles>
            </mesh>
        </geometry>
    </library_geometries>
    <library_images>
        <image id="TEXTURE.074_0-image" height="0" width="0">
            <init_from>images/TEXTURE.074_0.png</init_from>
        </image>
        <image id="TEXTURE.138_3-image" height="0" width="0">
            <init_from>images/TEXTURE.138_3.png</init_from>
        </image>
        <image id="TEXTURE.138_1-image" height="0" width="0">
            <init_from>images/TEXTURE.138_1.png</init_from>
        </image>
        <image id="TEXTURE.138_0-image" height="0" width="0">
            <init_from>images/TEXTURE.138_0.png</init_from>
        </image>
        <image id="TEXTURE.169_0-image" height="0" width="0">
            <init_from>images/TEXTURE.169_0.png</init_from>
        </image>
        <image id="TEXTURE.171_4-image" height="0" width="0">
            <init_from>images/TEXTURE.171_4.png</init_from>
        </image>
        <image id="TEXTURE.000_74-image" height="0" width="0">
            <init_from>images/TEXTURE.000_74.png</init_from>
        </image>
    </library_images>
    <library_effects>
        <effect id="TEXTURE.074_0-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.074_0-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.138_3-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.138_3-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.138_1-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.138_1-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.138_0-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.138_0-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.169_0-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.169_0-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.171_4-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.171_4-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
        <effect id="TEXTURE.000_74-effect">
            <profile_COMMON>
                <newparam sid="surface">
                    <surface type="2D">
                        <init_from>TEXTURE.000_74-image</init_from>
                    </surface>
                </newparam>
                <newparam sid="sampler">
                    <sampler2D>
                        <source>surface</source>
                        <minfilter>LINEAR_MIPMAP_LINEAR</minfilter>
                        <magfilter>LINEAR</magfilter>
                    </sampler2D>
                </newparam>
                <technique sid="common">
                    <phong>
                        <diffuse>
                            <texture texture="sampler" texcoord="uv0"/>
                        </diffuse>
                    </phong>
                </technique>
            </profile_COMMON>
        </effect>
    </library_effects>
    <library_materials>
        <material id="TEXTURE.074_0-material">
            <instance_effect url="#TEXTURE.074_0-effect"/>
        </material>
        <material id="TEXTURE.138_3-material">
            <instance_effect url="#TEXTURE.138_3-effect"/>
        </material>
        <material id="TEXTURE.138_1-material">
            <instance_effect url="#TEXTURE.138_1-effect"/>
        </material>
        <material id="TEXTURE.138_0-material">
            <instance_effect url="#TEXTURE.138_0-effect"/>
        </material>
        <material id="TEXTURE.169_0-material">
            <instance_effect url="#TEXTURE.169_0-effect"/>
        </material>
        <material id="TEXTURE.171_4-material">
            <instance_effect url="#TEXTURE.171_4-effect"/>
        </material>
        <material id="TEXTURE.000_74-material">
            <instance_effect url="#TEXTURE.000_74-effect"/>
        </material>
    </library_materials>
    <library_visual_scenes>
        <visual_scene id="model133-scene">
            <node id="model133-node">
                <rotate>1 0 0 90</rotate>
                <instance_geometry url="#model133">
                    <bind_material>
                        <technique_common>
                            <instance_material symbol="TEXTURE.074_0-material" target="#TEXTURE.074_0-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.138_3-material" target="#TEXTURE.138_3-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.138_1-material" target="#TEXTURE.138_1-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.138_0-material" target="#TEXTURE.138_0-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.169_0-material" target="#TEXTURE.169_0-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.171_4-material" target="#TEXTURE.171_4-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                            <instance_material symbol="TEXTURE.000_74-material" target="#TEXTURE.000_74-material">
                                <bind_vertex_input semantic="uv0" input_semantic="TEXCOORD" input_set="0"/>
                            </instance_material>
                        </technique_common>
                    </bind_material>
                </instance_geometry>
            </node>
        </visual_scene>
    </library_visual_scenes>
    <scene>
        <instance_visual_scene url="#model133-scene"/>
    </scene>
</COLLADA>

    function ColladaXML() {
        
    }

}
