/**
 * Copyright pon_zu ( http://wonderfl.net/user/pon_zu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9wOs
 */

// forked from paq's [Stardust] RendererにcopyPixelsを使う
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import frocessing.color.ColorHSV;
	
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
	public class Main extends Sprite 
	{
	    static private const COLOR_TRANSFORM:ColorTransform = new ColorTransform (0.9, 0.9, 0.95);
	    private var _emitter:MyEmitter;
	    private var _canvas:BitmapData;
		
	    public function Main():void 
	    {
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	    }
		
	    private function init(e:Event = null):void 
	    {
		removeEventListener(Event.ADDED_TO_STAGE, init);
			
		_canvas = new BitmapData(465, 465, false, 0x000000);
		var bmp:Bitmap = new Bitmap(_canvas);
		addChild(bmp);
		
                var color:ColorHSV = new ColorHSV(180, 0.7);
		var sp:Shape = new Shape();
		var g:Graphics = sp.graphics;
		g.beginFill(color.value, 0.5);
		g.drawCircle(10, 10, 2);
		g.beginFill(color.value - 1, 1);
		g.drawCircle(10, 10, 1);

		var particleBitmap:BitmapData = new BitmapData(20, 20, true, 0x00000000);
		particleBitmap.draw(sp);
			
		_emitter = new MyEmitter(new SteadyClock(30));
		var renderer:CopyPixelsRenderer = new CopyPixelsRenderer(_canvas, particleBitmap);
		renderer.addEmitter(_emitter);
			
		stage.quality = StageQuality.LOW;

		addEventListener(Event.ENTER_FRAME, loop);
	    }
		
	    private function loop(e:Event):void 
	    {
		_canvas.colorTransform(_canvas.rect, COLOR_TRANSFORM);
                // パーティクルの発生点をマウスポインタにちょっと遅れて追従させる。
                _emitter.point.x += ((mouseX - 10) - _emitter.point.x) * 0.1;
		_emitter.point.y += ((mouseY - 10) - _emitter.point.y) * 0.1;
		_emitter.step();
	    }
		
	}
	
}
import flash.display.BitmapData;
import flash.geom.Point;


import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
import idv.cjcat.stardust.common.events.EmitterEvent;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.common.particles.ParticleIterator;
import idv.cjcat.stardust.common.renderers.Renderer;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.particles.Particle2D;


class MyEmitter extends Emitter2D 
{
    public var point:SinglePoint;
	
    public function MyEmitter(clock:Clock)
    {
	super(clock)
		
	    point = new SinglePoint();
		
	addInitializer(new Position(point));
	addInitializer(new Velocity(new LazySectorZone(1, 11)));
	addInitializer(new Life(new UniformRandom(30, 5)));
		
	addAction(new Move());
	addAction(new Age());
	addAction(new DeathLife());

       　addAction(new Accelerate(-0.2));
        addAction(new ScaleCurve(1, 700));
    }
}

class CopyPixelsRenderer extends Renderer
{
    public var targetBitmapData:BitmapData;
    public var sourceBitmapData:BitmapData;	
    private var point:Point;
	
    public function CopyPixelsRenderer(targetBitmapData:BitmapData = null, sourceBitmapData:BitmapData = null)
    {
	this.targetBitmapData = targetBitmapData;
	this.sourceBitmapData = sourceBitmapData;
	point = new Point(); 
    }

    override protected function render(e:EmitterEvent):void
    {
	if (!targetBitmapData) return;
		
	targetBitmapData.lock();
	var particle:Particle2D;
	var iter:ParticleIterator = e.particles.getIterator();
	while (particle = iter.particle as Particle2D)
	    {
		point.x = particle.x;
		point.y = particle.y;
		targetBitmapData.copyPixels(sourceBitmapData, sourceBitmapData.rect, point);
		iter.next();
	    }
	targetBitmapData.unlock();
    }
}