/**
 * Copyright beatspace ( http://wonderfl.net/user/beatspace )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9wL6
 */

package {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.utils.Timer;

	//[SWF(width="800", height="600")]
	public class bezier_chain extends Sprite
	{
		private var base:Sprite;
		private var list:Array = new Array();
		private var list2:Array = new Array();
		private var ctls:Array = new Array();
		private var num:Number = 10;
		private var nR:Number = 150;
		private var g:Graphics;
		private var cnt:Number = 0;
		
		public function bezier_chain()
		{
			base = new Sprite();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			base.x = 465 / 2;
			base.y = 465 / 2;
			
			addChild(base);
			g = base.graphics;
			
			var step:Number = 2 * Math.PI / num;
			for (var i:Number = 0; i < num; i++) {
				list.push(base.addChild(new Node(0x000000, "a" + i.toString())));
				list[i].x = nR * Math.cos(step * i);
				list[i].y = nR * Math.sin(step * i);
				
				list2.push(base.addChild(new Node(0xFF0000, "c" + i.toString())));
				list2[i].x = list[i].x + nR * Math.tan(step / 2) * Math.cos(step * i - Math.PI / 2);
				list2[i].y = list[i].y + nR * Math.tan(step / 2) * Math.sin(step * i - Math.PI / 2);
				
				ctls.push(
					new Point(
						list[i].x + nR * Math.tan(step / 2) * Math.cos(step * i - Math.PI / 2),
						list[i].y + nR * Math.tan(step / 2) * Math.sin(step * i - Math.PI / 2)
					)
				);
			}
			addEventListener(Event.ENTER_FRAME, drawUpdate);
		}
		
		private function do_update():void {
			var idx:Number = 0;
			cnt++;
			for (var j:Number = 0; j < list2.length; j++) {
				list2[j].x = ctls[j].x + 10 * Math.sin(j + cnt);
				list2[j].y = ctls[j].y + 10 * Math.cos(j + cnt);
			}

			for (var i:Number = 0; i < list2.length - 1; i++) {
				
				list[idx].x = (list2[i].x + list2[i + 1].x) / 2;
				list[idx].y = (list2[i].y + list2[i + 1].y) / 2; 
				//trace(list[idx].x.toString() + " " + list[idx].y.toString());
				//trace(list2[i].x.toString() + " " + list2[i].y.toString());
				//trace(Math.sqrt(Math.pow(0 - list2[i].x, 2) + Math.pow(0 - list2[i].y, 2)));
				idx++;
			}
			//list2[list2.length - 1].x = ctls[list2.length - 1].x;
			//list2[list2.length - 1].y = ctls[list2.length - 1].y;
			list[idx].x = (list2[0].x + list2[list2.length - 1].x) / 2;
			list[idx].y = (list2[0].y + list2[list2.length - 1].y) / 2; 
		}
		
		public function draw():void {
			g.clear();
			g.moveTo(list[0].x, list[0].y);
			g.lineStyle(4, 0x000000);
			for (var i:Number = 0; i < num - 1; i += 1) {
				//g.moveTo(list[i].x, list[i].y);
				g.curveTo(list2[i + 1].x, list2[i + 1].y, list[i + 1].x, list[i + 1].y);
			}
			g.curveTo(list2[0].x, list2[0].y, list[0].x, list[0].y);
			
			g.lineStyle(2, 0x000000, 0.8);
			g.moveTo(list2[list2.length -1].x, list2[list2.length -1].y);
			for (var len:Number = 0; len < list2.length; len++) {
				g.lineTo(list2[len].x, list2[len].y);
			}
		}
		
		public function drawUpdate(evt:Event):void {
			do_update();
			draw();
		}
	}
}
import flash.display.Sprite;
import flash.events.MouseEvent;	
import flash.text.TextField;

class Node extends Sprite {
	private var w:Number = 4;
	private var txt:TextField;
	
	public function Node(c:Number = 0xFFFF00, label:String = "", x:Number = 0, y:Number = 0) {
		graphics.beginFill(c);
		graphics.drawCircle(x, y, w);
		graphics.endFill();
		
		txt = new TextField();
		txt.text = label;
		addChild(txt);
	}

}