/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9vk4
 */

package {
    import flash.display.Sprite;
    import org.flintparticles.common.counters.*;
    import org.flintparticles.common.initializers.*;
    import org.flintparticles.threeD.actions.*;
    import org.flintparticles.threeD.emitters.Emitter3D;
    import org.flintparticles.threeD.geom.Point3D;
    import org.flintparticles.threeD.geom.Vector3D;
    import org.flintparticles.threeD.initializers.*;
    import org.flintparticles.threeD.renderers.*;
    import org.flintparticles.threeD.renderers.controllers.*;
    import org.flintparticles.threeD.zones.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite {

        private var emitter:Emitter3D = new Emitter3D();
        private var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(false);

        public function Main() {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            emitter.counter = new Blast(200);
            emitter.addInitializer(new ImageClass(Invader));
            emitter.addInitializer(new Position(new BoxZone(465, 465, 465, new Point3D(0, 0, 0), new Vector3D(0, 1, 0), new Vector3D(0, 0, 1))));
            emitter.addInitializer(new Velocity(new SphereZone(new Point3D(0, 0, 0), 150, 100)));        
            //ApproachNeighbours(maxDistance:Number = 0, acceleration:Number = 0)
            emitter.addAction(new ApproachNeighbours(40, 40));
            //MatchVelocity(maxDistance:Number = 0, acceleration:Number = 0)
            emitter.addAction(new MatchVelocity(30, 100));
            //MinimumDistance(minimum:Number = 0, acceleration:Number = 0)
            emitter.addAction(new MinimumDistance(20, 50));
            emitter.addAction(new RotateToDirection()); 
            //BoundingBox(minX:Number = 0, maxX:Number = 0, minY:Number = 0, maxY:Number = 0, minZ:Number = 0, maxZ:Number = 0, bounce:Number = 1)
            emitter.addAction(new BoundingBox(-200, 200, -150, 150, -200, 200));
            //SpeedLimit(speed:Number, isMinimum:Boolean = false)
            emitter.addAction(new SpeedLimit(100, true)); //最小
            emitter.addAction(new SpeedLimit(200)); //最大
            emitter.addAction(new Move()); 
            //
            renderer.x = 465 / 2;
            renderer.y = 465 / 2;;
            renderer.addEmitter(emitter);
            addChild(renderer);
            renderer.camera.position = new Point3D(0,0,-200);
            renderer.camera.target = new Point3D(0,0,0);
            renderer.camera.projectionDistance = 200;
            //
            var controller:FirstPersonCamera = new FirstPersonCamera(stage,renderer.camera);
            controller.start();
            emitter.start();
            addChild(new Stats());
        }
    }
}


import flash.display.Shape;
class Invader extends Shape{
    public function Invader(){
        graphics.beginFill(0xCCCCCC, 1);
        graphics.drawRect(2,0,1,1);
        graphics.drawRect(8,0,1,1);
        graphics.drawRect(3,1,1,1);
        graphics.drawRect(7,1,1,1);
        graphics.drawRect(2,2,7,1);
        graphics.drawRect(2,3,1,4);
        graphics.drawRect(4,3,3,1);
        graphics.drawRect(3,4,5,2);
        graphics.drawRect(8,3,1,4);
        graphics.drawRect(1,3,1,2);
        graphics.drawRect(0,4,1,3);
        graphics.drawRect(9,3,1,2);
        graphics.drawRect(10,4,1,3);
        graphics.drawRect(3,7,2,1);
        graphics.drawRect(6,7,2,1);
        graphics.endFill();
    }
}