/**
 * Copyright Mark ( http://wonderfl.net/user/Mark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9vgs
 */

// forked from jerryrom's Waterfall
// forked from Hasufel's Space Comet
package {
	
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
[SWF(width=465, height=465, backgroundColor=0x222222, frameRate=60)]
    public class Waterfall extends Sprite {
        private var cvs:BitmapData;     
        private var particles:Array = [];
        private var h:int = stage.stageHeight;
        private var w:int = stage.stageWidth;
        private var h4:int = Math.round(h/4);
        private var c:uint = 0xff81ABD5;
        private var theta:Number = 0;
        private var blur:BlurFilter;

        public function Waterfall(){
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            blur = new BlurFilter(14,14,1);
            cvs = new BitmapData(w,h,true,0);
            addChild(new Bitmap(cvs)) as Bitmap;
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function update(e:Event):void{
            cvs.applyFilter(cvs,cvs.rect,new Point(0,10),blur);
            cvs.lock();
            var n:int = particles.length;
            while(n--) {
                var p:Particle = particles[n];
                p.vx*=0.99;
                p.vy*=1.01;
                p.x+=p.vx;
                p.y+=p.vy;

                cvs.setPixel32(p.x,p.y,p.c);
                if (p.y<0 || p.y>h || p.x<0 || p.x>w || p.vy<0.05){
                    particles.splice(n,1);
                }
                if (p.y>h*0.9){
                    p.vy*=0.8;
                    p.vx=0;
                }
            }
            n = 20;
            var a:Number = 5;
            var b:Number = .1;
            while (n--) {
                createParticle(0, Math.random()*h4, c, Math.cos(theta)+a*Math.random()-b, Math.sin(theta)+a*Math.random()-b, true);
            }
        }

        private function createParticle(xx:Number, yy:Number, c:int, vx:Number, vy:Number, type:Boolean):void {
            var p:Particle = new Particle();
            p.x = xx;
            p.y = yy;
            p.vx = vx;
            p.vy = vy;
            p.c = c;
            particles.push(p);
        }
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:uint;
}