/**
 * Copyright ukkr ( http://wonderfl.net/user/ukkr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9vUd
 */

package  {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	public class PerspectiveProjectionTest extends MovieClip {
		private var _projection:PerspectiveProjection;
		private var _innerProjection:PerspectiveProjection;
		private var _centerPoint:Point;
		private var _innerCenterPoint:Point;
		private var _container:Sprite;
		private var _degree:int;
		private var _panelNum:int = 15;
		private var _panelSize:int = 100;
		
		public function PerspectiveProjectionTest() {
			_centerPoint = new Point( 0, 0 );
			_innerCenterPoint = new Point( 0, 0 );

			_projection = root.transform.perspectiveProjection;
			_projection.projectionCenter = new Point( stage.stageWidth / 2, stage.stageHeight / 2 );
			_projection.fieldOfView = 90;
			_innerProjection = new PerspectiveProjection();
			_innerProjection.projectionCenter = _innerCenterPoint;
			_innerProjection.fieldOfView = 90;
			
			initStage();
			initContainer();
		}
		
		private function initStage():void {
			for ( var i:int = 0; i < _panelNum; i++ ) {
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill( 0x000000, 0.8 );
				sp.graphics.drawRect( -_panelSize / 2, -_panelSize / 2, _panelSize, _panelSize );
				sp.graphics.endFill();
				sp.x = Math.round( stage.stageWidth / _panelNum * i );
				sp.y = stage.stageHeight / 1.5;
				sp.z = -stage.stageHeight / 6;
				sp.rotationY = 90;
				addChild( sp );
			}
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		private function initContainer():void{
			_container = new Sprite;
			_container.graphics.beginFill( 0x000000, 0.8 );
			_container.graphics.drawRect( -stage.stageWidth / 2, -stage.stageHeight / 6, stage.stageWidth, stage.stageHeight / 3 );
			_container.graphics.endFill();
			_container.x = stage.stageWidth / 2;
			//_container.y = stage.stageHeight / 2;
			_container.y = _container.height / 2;
			_container.transform.perspectiveProjection = _innerProjection;
			addChild( _container );
			
			for ( var i:int = 0; i < _panelNum; i++ ) {
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill( 0xffffff, 0.8 );
				sp.graphics.drawRect( -_panelSize / 2, -_panelSize / 2, _panelSize, _panelSize );
				sp.graphics.endFill();
				sp.x = Math.round( _container.width / _panelNum * i - _container.width / 2 );
				sp.z = -20;
				sp.rotationY = 90;
				_container.addChild( sp );
			}
		}
		
		private function enterFrameHandler( e:Event ):void {
			_centerPoint.x = mouseX;
			_centerPoint.y = mouseY;
			_degree++;
			_projection.projectionCenter = _centerPoint;
			_innerCenterPoint.x = Math.sin( Math.PI / 180 * _degree ) * 300;
			_innerProjection.projectionCenter = _innerCenterPoint;
			_container.transform.perspectiveProjection = _innerProjection;
		}
	}
}