/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9v6O
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        
        private var _canvas:BitmapData;
        
        private var _particles:Vector.<Star>;
        public function FlashTest() {
            _canvas = new BitmapData(465,465,false,0x00);
            
            addChild(new Bitmap(_canvas));
            
            const LEN:int = 1000;
            _particles = new Vector.<Star>();
            for( var i:int=0; i<LEN; ++i ) {
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 232*Math.random();
                _particles.push( new Star(Math.cos(angle)*radius+232,Math.sin(angle)*radius+232) );
            }
            addEventListener(Event.ENTER_FRAME,update);
            stage.addEventListener(MouseEvent.MOUSE_DOWN,reset);
        }
        private function reset(e:Event):void{
            for each( var p:Star in _particles ){
                var angle :Number = Math.PI*2*Math.random();
                var radius:Number = 128*Math.random()+64;
                p.x = Math.cos(angle)*radius + mouseX;
                p.y = Math.sin(angle)*radius + mouseY;
                p.vx = ( p.x - mouseX )*0.5;
                p.vy = ( p.y - mouseY )*0.5;
            }
        }

        private function update(e:Event):void{
            _canvas.lock();
            //_canvas.applyFilter(_canvas,_canvas.rect,new Point,new BlurFilter(2,2));
            _canvas.colorTransform(_canvas.rect, new ColorTransform(0.998,0.998,0.998,0.998))
            for each( var p:Star in _particles ){
                p.vx += ( mouseX - p.x ) * 0.02 + (Math.random()-0.5)*0.1;
                p.vy += ( mouseY - p.y ) * 0.02 + (Math.random()-0.5)*0.1;
                
                p.x += p.vx*p.mass;
                p.y += p.vy*p.mass;
                
                p.vx *= 0.99; 
                p.vy *= 0.99;
                
                _canvas.setPixel(p.x,p.y,0xFFFFFF*Math.random()>>0);
            }
            _canvas.unlock();          
        }

    }
}

class Star{
    public var x:Number;
    public var y:Number;
    public var vx:Number =0;
    public var vy:Number =0;
    public var mass:Number =0;
    public function Star(sx:Number,sy:Number){
        x = sx;
        y = sy;
        mass = Math.random()*0.4+0.4;
    }
}

