/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9v05
 */

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;

    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        internal var image :Image;
             
        public function Main()
        {       
            image = new Image(Resources.URL1, true, 100, 100, 200, 200, 0.5);
            
            addChild(image);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.net.*;

class Image extends Sprite
{
    public var _x:Number;
    public var _y:Number;
    public var _w:Number;
    public var _h:Number;
    protected var _a:Number;
    protected var _url:String;

    internal var preloader :Preloader;
    
    public function Image(url:String, preload:Boolean, $x:Number = 0, $y:Number = 0, $w:Number = 0, $h:Number = 0, $a:Number = 0)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);   
        
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _a = $a;
        _url = url;
        
        preloader = new Preloader(_url, this);
        
        //ambiguous initiation of preloader; ideally parent.addChild through Preloader but Loader class does not allow this...
        addChild(preloader);
        addChild(preloader.bgSprite);
        addChild(preloader.fgSprite);
        
        preloader.load(new URLRequest(_url));

    }
    
    public function _init() :void
    {

        
        graphics.clear();
        graphics.lineStyle(1, 0, 0.75);
        graphics.drawRect(_x, _y, _w, _h);

    }
    
    public function addedToStage($e:Event) :void
    {

        
        _init();

        
    }

}

class Preloader extends Loader
{
    public var bgSprite :Sprite = new Sprite;
    public var fgSprite :Sprite = new Sprite;

    //**********
    // _initBG
    protected var _x:Number;
    protected var _y:Number;
    protected var _w:Number;
    protected var _h:Number;
    protected var _a:Number;
    
    //*********
    // _initFG
    protected var __x:Number;
    protected var __y:Number;
    protected var __w:Number;
    protected var __h:Number;
    protected var __a:Number;
    
    protected var _URL:String;
       
    protected var _obj:Object;
       
    public function Preloader(url:String, obj:Object)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _obj = obj;
        
        // _initBG  
        _x  = _obj._x + (_obj._w / 2) - ((_obj._w * 0.75) / 2);
        _y  = _obj._y + (_obj._h / 2) - (60 / 2);
        _w  = (_obj._w * 0.75);
        _h  = 60;
        
        // _initFG
        __x = (_x + 4);
        __y = (_y + 4);
        __w = 0;
        __h = (_h - 8);
        
        _a = (0.5);
        __a = (0.75);
        
        _URL = url;
    }      

    public function _initBG() :void
    {
        bgSprite.graphics.clear         ();
        bgSprite.graphics.lineStyle     (4, 0xFFFFFF, _a);
        bgSprite.graphics.beginFill     (0, _a);
        bgSprite.graphics.drawRoundRect (_x, _y, _w, _h, 12);
        bgSprite.graphics.endFill       ();       
    }
    
    public function _initFG() :void
    {        
        fgSprite.graphics.clear          ();
        fgSprite.graphics.beginFill      (0xFFFFFF, __a);
        fgSprite.graphics.drawRoundRect  (__x, __y, __w, __h, 6);
        fgSprite.graphics.endFill        ();
    }

    public function addedToStage($e:Event) :void
    {       
        _initBG();
        _initFG();
        
        contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onLoaderProgress);
        contentLoaderInfo.addEventListener(Event.COMPLETE, onLoaderComplete);
    }
    
    public function onLoaderProgress($e:ProgressEvent) :void
    {
        var loaderWidth   :Number = (_w - 8);
        var deltaProgress :Number = ($e.bytesLoaded/$e.bytesTotal);
       
        __w = (deltaProgress * loaderWidth);
        
        _initFG();
    }
    
    public function onLoaderComplete($e:Event) :void
    {
        contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, onLoaderProgress);
        contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoaderComplete);
        
        x = (_obj._x + 1);
        y = (_obj._y + 1);
        width = (_obj._w - 1);
        height = (_obj._h - 1);
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function onEnterFrame($e:Event) :void
    {
        fadeOut();
    }
    
    public function fadeOut() :void
    {
        if (_a > 0)
        {
            _a = __a -= 0.05;
            
            _initFG();
            _initBG();
        }
    }

}

class Resources
{
    public static const URL1:String = "http://1000fights.com/wp-content/uploads/2012/02/large-male-looking-for-us.jpg";
    public static const URL2:String = "";
    public static const URL3:String = "";
    public static const URL4:String = "";
    public static const URL5:String = "";
}

