/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9uIG
 */

// forked from Nicolas's [Papervision3D]頂点制御の練習
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.display.Bitmap;
    import flash.display.BitmapData; 
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    public class FlashTest extends BasicView {
    	private var plane:Plane;
    	private var time:int = 0;
    	private var h1:Number = 0;
    	private var h2:Number = 0;
    	private var bmp:Bitmap;
        private var bmd:BitmapData;
        private var loader:Loader; 
        public function FlashTest() {
        	    var url:String = "http://assets.wonderfl.net/images/related_images/e/e4/e4e9/e4e98b57861edb690b03b831d28a6afaf7b99370"
        	    var urlReq:URLRequest = new URLRequest(url);
        	    loader = new Loader();
        	    loader.load(urlReq, new LoaderContext(true)); 
        	    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete); 
        	    
        	          	
            
        }
        
        private function onComplete(e:Event):void { 
            bmd = new BitmapData(loader.width, loader.height, true, 0x000000);
            bmd.draw(loader);
            //bmp = addChild(new Bitmap(bmd)) as Bitmap;
            
            var material:BitmapMaterial = new BitmapMaterial(bmd, true);
            //平面を作る。引数は(material, width, height, segmentsW, segmentsH)
            plane = new Plane(material, 500, 500, 1, 1);
            plane.rotationX = 90;
            //sceneに追加
            scene.addChild(plane);
            //カメラ設定
            camera.y = 800;
            camera.zoom = 80;
            //レンダリング開始
            startRendering();
            //毎フレーム頂点をいじるよ
            addEventListener(Event.ENTER_FRAME, loop);
            
        }
        
        private function loop(e:Event):void{
        	    //左の高さh1と右の高さh2を計算
            h1 = 200 * Math.sin(time * Math.PI / 180);
            h2 = 200 * Math.sin((time + 90) * Math.PI / 180);//位相が90度ずれている
            var v:Array = plane.geometry.vertices;//3Dオブジェクトの各頂点が含まれる配列
            //segmentがW,Hともに1ならば、[0]と[1]が左側、[2]と[3]が右側の頂点を表す
            v[0].z = v[1].z = h1;
            v[2].z = v[3].z = h2;
            
            time += 2;
        }
    }
}