/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9u8g
 */

package {
	import flash.events.*
	import flash.text.*
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.materials.BitmapAssetMaterial;
	import org.papervision3d.materials.utils.MaterialsList;

	public class Pvgw6 extends BasicView {
		private var cube:Cube;
		private var txf:TextField;

		public function Pvgw6(){
			init()

			super(0,0,true);
		}

		private function init():void{
			txf = new TextField();
			txf.text ="MaterialsList & Cube Sample. Click to Start."
			txf.width = stage.stageWidth
			txf.textColor = 0x000000;
			txf.x = stage.stageWidth/2 -130
			txf.y = stage.stageHeight/2 -5
			stage.addChild(txf)
			stage.addEventListener(MouseEvent.CLICK, init3D)
		}

		private function init3D(e:MouseEvent):void{

			stage.removeEventListener(MouseEvent.CLICK, init3D)
			stage.removeChild(txf)
			txf = null;

			var bam1:BitmapAssetMaterial = new BitmapAssetMaterial("AI")
			var bam2:BitmapAssetMaterial = new BitmapAssetMaterial("PS")
			var bam3:BitmapAssetMaterial = new BitmapAssetMaterial("FL")
			var bam4:BitmapAssetMaterial = new BitmapAssetMaterial("DW")
			var bam5:BitmapAssetMaterial = new BitmapAssetMaterial("PR")
			var bam6:BitmapAssetMaterial = new BitmapAssetMaterial("ID")
            var materialsList:MaterialsList = new MaterialsList();
			bam1.smooth = bam2.smooth = bam3.smooth =bam4.smooth =bam5.smooth =bam6.smooth = true;
			materialsList.addMaterial(bam1 ,"front");
			materialsList.addMaterial(bam2 ,"back");
			materialsList.addMaterial(bam3 ,"left");
			materialsList.addMaterial(bam4 ,"right");
			materialsList.addMaterial(bam5 ,"top");
			materialsList.addMaterial(bam6 ,"bottom");			

			cube =new Cube(materialsList,210,210,210,4,4,4);
			scene.addChild(cube);
			_camera.z = 300
			_camera.focus = 600;
			_camera.zoom = 1;
			stage.addEventListener(Event.ENTER_FRAME,enterFrameHandle)
			}

		private function enterFrameHandle(e:Event):void{
			cube.yaw((200- mouseX )/10);
			cube.pitch((200- mouseY )/10);
			startRendering();

			}
	}
}