/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9tgF
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	[SWF(width=480,height=480,backgroundColor=0xffffff,frameRate=30)]
	public class Practice26 extends Sprite {
		private var panel:CardPanel;
		
		public function Practice26() {
			panel = new CardPanel(this.stage.stageWidth,this.stage.stageHeight);
			addChild(panel);
			Card.zoomRect = new Rectangle(120,90,240,360);
			for (var i:int = 0; i < 12; i++) {
				for (var j:int = 0; j < 16; j++) {
					var c:Card = new RoundRectCard(5 + j * 30, 5 + i * 40, 20, 30, getColor(i / 12.0 * 180 + j / 16 * 180, 1.0));
					panel.addCard(c);
				}
			}
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
		}
		
		private function mouseDown(e:MouseEvent):void {
			panel.mouseDown(e);
		}
		
		private function createColor(rv:Number,gv:Number,bv:Number):uint {
			var rr:int = Math.max(0, Math.min(255, rv * 255));
			var gg:int = Math.max(0, Math.min(255, gv * 255));
			var bb:int = Math.max(0, Math.min(255, bv * 255));
			var color:uint = (rr << 16) + (gg << 8) + bb;
			return color;
		}
		
		private function getColor(i:int,s:Number):uint {
			var h:Number = i / 60;
			var ii:Number = Math.floor(h);
			var ff:Number = (h - ii);
			switch(ii) {
				case 0:
					return createColor(1.0, 1.0 - s * (1.0 - ff), 1.0 - s);
				case 1:
					return createColor(1.0 - s * ff, 1.0, 1.0 - s);
				case 2:
					return createColor(1.0 - s, 1.0, 1.0 - s * (1.0 - ff));
				case 3:
					return createColor(1.0 - s, 1.0 - s * ff, 1.0);
				case 4:
					return createColor(1.0 - s * (1.0 - ff), 1.0 - s, 1.0);
				default:
					return createColor(1.0, 1.0 - s, 1.0 - s * ff);
			}
		}
	}
}

import flash.display.MovieClip;
import flash.display.Shape;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.BitmapFilterQuality;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.display.BitmapData;
import flash.display.Bitmap;
class CardPanel extends MovieClip {
	private var clip:MovieClip;
	private var bmpdata:BitmapData;
	private var bmp:Bitmap;
	private var zoomCard:Card = null;
	private var filter:BlurFilter;
	
	public function CardPanel(w:Number, h:Number):void {
		clip = new MovieClip();
		this.addChild(clip);
		bmpdata = new BitmapData( w, h, false, 0xffffff);
		bmp = new Bitmap(bmpdata);
		filter = new BlurFilter(25, 25, BitmapFilterQuality.MEDIUM);
		clip.addChild(bmp);
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	public function addCard(c:Card):void {
		clip.addChild(c);
	}
	
	private function update(e:Event):void {
		if (zoomCard != null) {
			clip.filters = [filter];
		}else {
			clip.filters = [];
		}
		bmpdata.lock();
		bmpdata.fillRect(bmpdata.rect, 0xffffff);
		bmpdata.draw(this);
		if (zoomCard != null)bmpdata.fillRect(bmpdata.rect, 0xaaaaaa);
		bmpdata.unlock();
	}
	
	public function mouseDown(e:MouseEvent):void {
		if (zoomCard != null) {
			if (zoomCard.isContain(e.stageX,e.stageY)) {
				zoomCard.isZoom = false;
				clip.addChild(zoomCard);
				zoomCard = null;
			}
		}else {
			for (var i:int = 0; i < clip.numChildren; i++) {
				if (!(clip.getChildAt(i) is Card)) continue;
				var obj:Card = clip.getChildAt(i) as Card;
				if (obj.isContain(e.stageX, e.stageY)) {
					clip.removeChild(obj);
					this.addChild(obj);
					obj.isZoom = true;
					zoomCard = obj;
					return;
				}
			}
		}
	}
}

class Card extends MovieClip {
	public static var zoomRect:Rectangle = new Rectangle(50, 50, 200, 200);
	public var rect:Rectangle;
	protected var shape:Shape;
	private var num:int = 1;
	public var isZoom:Boolean = false;
	
	public function Card(x:Number,y:Number,w:Number,h:Number):void {
		rect = new Rectangle(x, y, w, h);
		shape = new Shape();
		draw(createRect(num / 100.0));
		addChild(shape);
		addEventListener(Event.ENTER_FRAME, update);
	}
	
	public function isContain(xx:Number, yy:Number):Boolean {
		if (isZoom) {
			return zoomRect.contains(xx, yy);
		}else {
			return rect.contains(xx, yy);
		}
	}
	
	public function update(e:Event):void {
		if (isZoom) {
			if (num == 100) return;
			num *= 2;
			num = Math.min(num, 100);
			if (num == 100) shape.graphics.clear();
			draw(createRect(num / 100.0));
		}else {
			if (num == 1) return;
			num /= 2;
			num = Math.max(num, 1);
			if (num == 1) shape.graphics.clear();
			draw(createRect(num / 100.0));
		}
	}
	
	private function createRect(r:Number):Rectangle {
		var xx:Number = rect.x * (1 - r) + zoomRect.x * r;
		var yy:Number = rect.y * (1 - r) + zoomRect.y * r;
		var ww:Number = rect.width * (1 - r) + zoomRect.width * r;
		var hh:Number = rect.height * (1 - r) + zoomRect.height * r;
		return new Rectangle(xx, yy, ww, hh);
	}
	
	protected function draw(r:Rectangle):void {}
}

class RoundRectCard extends Card {
	private var color:uint=0x00ff00;
	public function RoundRectCard(x:Number,y:Number,w:Number,h:Number,c:uint):void {
		color = c;
		super(x, y, w, h);
	}
	
	protected override function draw(r:Rectangle):void {
		shape.graphics.beginFill(color);
		shape.graphics.drawRoundRect(r.x, r.y, r.width, r.height, r.width / 5, r.height / 5);
		shape.graphics.endFill();
		shape.graphics.lineStyle(1, 0xcccccc);
		shape.graphics.drawRoundRect(r.x, r.y, r.width, r.height, r.width / 5, r.height / 5);
	}
}