/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9suRA
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    import flash.text.*;
    import flash.ui.Keyboard;
    
    import net.hires.debug.Stats;
    
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.render.QuadrantRenderEngine;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.view.BasicView;

    public class Main extends Sprite
    {
        //public var rubik:RubiksCube;
        public var view:BasicView;
        public var mdp:Point = new Point(); // mouse down point
        public var dragPoint:Point = new Point();
        public var bgClicked:Boolean = false;
        public var background:Sprite;
        public var shift:Boolean;
        
        private  var tf:TextField = new TextField();
        
        public static const SCRAMBLE_DEPTH:int = 22;
        public static var tween:Sprite = new Sprite();
        private var planeObj:Plane;

        private var axii:Array = ['x','y','z'];
        
        //エントリ
        public function Main()
        {
            background = new Sprite();
            background.graphics.beginFill(0x0,1);
            background.graphics.drawRect(0,0,465,465);
            background.graphics.endFill();
            addChild(background);     
            addChild(new Stats());
            
            init3DEngine();            
            
            //Planeオブジェクト生成
            //マテリアル設定
            var light:PointLight3D = new PointLight3D(false);
            var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF);
            material.doubleSided = true;
            //光源位置設定
            light.x = 50;
            light.y = 50;
            light.z = -100;
            planeObj = new Plane(material, 40,40, 1,1);
            view.scene.addChild(planeObj);
        }
        
        //初期化
        private function init3DEngine():void
        {
            view = new BasicView(0, 0, true, true, "Target");                        
            view.camera.z = -100;
            //view.buttonMode = true;
            view.renderer = new QuadrantRenderEngine(QuadrantRenderEngine.CORRECT_Z_FILTER);

            
            this.addChild(view);
            this.addEventListener(Event.ENTER_FRAME, onEventRender3D);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, startRotation);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
        }
        
        private function startRotation(event:MouseEvent):void
        {
            
            bgClicked = event.target != background;
            
            stage.addEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.addEventListener(Event.MOUSE_LEAVE, endDrag);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
            
            mdp.x = mouseX;
            mdp.y = mouseY;
            onMove();
        }
        
        public function endDrag(event:Event = null):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_UP, endDrag);
            stage.removeEventListener(Event.MOUSE_LEAVE, endDrag);
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
        }
        
        public function onMove(event:Event=null):void
        {
            var m:Matrix3D;
            var rot:Number;
            if(!bgClicked){           
                if(!shift){//カメラZ軸回転
                    m = Matrix3D.rotationY((mouseX - mdp.x)/150);
                    m = Matrix3D.multiply(m, Matrix3D.rotationX(-(mouseY - mdp.y)/150));
                }
                else {//オブジェクト回転
                    rot = (mouseX < 233)? (mouseY - mdp.y)/150 : (mdp.y - mouseY)/150;
                    rot += (mouseY > 233)? (mouseX - mdp.x)/150 : (mdp.x - mouseX)/150;
                    m = Matrix3D.rotationZ(rot);
                }
                //回転
                planeObj.transform = Matrix3D.multiply(m, planeObj.transform);
                
                
                mdp.x = mouseX;
                mdp.y = mouseY;
            }
            else{
                rot = (mouseX < 233)? (mouseY - mdp.y)/150 : (mdp.y - mouseY)/150;
                rot += (mouseY > 233)? (mouseX - mdp.x)/150 : (mdp.x - mouseX)/150;
                m = Matrix3D.rotationZ(rot);
                //回転
                planeObj.transform = Matrix3D.multiply(m, planeObj.transform); 
                mdp.x = mouseX;
                mdp.y = mouseY;
            }

        }
        
        private function onEventRender3D(e:Event):void        {    
            view.singleRender();
        }
        
        //private var zoom:Number = 0;
        
        private function onKeyDown(event:KeyboardEvent):void        {
            shift = event.shiftKey;
            //if(event.keyCode == 39)zoom = 1;
            //else if(event.keyCode == 37)zoom = -1;
        }
        
        private function onKeyUp(event:KeyboardEvent):void        {
            shift = event.shiftKey;
            //zoom = 0;
        }
        
    }
}

