/**
 * Copyright aaharu ( http://wonderfl.net/user/aaharu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9smd
 */

/*
もうほとんどhttp://wonderfl.net/c/w2ysのForkって感じですが・・・
参考にしながらgetterでcolorを返すカラーピッカーをつくってみた。

追記：
背景変えてみた。sv右はじ行くと黒いね、あとで直す。

直した。
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.MouseEvent;

    public class ColorPicker extends Sprite
    {
        private var _svBmp:Bitmap;
        private var _hBmp:Bitmap;
        private var _rot:uint = 0;
        private var _slider:Sprite;
        private var _circle:Sprite;
        private var _color:uint = 0xFFFFFF;
        
        public function get color():uint
        {
            return _color;
        }
        
        private function bg():void
        {
            this.graphics.beginFill(color);
            this.graphics.drawRect(-100, -100, stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();
        }
        
        public function ColorPicker()
        {
            this.x = this.y = 100;
            
            //sv
            var svbmpd:BitmapData = CreatePickColor.svBmpd(_rot);
            _svBmp = new Bitmap(svbmpd);
            addChild(_svBmp);
            //h
            var hbmpd:BitmapData = CreatePickColor.hBmpd();
            _hBmp = new Bitmap(hbmpd);
            addChild(_hBmp);
            _hBmp.x = 210;
            
            //slider
            _slider = new Sprite();
            _slider.graphics.lineStyle(2);
            _slider.graphics.beginFill(0, 0);
            _slider.graphics.drawRoundRect(-10, -3, 20, 6, 4, 4);
            _slider.graphics.endFill();
            addChild(_slider);
            _slider.x = _hBmp.x + 10;
            _slider.y = _hBmp.y;
            _slider.addEventListener(MouseEvent.MOUSE_DOWN, onSliderDown);
            //circle
            _circle = new Sprite();
            _circle.graphics.lineStyle(1, 0xffffff);
            _circle.graphics.beginFill(0, 0);
            _circle.graphics.drawCircle(0, 0, 4);
            _circle.graphics.endFill();
            var child:Sprite = new Sprite();
            child.graphics.lineStyle(1.5);
            child.graphics.drawCircle(0, 0, 3);
            _circle.addChild(child);
            addChild(_circle);
            _circle.addEventListener(MouseEvent.MOUSE_DOWN, onCircleDown);
        }
        
        private function onSliderDown(e:MouseEvent):void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onSliderMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onSliderUp);
        }
        
        private function onCircleDown(e:MouseEvent):void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onCircleMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onCircleUp);
        }
        
        private function onSliderMove(e:MouseEvent):void
        {
            _slider.y = mouseY;
            if(_slider.y < _hBmp.y)
                _slider.y = _hBmp.y;
            else if(_slider.y >= _hBmp.y+_hBmp.height)
                _slider.y = _hBmp.y + _hBmp.height - 1;
            svColorChange();
            _color = _svBmp.bitmapData.getPixel(_circle.x, _circle.y);
            bg();
        }
        
        private function onCircleMove(e:MouseEvent):void
        {
            _circle.x = mouseX;
            _circle.y = mouseY;
            if(_circle.y < _svBmp.y)
                _circle.y = _svBmp.y;
            else if(_circle.y >= _svBmp.y + _svBmp.height)
                _circle.y = _svBmp.y + _svBmp.height - 1;
            if(_circle.x < _svBmp.x)
                _circle.x = _svBmp.x;
            else if(_circle.x >= _svBmp.x + _svBmp.width)
                _circle.x = _svBmp.x + _svBmp.width - 1;
            _color = _svBmp.bitmapData.getPixel(_circle.x, _circle.y);
            bg();
        }
        
        private function onSliderUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onSliderMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onSliderUp);
            _color = _svBmp.bitmapData.getPixel(_circle.x, _circle.y);
            bg();
        }
        
        private function onCircleUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onCircleMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onCircleUp);
            _color = _svBmp.bitmapData.getPixel(_circle.x, _circle.y);
            bg();
        }
        
        private function svColorChange():void
        {
            removeChild(_svBmp);
            _rot = 359-(_slider.y)*(359/(_hBmp.height));
            var svbmpd:BitmapData = CreatePickColor.svBmpd(_rot);
            _svBmp = new Bitmap(svbmpd);
            addChild(_svBmp);
            setChildIndex(_circle, numChildren-1);
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;

import frocessing.color.ColorHSV;

class CreatePickColor
{
    public static function svBmpd(rot:Number, size:uint = 200):BitmapData
    {
        var bmpd:BitmapData = new BitmapData(size, size, false, 0);
        bmpd.lock();
        for(var y:uint = 0; y < size; y++)
            for(var x:uint = 0; x < size; x++)
                bmpd.setPixel(x, y, (new ColorHSV(rot, x/size, 1-y/size)).toRGB().value);
        bmpd.unlock();
        return bmpd;
    }
    
    public static function hBmpd(size:uint = 200):BitmapData
    {
        var bmpd:BitmapData = new BitmapData(20, size, false, 0);
        bmpd.lock();
        for(var y:uint = 0; y < size; y++)
            for (var x:uint = 0; x < size; x++)
                bmpd.setPixel(x, y, (new ColorHSV(359-y*(359/size))).toRGB().value);
        bmpd.unlock();
        return bmpd;
    }
}