/**
 * Copyright heriet ( http://wonderfl.net/user/heriet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ryZ
 */

// forked from AtuyL's forked from: radian角度をπ範囲に丸める
// forked from uwi's radian角度をπ範囲に丸める
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

// @see http://tail.s288.xrea.com/open/index.php?%A5%E1%A5%E2%BD%F1%A4%AD%2Fradian%B3%D1%C5%D9%A4%F2%A6%D0%C8%CF%B0%CF%A4%CB%B4%DD%A4%E1%A4%EB
public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 500000;
    static private const _PI:Number = Math.PI;
    static private const _PI2:Number = Math.PI * 2;
    
    static private const A:Number = int.MAX_VALUE / Math.PI;
    static private const B:Number = Math.PI / int.MAX_VALUE;
    
    static private var sumError:Number;
    static private var minError:Number;
    static private var maxError:Number;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("からっぽ", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueAngle:Number = lcg.random() * _PI2 - _PI;
                var angle : Number = trueAngle + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = 3.14;
            }
        });
        
        
        _measure("tail_y", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueAngle:Number = lcg.random() * _PI2 - _PI;
                var angle : Number = trueAngle + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = adjustRadian(angle);
                
                var error:Number = Math.abs(trueAngle - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        _measure("keno42", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = Math.atan2(Math.sin(rad),Math.cos(rad));
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        
        _measure("chibitami", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = rad - 2.0 * Math.PI * Math.floor( 0.5 + rad / ( 2.0 * Math.PI ) ) ;
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
       
        _measure("AtuyL_original", function ():void
        {
            var PI2 : Number = Math.PI * 2;
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                rad %= PI2;
                var res : Number = rad - Math.abs(rad) / rad * PI2 * Math.floor(Math.abs(rad) / Math.PI) || 0;
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        
        //constと変数を使うことでPIとabsを省力化。これだけで約20%強高速化する。
        _measure("AtuyL_optimized", function ():void
        {
            var _abs : Number;
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                rad %= _PI2;
                _abs = Math.abs(rad);
                var res : Number = rad - _abs / rad * _PI2 * Math.floor(_abs / _PI);
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        _measure("bk-zen", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueAngle:Number = lcg.random() * _PI2 - _PI;
                var angle : Number = trueAngle + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = Math.sin((angle < 0 ? -angle : angle) % Math.PI > Math.PI / 2 ? - angle % Math.PI : angle % Math.PI) * Math.PI;
                
                var error:Number = Math.abs(trueAngle - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        _measure("uwitenpen", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueAngle:Number = lcg.random() * _PI2 - _PI;
                var angle : Number = trueAngle + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = angle > 0 ? ((angle % (Math.PI * 2)) - Math.PI) : (Math.PI - (-angle % (Math.PI * 2)));
                
                var error:Number = Math.abs(trueAngle - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        _measure("ma1on", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueAngle:Number = lcg.random() * _PI2 - _PI;
                var angle : Number = trueAngle + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = adjustRadianM(angle);
                
                var error:Number = Math.abs(trueAngle - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        _measure("kaikoga", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = int(rad * A) * B;
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        //回数によってこっちの方が速くなったり遅くなったり
        _measure("kaikoga_literal", function ():void
        {
            var lcg:LinearCongruentialGenerator = new LinearCongruentialGenerator();
            var sumError:Number = 0.0;
            var minError:Number = Number.MAX_VALUE;
            var maxError:Number = 0.0;
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                var trueRad:Number = lcg.random() * _PI2 - _PI;
                var rad : Number = trueRad + _PI2 * int(Math.random() * 100000 - 50000);
                var res : Number = int(rad * 683565275.2581217) * 1.462918079948384e-9;
                
                var error:Number = Math.abs(trueRad - res)
                sumError += error;
                if (error < minError ) minError = error; 
                if (error > maxError ) maxError = error;
            }
            Main.sumError = sumError;
            Main.minError = minError;
            Main.maxError = maxError;
        });
        _debug("errorSum: " + Main.sumError + "\nerrorMax: " + Main.maxError + "\nerrorMin: " + Main.minError + "\n");
        
        
        
        _measure("undo", function ():void
        {
            for (var i:uint = 0; i < 10; i++) {
                var angle : Number = Math.random() * 1000;
                while(Math.abs(angle)>180){ angle -= 360; _debug("ちんこ"); }
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private function adjustRadian(angle:Number):Number{
  var pi:Number = Math.PI;
  if (-pi < angle && angle <= pi) return angle;
  angle %= pi*2;
  if (angle <= -pi) return angle + pi*2;
  if (pi < angle) return angle - pi*2;
  return angle;
    }
    
    private function adjustRadianM(angle:Number):Number
    {
  var tmp:int;
  var pi:Number = Math.PI;
  if (-pi < angle && angle <= pi) return angle;
  tmp = -angle / pi;
  return angle + pi*tmp;
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}
}
class LinearCongruentialGenerator {
  
  private static const A:Number = 1664525;
  private static const C:Number = 1013904223;
  private static const M:Number = 0x100000000;
  private var x:Number;
  
  public function LinearCongruentialGenerator(seed:Number = 1.0):void
  {
    initialize(seed);
  }
  public function initialize(seed:Number = 1.0):void
  {
    x = seed;
  }
  public function random():Number
  {
    x = (x * A + C) % M;
    return x / M;
  }
  
}