/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9r3M
 */

/**
 * Copyright marcsali ( http://wonderfl.net/user/marcsali )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hQid
 */
// forked from actionscriptbible's Chapter 32 Example 1
package {
// Importation de toutes les bibliotheques.
  import flash.display.*;
  import flash.events.*;
  import flash.media.Video;
  import flash.net.NetConnection;
  import flash.net.NetStream;
  import flash.text.*;
  import flash.utils.Timer;
//  Declaration de classe qui contienet variables et classes.  
    public class ch32ex1 extends Sprite {
    protected var video:Video;
    protected var nc:NetConnection;
    protected var ns:NetStream;
    protected var nsDuration:Number;
    protected var playPauseButton:TestButton;
    protected var progressTF:TextField;
    protected var progressTimer:Timer;
     
    public function ch32ex1() {
      video = new Video(360, 250);
      video.x = video.y = 20;
      addChild(video);
      
      nc = new NetConnection();
      nc.connect(null);
      
      ns = new NetStream(nc);
      ns.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
      
      video.attachNetStream(ns);
      ns.play("http://sansali.perso.sfr.fr/videos/cannonball.flv");
      
      playPauseButton = new TestButton(24, 24, "||");
      playPauseButton.x = 20; 
      playPauseButton.y = 250;
      playPauseButton.addEventListener(MouseEvent.CLICK, onPlayPauseClicked);
      addChild(playPauseButton);
      
 
      progressTF = new TextField();
      progressTF.height = 24; 
      progressTF.width = 140;
      progressTF.x = 300; 
      progressTF.y = playPauseButton.y + 40;
      progressTF.defaultTextFormat = new TextFormat("_sans", 11, 0, false, false, false, null, null, "center");
      progressTF.selectable = false;
      addChild(progressTF);
      
      
      progressTimer = new Timer(100);
      progressTimer.addEventListener(TimerEvent.TIMER, onUpdateProgress);
      progressTimer.start();     
    } 
    
    protected function onNetStatus(event:NetStatusEvent):void {
      switch (event.info.code) {
        case "NetStream.Play.Stop":
          ns.seek(0);
          ns.pause();
          playPauseButton.label.text = ">";
          break;
      }
    }
 
    protected function onPlayStatus(event:Object):void {
      trace(event);
    }
    
    protected function onUpdateProgress(event:TimerEvent = null):void {
      progressTF.text = ns.time.toFixed(1) + "s / "
                      + nsDuration.toFixed(1) + "s";
      progressTimer.delay = 100;
    }
    
    protected function onBackClicked(event:MouseEvent):void {
      var seekTime:Number = ns.time - 1;
      seekTime = Math.max(0, seekTime);
      ns.seek(seekTime);
      onUpdateProgress();
    }
    
    protected function onForwardClicked(event:MouseEvent):void {
      var seekTime:Number = ns.time + 1;
      seekTime = Math.min(seekTime, nsDuration);
      ns.seek(seekTime);
      onUpdateProgress();
    }
    
    protected function onPlayPauseClicked(event:MouseEvent):void {
      if (playPauseButton.label.text == ">") {
        ns.resume();
        playPauseButton.label.text = "||";
      } else {
        ns.pause();
        playPauseButton.label.text = ">";
      }
    }
    
    protected function onFullScreenClicked(event:MouseEvent):void {
      stage.fullScreenSourceRect = video.getRect(stage);
      stage.displayState = StageDisplayState.FULL_SCREEN;
    }
  }
}
import flash.display.*;
import flash.text.*;
class TestButton extends Sprite {
  public var label:TextField;
  public function TestButton(w:Number, h:Number, labelText:String) {
    graphics.lineStyle(0.5, 0, 0, true);
    graphics.beginFill(0xa0a0a0);
    graphics.drawRoundRect(0, 0, w, h, 8);
    label = new TextField();
    addChild(label);
    label.defaultTextFormat = new TextFormat("_sans", 11, 0, true, false, false, null, null, "center");
    label.width = w;
    label.height = h;
    label.text = labelText;
    label.y = (h - label.textHeight)/2 - 2;
    buttonMode = true;
    mouseChildren = false;
  }
}

