/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9qFa
 */

/*
 * 使いやすいように整理してみた。
 * 
 * 
 * */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import nochump.util.zip.*;
    import flash.display.Bitmap;

    public class Main2 extends Sprite {
        private var _zipLoader:ZipLoader;
        
        public function Main2() {
            var urlStr:String = (this.loaderInfo.url);
            if (urlStr.substr(0, String("http://swf.wonderfl.net/").length) == "http://swf.wonderfl.net/") {
                //wonderfl用
                urlStr = "http://www.mztm.jp/wonderfl/";
            }else {
                //wordpressだとフルパスじゃないとダメみたいなので
                urlStr = urlStr.substr(0, urlStr.lastIndexOf("/")) + "/";
            }
            init(urlStr + "images.zip");
        }
        
        private function init(url:String):void {
            _zipLoader = new ZipLoader();
            _zipLoader.add(url);
            _zipLoader.addEventListener(Event.COMPLETE, zipLoadComp);
            _zipLoader.start();
        }
        private function zipLoadComp(event:Event):void {
            var n:int = _zipLoader.contents.length;
            for (var i:int = 0; i < n; i++) {
                if(_zipLoader.contents[i].type == "image"){
                    var bitmap:Bitmap = _zipLoader.contents[i].getBitmap();
                    bitmap.x = 50 + 50 * i;
                    bitmap.y = 50 + 50 * i;
                    this.addChild(bitmap);
                }
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.Loader;
import flash.events.Event;
import flash.net.URLLoader;
import flash.net.URLRequest;
import nochump.util.zip.*;
class ZipLoader {
    private var _listener:Function = function(event:Event):void { };
    private var _url:String;
    private var _imageLoaderCount:int;
    private var _imageLoadedCount:int;
    public var contents:Array;
    
    public function ZipLoader() { };
    public function add(url:String):void {
        _url = url;
    }
    public function start():void {
        if (_url.length < 5) {
            return;
        }
        var loader_obj:URLLoader = new URLLoader();
        loader_obj.addEventListener(Event.COMPLETE, loadComp);
        loader_obj.dataFormat = "binary";
        loader_obj.load(new URLRequest(_url));
    }
    private function loadComp(event:Event):void {
        contents = [];
        _imageLoaderCount = 0;
        _imageLoadedCount = 0;
        var zipFile:ZipFile = new ZipFile(event.target.data);
        var n:int = zipFile.entries.length;
        for(var i:int = 0; i < n; i++) {
            var entry:ZipEntry = zipFile.entries[i];
            contents[i] = new Content(entry);
            contents[i].type = typeFormName(entry.name);
            switch (contents[i].type) {
                case "image":
                    contents[i].loader = new Loader();
                    contents[i].loader.loadBytes(zipFile.getInput(entry));
                    contents[i].loader.contentLoaderInfo.addEventListener(Event.COMPLETE, atComp);
                    _imageLoaderCount ++;
                    break;
                case "text":
                    contents[i].string = zipFile.getInput(entry).toString();
                    break;
                default:
            }
        }
    }
    private function atComp(event:Event):void {
        _imageLoadedCount ++;
        if (_imageLoadedCount == _imageLoaderCount) {
            _listener(event);
        }
    }
    
    private var EXTENSIONS:Object = {
        //"swf":["swf"], "movie":["mp4", "flv"],未対応
        "image":["jpg", "jpeg", "gif", "png"],
        "text":["txt", "js", "xml", "php", "asp", "as", "html", "htm", "php", "py", "mxml"]
        };
    private function typeFormName(name:String):String {
        var str:String = name.substr(name.lastIndexOf(".") + 1).toLowerCase();
        var extension:String;
        for (var p:String in EXTENSIONS) { 
            var n:int = EXTENSIONS[p].length;
            for (var i:int = 0; i < n; i++) {
                extension = EXTENSIONS[p][i];
                if(extension == str){
                    str = p;
                    break;
                }
            }
        }
        return str;
    }
    
    public function addEventListener(type:String,listener:Function):void{
        _listener = listener;
    }    
}
class Content {
    public var entry:ZipEntry;
    public var type:String;
    public var loader:Loader;
    public var string:String;
    public function Content(entry:ZipEntry):void {
        this.entry = entry;
    }
    public function getBitmap():Bitmap {
        return Bitmap(loader.contentLoaderInfo.content);
    }
    public function getText():String {
        return string;
    }
}