/**
 * Copyright dairyu ( http://wonderfl.net/user/dairyu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9q21
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(width = "465", height = "465", frameRate = "40", backgroundColor = "#000000")]

     /**
     * @author Dairyu
     * 
     * パンプキン・カーニバルー！ｗ
     * tween24ステキすぎｗ
     * 
     */

    public class Main extends Sprite {

        public var container:Sprite;
        public var hitArea_mc:HitAreaMC;
        public var background_mc:BackgroundMC;
        public var pumpkin_mc:PumpkinMC;
        private var step:uint = 2;
        private var ave:uint = 5;
        public var preAreaX:Number
        public var moveFLG:Boolean = false;

        public function Main () {
            addEventListener(Event.ADDED_TO_STAGE,init)
        }

        private function init(e:Event=null) {
            removeEventListener(Event.ADDED_TO_STAGE, init)
            makeObject()
        }

        private function makeObject():void {
            container = new Sprite()
            addChild(container)

            hitArea_mc = new HitAreaMC()
            addChild(hitArea_mc)

            background_mc = new BackgroundMC()
            addChildAt(background_mc, 0)

            setEvent();

        }

        public function creatMC(e:Event) {
            var random:Number = Math.ceil(Math.random() * ave)
            if (random <= step) {
                pumpkin_mc = new PumpkinMC();
                container.addChild(pumpkin_mc)
            }
        }

        public function setEvent():void {
            addEventListener(Event.ENTER_FRAME, moveAwayHandler)
            addEventListener(Event.ENTER_FRAME, creatMC)
        }

        public function moveAwayHandler(e:Event) {

            if(moveFLG){
                hitArea_mc.x = -stage.stageWidth
                hitArea_mc.y = -stage.stageHeight
            }

            if(preAreaX != mouseX){
                moveFLG = false
                hitArea_mc.x = mouseX
                hitArea_mc.y = mouseY
            }else {
                moveFLG = true
            }
            preAreaX = mouseX
        }
    }
}



//***************************************************
//PRIVATE CLASS
//***************************************************
import flash.display.Sprite;
import flash.display.GradientType;
import flash.events.Event;
import flash.geom.Matrix;

//ヒットエリア
class HitAreaMC extends Sprite {

    private var area_size:uint = 10;

    public function HitAreaMC() {
        graphics.beginFill(0xFF0000, 0);
        graphics.drawCircle(0, 0, area_size);
        graphics.endFill()
    }

}


//背景
class BackgroundMC extends Sprite {

    private var grd_color:Array = [0x000000, 0x003366, 0x063D74];
    private var grd_alpha:Array = [100     , 100     , 100       ];
    private var grd_posit:Array = [0       , 210     , 255       ];
    private var grd_matrix:Matrix;
    
    public function BackgroundMC() {
       addEventListener(Event.ADDED_TO_STAGE,init)
    }

    private function init(e:Event) {
        removeEventListener(Event.ADDED_TO_STAGE,init)
        grd_matrix = new Matrix();
        grd_matrix.createGradientBox(stage.stageWidth,stage.stageHeight,-Math.PI/2,75,75)
        graphics.beginGradientFill(GradientType.LINEAR,grd_color , grd_alpha, grd_posit,grd_matrix)
        graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight)
        graphics.endFill()
    }

}



//------------------------------------------------------
//
import flash.display.Sprite;
import flash.display.BlendMode;
import flash.events.Event;
import a24.tween.Tween24;
import a24.tween.EventTween24;

class PumpkinMC extends Sprite {

    public var gh_mc:Sprite;
    public var gh_color:uint = Math.random() * 0x1000000;
    public var gh_size:uint = Math.random() * 30 + 10;
    public var gh_padding:uint = 0.7;
    public var fireball_mc:FireBall;
    public var explode_mc:EffectExplode;
    public var tweenMC:Tween24;
    public var tweenGH:Tween24;

    public function PumpkinMC () {
        addEventListener(Event.ADDED_TO_STAGE,init)
    }

    private function init(e:Event=null) {
        removeEventListener(Event.ADDED_TO_STAGE, init)
        x = Math.random() * stage.stageWidth
        y = Math.random() * (stage.stageHeight*0.3) + (stage.stageHeight*0.7)
        blendMode = BlendMode.ADD
        setEvent()
        
        //
        gh_mc = new Sprite();
        gh_mc.alpha = 0.5;
        gh_mc.scaleX = 0.1;
        gh_mc.scaleY = 0.1;
        gh_mc.visible = false;

        //Pumpkin
        gh_mc.graphics.beginFill(0xFFFFFF,1);
        gh_mc.graphics.drawCircle(0, 0, gh_size*0.5);//face
        gh_mc.graphics.drawCircle( -gh_size * 0.2, -gh_size * 0.18, gh_size * 0.09);//left eye
        gh_mc.graphics.drawCircle(  gh_size * 0.2, -gh_size * 0.18, gh_size * 0.09);//right eye
        gh_mc.graphics.moveTo( -gh_size * 0.35, -gh_size * 0.05);//mouth
        gh_mc.graphics.lineTo( -gh_size * 0.2 ,gh_size * 0.1);
        gh_mc.graphics.lineTo( -gh_size * 0.1 , gh_size * 0.03);
        gh_mc.graphics.lineTo( 0 , gh_size * 0.1);
        gh_mc.graphics.lineTo(  gh_size * 0.1 , gh_size * 0.03)
        gh_mc.graphics.lineTo(  gh_size * 0.2 ,gh_size * 0.1);
        gh_mc.graphics.lineTo(  gh_size * 0.35, -gh_size * 0.05);
        gh_mc.graphics.lineTo(  gh_size * 0.2 , gh_size * 0.3);
        gh_mc.graphics.lineTo(  gh_size * 0.1 , gh_size * 0.2);
        gh_mc.graphics.lineTo(  0, gh_size * 0.3);
        gh_mc.graphics.lineTo( -gh_size * 0.1 , gh_size * 0.2);
        gh_mc.graphics.lineTo( -gh_size * 0.2 , gh_size * 0.3);//mouth end
        gh_mc.graphics.endFill()

        gh_mc.graphics.beginFill(gh_color,0.8);
        gh_mc.graphics.drawCircle(0, 0, gh_size * 0.8);
        gh_mc.graphics.endFill()

        addChild(gh_mc)
        startMotion()

    }

    //
    public function startMotion(){
        tweenGH = Tween24.serial(
            Tween24.tween(gh_mc, 1 ,Tween24.ease.ElasticOut).scale(1).visible(true),
            Tween24.tween(gh_mc, 0.5 , Tween24.ease.BackIn).scale(0.1).visible(false)
        )
        tweenGH.play()
        tweenGH.onComplete(stopMotion);

    }

    //
    private function setEvent():void {
        addEventListener(Event.ENTER_FRAME,cheackHit)
    }

    public function cheackHit(e:Event) {
        if (hitTestObject(Object(parent.parent).hitArea_mc)) {
            clickHandler()
        }
    }

    

    private function clickHandler() {
        removeEventListener(Event.ENTER_FRAME,cheackHit)
        buttonMode = false;
        mouseEnabled = false;
        gh_mc.mouseEnabled = false;
        tweenGH.stop();
        tweenMC = Tween24.tween(this, 0.7 , Tween24.ease.BackOut).scale(Math.random()*2+1).y(Math.random() * (stage.stageHeight * 0.3)).rotation(Math.random() * 180 + 180);
        tweenMC.play()
        tweenMC.onComplete(bomb)

        addEventListener(Event.ENTER_FRAME, Blinking);

    }
    public function Blinking(e:Event) {
        gh_mc.rotation += 50;
    }

    public function bomb() {
        gh_mc.visible = false;
        explode_mc = new EffectExplode(0,0,gh_color);
        explode_mc.scaleX = scaleX
        explode_mc.scaleY = scaleY
        //explode_mc.blendMode = BlendMode.OVERLAY
        addChild(explode_mc)

        var fireCount:uint = Math.random() * 40 + 5;

        for (var i:uint = 1; i <= fireCount; i++) {
            fireball_mc = new FireBall(gh_color)
            addChild(fireball_mc)
        }

        var timer_mc:Tween24 = Tween24.tween(this, 2)
        timer_mc.play()
        timer_mc.onComplete(stopMotion)

    }

    

    //
    public function stopMotion() {

        //
        removeEventListener(Event.ENTER_FRAME,cheackHit)
        removeEventListener(Event.ENTER_FRAME, Blinking);

        //
        gh_mc.graphics.clear()
        removeChild(gh_mc)

        //
        Object(parent).removeChild(this)
    }

    

}





//------------------------------------------------------
//
class FireBall extends Sprite {

    public var tweenFB:Tween24;
    public var ball_size:Number = Math.random() * 8 + 1;
    
    public function FireBall(getColor:uint) {
        graphics.beginFill(getColor, 1);
        graphics.drawCircle(0, 0, ball_size);
        graphics.endFill()
        graphics.beginFill(0xFFFFFF, 1);
        graphics.drawCircle(0, 0, ball_size*0.5);
        graphics.endFill()
        alpha  = Math.random() * 0.2 + 0.8
        scaleX = scaleY = Math.random() * 1.3 + 0.2
        tweenFB = Tween24.tween(this, Math.random() * 2 , Tween24.ease.CubicOut).alpha(0).x(Math.random() * 150 - 75).y(Math.random() * 150 - 75).scale(0.1).visible(false);
        tweenFB.play()
        tweenFB.onComplete(stopMotion);
    }
    public function stopMotion() {
        Object(parent).removeChild(this)
    }

}





//------------------------------------------------------
//
class EffectExplode extends Sprite {

   public var gh_mc:Sprite;
   public var gh_size:Number = 30;
   public var gh_color:uint;
   public var tweenMC:Tween24;

   public function EffectExplode (setX:Number,setY:Number,setColor:uint) {
        x = setX;
        y = setY;
        gh_color = setColor;
        addEventListener(Event.ADDED_TO_STAGE,init)
    }

    private function init(e:Event=null) {
        removeEventListener(Event.ADDED_TO_STAGE, init)
        gh_mc = new Sprite();
        gh_mc.graphics.lineStyle(1, gh_color, 0.7, false, "none");
        gh_mc.graphics.beginFill(gh_color, 0.8);
        gh_mc.graphics.drawCircle(0, 0, gh_size);
        gh_mc.graphics.endFill()
        gh_mc.scaleX = 0.1;
        gh_mc.scaleY = 0.1;
        addChild(gh_mc)
     
        mouseEnabled = false;
        gh_mc.mouseEnabled = false;

        startMotion()
    }

    public function startMotion(){
        tweenMC = Tween24.tween(gh_mc, 1 , Tween24.ease.CubicOut).scale(1).alpha(0).visible(false);
        tweenMC.onComplete(stopMotion);
        tweenMC.play();
    }

    public function stopMotion() {

        gh_mc.graphics.clear()
        removeChild(gh_mc)
        Object(parent).removeChild(this)
    }

}


