/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9pqx
 */

package { 
    import flash.display.Sprite; 
    import flash.events.MouseEvent; 
    public class MouseClick extends Sprite { 
        private var _button:MyButton; 

        public function MouseClick() {
            // ボタンのインスタンスを生成 
            _button = new MyButton(); 
            _button.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver); 
            _button.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut); 

            // 表示リストに追加 
            addChild(_button); 

            // ボタンの位置を設定 
            _button.x = 182; 
            _button.y = 50; 
        } 

        private function onMouseOver(e:MouseEvent):void 
        { 
            _button.over(); 
        } 

        private function onMouseOut(e:MouseEvent):void 
        { 
            _button.out(); 
        } 
    } 
} 

import flash.display.Sprite; 

class MyButton extends Sprite { 
    private var _over:Sprite; 
    
    public function MyButton () { 
        // 描画色を#666666に設定 
        graphics.beginFill(0x333333); 
        // 角丸の長方形を描画 
        graphics.drawRoundRect(0, 0, 100, 22, 15); 
        graphics.endFill(); 

        // マウス・オーバー時に表示させるSpriteのインスタンスを生成 
        _over = new Sprite(); 
        // 描画色を赤#ff0000に設定 
        _over.graphics.beginFill(0xff0000); 
        // 角丸の長方形を描画 
        _over.graphics.drawRoundRect(0, 0, 100, 22, 15); 
        _over.graphics.endFill(); 
        // 非表示に設定 
        _over.visible = false; 
        // 表示リストに追加 
        addChild(_over); 

        // マウス・カーソルを手のカーソルに変える 
        buttonMode = true; 
    } 

    public function over():void { 
        // マウス・オーバー時の画像を表示 
        _over.visible = true; 
    } 

    public function out():void { 
        // マウス・オーバー時の画像を非表示 
        _over.visible = false; 
    } 
} 
