/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9pKx
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=142
    public class Euler142 extends Sprite {
        private var _tf : TextField;
  
        public function Euler142() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText("" + solve(1000) + "\n");
            var g : int = getTimer();
            _tf.appendText("" + (g - s) + " ms\n");
        }
        
        private function solve(N : int) : int
        {
            var map : Object = {};
            // (a^2-b^2)/2 だけを集める。
            for(var a : int = 2;a <= N;a++){
                for(var b : int = 2 - (a & 1);b < a;b += 2){
                    var v : int;
                    v = (a * a - b * b) >> 1;
                    if(!map[v])map[v] = [];
                    map[v].push([a, b]);
                }
            }
            for(var key : String in map){
                var val : Array = map[key];
                // 集めた物のうち同じ値同士について、(a^2+b^2)/2を計算して、残りの1対がどっちも平方数ならOK
                for(var i : int = 0;i < val.length;i++){
                    for(var j : int = i + 1;j < val.length;j++){
                        var y : int = (val[i][0] * val[i][0] + val[i][1] * val[i][1]) >> 1;
                        var z : int = (val[j][0] * val[j][0] + val[j][1] * val[j][1]) >> 1;
                        if(z > y){ var d : int = z; z = y; y = d; }
                        var sqp : Number = Math.sqrt(y + z); if(sqp != int(sqp))continue;
                        var sqm : Number = Math.sqrt(y - z); if(sqm != int(sqm))continue;
                        var x : int = int(key);
                          
                        _tf.appendText("" + x + "\t" + y + "\t" + z + "\t" + (x + y + z) + "\n");
                        // これが最小値かどうかはとても怪しいけど
                        return x + y + z;
                    }
                }
            }
            
            return 0;
        }
    }
}