/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9pGv
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    public class FlashTest extends Sprite {        
        public var format:TextFormat = new TextFormat("_等幅", 12, 0x000000);
        
        public function FlashTest() {
            Wonderfl.capture_delay(40);
            
            var postCode:TextField = newTextField("0-9\\-",10,10,80,8,1,"郵便番号　　");
            var address:TextField = newTextField("^",10,40,300,0,2,"住所　　　　");
            var name_ja:TextField = newTextField("^",10,90,120,0,1,"名前（漢字）");
            var name_kana:TextField = newTextField("ア-ン",10,120,120,0,1,"名前（カナ）");
            var tell:TextField = newTextField("0-9\\-",10,150,80,12,1,"電話番号　　");
            var mail:TextField = newTextField("0-9a-zA-Z\\-_@.",10,180,150,0,1,"メール　　　");
            writtenMessage();
        }
        
        public function newTextField(restrict:String, x:Number = 0, y:Number = 0, width:Number = 120, maxChars:int = 0, numLines:int = 1, label:String = "ラベル"):TextField{
            var labelText:TextField = new TextField();
            labelText.defaultTextFormat = format;
            labelText.mouseEnabled = false;
            labelText.text = label;
            labelText.x = x;
            labelText.y = y+1;
            labelText.width = labelText.textWidth+5;
            labelText.height = labelText.textHeight+5;
            
            var inputText:TextField = new TextField();
            inputText.defaultTextFormat = format;
            inputText.border = true;
            inputText.type = "input";
            inputText.x = labelText.width+20;
            inputText.y = y;
            inputText.width = width;
            inputText.height = 18*numLines;
            inputText.maxChars = maxChars;
            inputText.multiline = numLines > 1 ? true : false;
            inputText.wordWrap = inputText.multiline;
            inputText.restrict = restrict;

            
            addChild(labelText);
            addChild(inputText);
            
            return inputText;
        }
        
        private function writtenMessage():void{
            var message:TextField = new TextField();
            message.defaultTextFormat = format;
            message.x = 20;
            message.y = 220;
            message.width = 430;
            message.height = 220;
            message.multiline = message.wordWrap = true;
            message.appendText("ーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーーー\n");
            message.appendText("「TextField.restrictを使ってみた」\n\n");
            message.appendText("　TextField.restrictは");
            message.appendText("入力フィールド（TextFiled.type = \"input\"）時に\n　フィールド内に入力できる文字を指定できる\n\n");
            message.appendText("・使い方\n");
            message.appendText("「TextField.restrict = 文字列」で直接指定する\n");
            message.appendText("　-：範囲, ^：除外, \\\\:エスケープ\n\n");
            message.appendText("　TextField.restrict = \"あいうえお\";  ⇒ 「あいうえお」のみ入力可能\n");
            message.appendText("　TextField.restrict = \"^あいうえお\"; ⇒ 「あいうえお」のみ入力不可\n");
            message.appendText("　TextField.restrict = \"あ-お\";  ⇒ 「あいうえお」のみ入力可能\n");
            message.appendText("　TextField.restrict = \"^あ-お\"; ⇒ 「あいうえお」のみ入力不可\n");
            message.appendText("　TextField.restrict = \"0-9\\\\-\"; ⇒ 「0123456789-」のみ入力可能\n");
            message.appendText("　TextField.restrict = \"^\\\\-\\\\^\\\\\\\\\"; ⇒ 「-^\\」のみ入力不可\n");
            message.appendText("\n※スクリプトで直接入力した文字列には適応されない\n");
            addChild(message);
        }


    }
}