/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9osX
 */

//http://www.gamedesign.jp/flash/yomi/yomi.html
//の左上でぽにょってしてるやつを作りたかったけど何か違う・・・。
package {
    import flash.display.Sprite;
    import flash.events.*;
        [SWF(width = 465, height = 465, frameRate = 60, backgroundColor = 0xffffff)]
    public class PonyoBall extends Sprite {
    	
    		private const radius:int = 100;	
    		private const center:int = radius * 1.1;
    		private const color:int = 0xaaaaff;
    		private const numSize:int = 10;
    		private const numStep:int = 2 * numSize - 2;
    		
    		private var _sprites:Vector.<Sprite>;
    		private var animationStep:int;
    	
        public function PonyoBall(){
			_sprites = new Vector.<Sprite>(numSize);//0-9
			var tmp:int;
			for(var i:int = 0; i < numSize; i++){
				tmp = radius * (1.00 + 0.01*i)
				_sprites[i] = Circle(tmp,color);
				if(i != 0)_sprites[i].visible = false;
			}
            animationStep = 0;
            stage.addEventListener(MouseEvent.CLICK,function():void{
            		if(!stage.hasEventListener(Event.ENTER_FRAME)){
            			addEventListener(Event.ENTER_FRAME,onEnterFrame);
            		}
            });
        }
        
        private function onEnterFrame(e:Event):void{
        		if(animationStep != numStep - 1){
        			if(animationStep < numSize - 1){
        				_sprites[animationStep + 1].visible = true;
        			}
        			else{
        				_sprites[numStep - animationStep].visible = false;
        			}
        			animationStep++;
        			return;
        		}
        		_sprites[1].visible = false;
        		removeEventListener(Event.ENTER_FRAME,onEnterFrame);
        		animationStep = 0;
        }
        
        private function Circle(rad:int,color:int):Sprite{
        		var sp:Sprite = new Sprite();
        		sp.graphics.beginFill(color);
        		sp.graphics.drawCircle(center,center,rad);
        		sp.graphics.endFill();
        		addChild(sp);
        		return sp;	
        }
    }
}