/**
 * Copyright hibibi ( http://wonderfl.net/user/hibibi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9oYg
 */

//UnionPlatformに挑戦してみた。
//みんなでやればおもしろいけど、
//一人だけだとただのバネ運動のサンプルになるなあ

package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import net.user1.reactor.ClientEvent;
	import net.user1.reactor.IClient;
	import net.user1.reactor.Reactor;
	import net.user1.reactor.ReactorEvent;
	import net.user1.reactor.Room;
	import net.user1.reactor.RoomEvent;
	import net.user1.reactor.RoomManager;
	
	public class Main extends Sprite 
	{
		
		//UnionPlatformのホスト
		private const HOST:String = "tryunion.com";
		//使用するポート
		private const PORT:int = 9100;
		//バネ係数
		private const SPRING:Number = 0.1;
		//摩擦係数
		private const FRICTION:Number = 0.9;
		//線を描くレイヤー
		private var _lineLayer:Sprite;
		//クライアントアプリケーション
		private var _reactor:Reactor;		
		//ルーム
		private var _room:Room;
		//自身のクライアント
		private var _self:IClient;
		//ベジェエリアの色（各クライアントによって異なる）
		public var col:uint = Math.random() * 0xFFFFFF;
		//icon（表示用）の配列
		private var _iconList:/*Sprite*/Array;
		//バネ計算用のポイントオブジェクト
		private var _v:Point = new Point();
		private var _s:Point = new Point();
		
		
		
		/****************************************************************************************
		 * コンストラクタ
		 */
		public function Main():void {
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.quality = StageQuality.HIGH;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;
			if (this.stage) this.init();
			else addEventListener(Event.ADDED_TO_STAGE, this.init);
			
		}
		/****************************************************************************************
		 * 初期化
		 */
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, this.init);
			// entry point
			this.addChild(this._lineLayer = new Sprite());
			this._iconList = [];
			
			this._reactor = new Reactor();
			this._reactor.addEventListener(ReactorEvent.READY, this._reactorOnReady);
			this._reactor.connect(HOST, PORT);
			//this._tweenColor();
		}
		/****************************************************************************************
		 * _reactorの準備が完了
		 */
		private function _reactorOnReady(e:ReactorEvent):void {
			this._reactor.removeEventListener(ReactorEvent.READY, this._reactorOnReady);
			this._self = this._reactor.getClientManager().self();
			this._room = this._reactor.getRoomManager().createRoom("lineRoom2")
			this._room.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE, this._clientOnUpdate);
			this._room.addEventListener(RoomEvent.CLIENT_COUNT, this._clientOnCount);
			this._room.join();
			this.stage.addEventListener(MouseEvent.CLICK, this._stageOnClick);
			this.addEventListener(Event.ENTER_FRAME, this._onUpdate);
		}
		/****************************************************************************************
		 * アップデート処理
		 */
		private function _onUpdate(e:Event):void {
			this._v.x += (mouseX - this._s.x) * SPRING;
			this._v.y += (mouseY - this._s.y) * SPRING;
			this._s.x += (this._v.x *= FRICTION);
			this._s.y += (this._v.y *= FRICTION);
			this._self.setAttribute("x", String(this._s.x));
			this._self.setAttribute("y", String(this._s.y));
		}
		/****************************************************************************************
		 * デバッグ用
		 */
		private function _stageOnClick(e:MouseEvent):void {
			
		}
		/****************************************************************************************
		 * _roomのclientの数が変化
		 */
		private function _clientOnCount(e:RoomEvent):void {
			
			var num:int = this._room.getClients().length;
			var id:String;
			var i:int;
			
			if (this._iconList.length != 0) {
				for (i = 0; i < this._iconList.length; i++) {
					this.removeChild(this._iconList[i]);
				}
				this._iconList = [];
			}
			
			for (i = 0; i < num; i++) {
				id = e.target.getClientIDs()[i];
				var s:Sprite = this._createIcon(id);
				this._iconList.push(this.addChild(s));
			}
			
		}
		/****************************************************************************************
		 * ここでは図形を描画している
		 */
		private function _clientOnUpdate(e:RoomEvent):void {
			var p:Array = _room.getClients();
			var g:Graphics = this.graphics;
			var g2:Graphics = this._lineLayer.graphics;
			var nxt:int;
			
			g.clear();
			g2.clear();
			g2.lineStyle(1,0xCCCCCC);
			g.beginFill(col);
			
			g.moveTo((Number(p[0].getAttribute("x")) + Number(p[p.length - 1].getAttribute("x"))) / 2, (Number(p[0].getAttribute("y")) + Number(p[p.length - 1].getAttribute("y"))) / 2);
			g2.moveTo(p[0].getAttribute("x"), p[0].getAttribute("y"));
			
			for (var i:int = 0; i < p.length; i++) {
				nxt = (i + 1) % p.length;
				g.curveTo(Number(p[i].getAttribute("x")), Number(p[i].getAttribute("y")), (Number(p[nxt].getAttribute("x")) + Number(p[i].getAttribute("x"))) / 2, (Number(p[nxt].getAttribute("y")) + Number(p[i].getAttribute("y"))) / 2);
				g2.lineTo(p[nxt].getAttribute("x"), p[nxt].getAttribute("y"));
				this._iconList[i].x = p[i].getAttribute("x");
				this._iconList[i].y = p[i].getAttribute("y");
			}
			g.endFill();
		}
		/****************************************************************************************
		 * ユーザーアイコンの生成
		 */
		private function _createIcon(str:String):Sprite {
			var s:Sprite = new Sprite();
			var txt:TextField = new TextField();
			s.graphics.beginFill(0x0);
			s.graphics.drawCircle(0, 0, 3);
			s.graphics.endFill();
			txt.selectable = false;
			txt.text = "user" + str;
			txt.textColor = 0x666666;
			txt.x = 10;
			txt.y = -10;
			s.addChild(txt);
			return s;
		}
		
	}
	
}