/**
 * Copyright poiasd ( http://wonderfl.net/user/poiasd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9m6E
 */

/**
 * ステージクリックで切り替え
 * 
 * テキストについてはこちら
 * http://ja.wikipedia.org/wiki/%E3%83%8A%E3%83%9D%E3%83%AA%E3%82%BF%E3%83%B3%E5%95%8F%E9%A1%8C
 */
package {
    
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.text.engine.EastAsianJustifier;
    import flash.text.engine.ElementFormat;
    import flash.text.engine.FontDescription;
    import flash.text.engine.LineJustification;
    import flash.text.engine.TextBaseline;
    import flash.text.engine.TextBlock;
    import flash.text.engine.TextElement;
    import flash.text.engine.TextJustifier;
    import flash.text.engine.TextLine;
    import flash.text.engine.TextRotation;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.core.easing.IEasing;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    
    [SWF (width = "465", height = "465", frameRate = "45", backgroundColor = "0xFFFFFF")]
    
    public class Main extends Sprite {
        
        private const _TEXT:String = "ある日、私は森に迷ってしまった。\n夜になりお腹も減ってきた。\nそんな中、一軒のお店を見つけた。\n「ここはとあるレストラン」\n変な名前の店だ。\n私は人気メニューの「ナポリタン」を注文する。\n数分後、ナポリタンがくる。私は食べる。\n･･･なんか変だ。しょっぱい。変にしょっぱい。頭が痛い。\n私は苦情を言った。\n店長:「すいません作り直します。御代も結構です。」\n数分後、ナポリタンがくる。私は食べる。今度は平気みたいだ。\n私は店をでる。\nしばらくして、私は気づいてしまった･･･\nここはとあるレストラン･･･\n人気メニューは･･･ナポリタン･･･";
        
        private var _letterList:Vector.<String>;
        private var _elementFormat:ElementFormat;
        private var _textJustifier:TextJustifier;
        private var _hContainer:Sprite;
        private var _hRectangle:Rectangle;
        private var _hAtomData:Vector.<TextLine>;
        private var _hPositions:Vector.<Number>;
        private var _vContainer:Sprite;
        private var _vRectangle:Rectangle;
        private var _vAtomData:Vector.<TextLine>;
        private var _vPositions:Vector.<Number>;
        private var _backGround:Sprite;
        
        public function Main() {
            _init();
        }
        
        private function _init():void {
            stage.scaleMode = "noScale";
            graphics.beginFill(0xF2F2F2);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            _letterList = Vector.<String>(_TEXT.split("\n"));
            
            _elementFormat = new ElementFormat();
            _elementFormat.color = 0x101010;
            _elementFormat.fontDescription = new FontDescription("ＭＳ 明朝, _明朝");
            _elementFormat.fontSize = 12;
            _elementFormat.locale = "ja";
            
            _textJustifier = new EastAsianJustifier("ja", LineJustification.UNJUSTIFIED);
            
            _createHorizontalData();
            _createVerticalData();
            
            _backGround = addChild(new Sprite()) as Sprite;
            _backGround.graphics.beginFill(0x0000FF, 0.08);
            _backGround.graphics.drawRect(_hRectangle.x, _hRectangle.y, _hRectangle.width, _hRectangle.height);
            _backGround.graphics.endFill();
            
            stage.addEventListener(MouseEvent.CLICK, _clickHandler);
        }
        
        private var _isHorizontally:Boolean = true;
        private var _easingList:Array = [Cubic.easeOut, Bounce.easeOut, Elastic.easeOut];
        private var _index:int = 0;
        private var _isPlaying:Boolean = false;
        
        private function _clickHandler(event:MouseEvent):void {
            if (_isPlaying) return;
            _isPlaying = true;
            var easing:IEasing = _easingList[_index];
            var current:Vector.<TextLine>;
            var target:Vector.<TextLine>;
            var fromPos:Vector.<Number>;
            var toPos:Vector.<Number>;
            var color:uint;
            var rect:Rectangle;
            if (_isHorizontally) {
                current = _hAtomData;
                target = _vAtomData;
                fromPos = _hPositions;
                toPos = _vPositions;
                color = 0x00FF00;
                rect = _vRectangle;
                _isHorizontally = false;
            } else {
                current = _vAtomData;
                target = _hAtomData;
                fromPos = _vPositions;
                toPos = _hPositions;
                color = 0x0000FF;
                rect = _hRectangle;
                _isHorizontally = true;
                _index = ++_index < 3 ? _index : 0;
            }
            BetweenAS3.tween(_backGround, {alpha:0}, null, 0.5).play();
            var dummy:Sprite = new Sprite();
            var length:int = target.length;
            var count:int = 0;
            for (var i:int = 0; i < length; i++) {
                var t:ITween = BetweenAS3.delay(BetweenAS3.tween(dummy, {x:0}, null, 0), 0.5 + Math.random());
                t.addEventListener(TweenEvent.COMPLETE, completeHandler(i));
                t.play();
            }
            function completeHandler(i:int):Function {
                return function(event:TweenEvent):void {
                    event.target.removeEventListener(TweenEvent.COMPLETE, arguments.callee);
                    current[i].visible = false;
                    target[i].visible = true;
                    BetweenAS3.tween(target[i], {x:toPos[i * 2], y:toPos[i * 2 + 1]}, {x:fromPos[i * 2], y:fromPos[i * 2 + 1]}, 2, easing).play();
                    count++;
                    if (count >= length) {
                        _backGround.graphics.clear();
                        _backGround.graphics.beginFill(color, 0.08);
                        _backGround.graphics.drawRect(rect.x, rect.y, rect.width, rect.height);
                        _backGround.graphics.endFill();
                        t = BetweenAS3.delay(BetweenAS3.tween(_backGround, {alpha:1}, {alpha:0}, 0.5), 2);
                        t.onComplete = function():void {_isPlaying = false;};
                        t.play();
                    }
                };
            }
        }
        
        private function _createHorizontalData():void {
            var textBlock:TextBlock = new TextBlock();
            textBlock.baselineZero = TextBaseline.ASCENT;
            textBlock.lineRotation = TextRotation.ROTATE_0;
            textBlock.textJustifier = _textJustifier;
            
            _hContainer = addChild(new Sprite()) as Sprite;
            _hAtomData = new Vector.<TextLine>();
            
            var offset:int = 0;
            for (var i:int = 0; i < _letterList.length; i++) {
                var textElement:TextElement = new TextElement(_letterList[i], _elementFormat);
                textBlock.content = textElement;
                var textLine:TextLine = textBlock.createTextLine(null);
                var atom:TextLine = null;
                offset += (textLine.height + 10);
                var length:int = textLine.atomCount;
                for (var j:int = 0; j < length; j++) {
                    var center:Number = textLine.getAtomCenter(j);
                    atom = textBlock.createTextLine(atom, 0, 0, true);
                    atom.x = center - atom.width * 0.5;
                    atom.y = offset;
                    _hContainer.addChild(atom);
                    _hAtomData.push(atom);
                }
            }
            _hAtomData.fixed = true;
            
            _hRectangle = _hContainer.getRect(this);
            var offsetX:int = (465 - _hRectangle.width >> 1) - _hRectangle.x;
            var offsetY:int = (465 - _hRectangle.height >> 1) - _hRectangle.y;
            _hPositions = new Vector.<Number>();
            length = _hAtomData.length;
            for (i = 0; i < length; i++) {
                atom = _hAtomData[i];
                _hPositions[i * 2]     = (atom.x += offsetX);
                _hPositions[i * 2 + 1] = (atom.y += offsetY);
            }
            _hPositions.fixed = true;
            _hRectangle.offset(offsetX, offsetY);
            _hRectangle.inflate(15, 15);
        }
        
        private function _createVerticalData():void {
            var textBlock:TextBlock = new TextBlock();
            textBlock.baselineZero = TextBaseline.ROMAN;
            textBlock.lineRotation = TextRotation.ROTATE_90;
            textBlock.textJustifier = _textJustifier;
            
            _vContainer = addChild(new Sprite()) as Sprite;
            _vAtomData = new Vector.<TextLine>();
            
            var offset:int = 0;
            for (var i:int = 0; i < _letterList.length; i++) {
                var textElement:TextElement = new TextElement(_letterList[i], _elementFormat);
                textBlock.content = textElement;
                var textLine:TextLine = textBlock.createTextLine(null);
                var atom:TextLine = null;
                offset -= (textLine.width + 10);
                var length:int = textLine.atomCount;
                for (var j:int = 0; j < length; j++) {
                    var center:Number = textLine.getAtomCenter(j);
                    atom = textBlock.createTextLine(atom, 0, 0, true);
                    atom.x = offset;
                    atom.y = center - atom.height * 0.5;
                    _vContainer.addChild(atom);
                    _vAtomData.push(atom);
                }
            }
            _vAtomData.fixed = true;
            
            _vRectangle = _vContainer.getRect(this);
            var offsetX:int = (465 - _vRectangle.width >> 1) - _vRectangle.x;
            var offsetY:int = (465 - _vRectangle.height >> 1) - _vRectangle.y;
            _vPositions = new Vector.<Number>();
            length = _vAtomData.length;
            for (i = 0; i < length; i++) {
                atom = _vAtomData[i];
                atom.visible = false;
                _vPositions[i * 2]     = (atom.x += offsetX);
                _vPositions[i * 2 + 1] = (atom.y += offsetY);
            }
            _vPositions.fixed = true;
            _vRectangle.offset(offsetX, offsetY);
            _vRectangle.inflate(15, 15);
        }
        
    }
    
}