/**
 * Copyright yanbaka ( http://wonderfl.net/user/yanbaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9lXz
 */

// ドラッグすると暫くしてからテキストがドロップするの略
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	[SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "30")]
	public class DragDropText extends Sprite
	{
		private var _cntTf:TextField;
		private var labels:String = "wonderfl";
		private var texts:Array = [];
		private var particles:Array = [];
		
		private var _background:BitmapData;
		private var _canvas:Sprite;
		
		private var lPoint:Point;
		private var down:Boolean = false;
		
		
		public function DragDropText()
		{
			_background = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			addChild(new Bitmap(_background));
			
			_canvas = new Sprite();
			addChild(_canvas);
			
			var format:TextFormat = new TextFormat();
			format.size = 25;
			format.font = "Verdana";
			format.color = 0xFF99CC;
			
			var bmd:BitmapData
			var l:int = labels.length;
			for (var i:int=0; i<l; i++)
			{
				var label:TextField = new TextField();
				label.defaultTextFormat = format;
				label.autoSize = TextFieldAutoSize.LEFT;
				label.text = labels.charAt(i);
				bmd = new BitmapData(label.width, label.height, true, 0x0);
				bmd.draw(label);
				texts[i] = bmd;
			}
			
			_cntTf = new TextField();
			_cntTf.defaultTextFormat = format;
			_cntTf.autoSize = TextFieldAutoSize.RIGHT;
			_cntTf.x = stage.stageWidth - 10;
			_cntTf.y = stage.stageHeight - 35;
			addChild(_cntTf);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private function update(e:Event):void
		{
			_background.applyFilter(_background, _background.rect, new Point(), new BlurFilter());
			_background.colorTransform(_background.rect, new ColorTransform(0.9, 0.4, 0.9));
			if(down)
			{
				var cnt:int = Math.random()*5+2;
				while(cnt--)
				{
					var rx:Number = mouseX + Math.random()*50-25;
					var ry:Number = mouseY + Math.random()*50-25;
					var text:Text = new Text(rx, ry);
					_canvas.addChild(text);
					text.bitmapData = texts[0];
					var temp:BitmapData = texts.shift();
					texts.push(temp);
					particles.push(text);
				}
			}
			
			var i:int = particles.length;
			_cntTf.text = String(i);
			while(i--)
			{
				var p:Text = particles[i];
				p.t *= 0.97;
				if(p.t <= 0.4)
				{
					p.alpha *= 0.9;
					p.vy += 3;
					p.vy *= 0.9;
					p.y += p.vy;
					p.my *= 1.2;
					p.transform.matrix = new Matrix(1, 0, 0, p.my, p.x, p.y);
				}
				if(p.y > stage.stageHeight)
				{
					_canvas.removeChild(p);
					p = null;
					particles.splice(i, 1);
				}
			}
			
			_background.draw(_canvas);
			lPoint = new Point(mouseX, mouseY);
		}
		
		private function mouseDownHandler(e:MouseEvent):void
		{
			down = true;
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			down = false;
		}
	}
}
	import flash.display.Bitmap;
	

class Text extends Bitmap
{
	public var t:Number = 1;
	public var my:Number = 1;
	public var vy:Number = 1;
	
	public function Text(x:Number, y:Number)
	{
		this.x = x;
		this.y = y;
	}
}