/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9k5p
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var ball:Ball;
		private var vx:Number;
		private var vy:Number;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			ball = new Ball();
			//ボールをステージ中央に配置
			ball.x = stage.stageWidth / 2;
			ball.y = stage.stageHeight / 2;
			//ボールの速さを決定
			vx = Math.random() * 5 + 30;
			vy = Math.random() * 5 + 30;
			//ボールを表示
			addChild(ball);
			//
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event):void
		{
			//ボールを動かす
			ball.x += vx;
			ball.y += vy;
			//ステージ端の位置を取得
			var left:Number = 0;
			var right:Number = stage.stageWidth;
			var top:Number = 0;
			var bottom:Number = stage.stageHeight;
			//ステージの端に行ったら方向を変える
			if(ball.x + ball.radius > right)
			{
				ball.x = right - ball.radius;
				vx *= -1;
			}
			else if(ball.x - ball.radius < left)
			{
				ball.x = left + ball.radius;
				vx *= -1;
			}
			if(ball.y + ball.radius > bottom)
			{
				ball.y = bottom - ball.radius;
				vy *= -1;
			}
			else if(ball.y - ball.radius < top)
			{
				ball.y = top + ball.radius;
				vy *= -1;
			}
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=5, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}