/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9jka
 */

package 
{
    /**
    sound by @AlainMikuni
    **/
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    [SWF(width="465",height="465",backgroundColor="0x000000",frameRate="60")]
    public class Main extends Sprite
    {
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        private var arr:Array = [];
        
        public function Main():void 
        {
            Wonderfl.capture_delay(32);
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound005.mp3");
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            arr = draw();
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 10);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(event:Event):void 
        {
            
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, false, 0);
            
            for (var i:int = 0; i < 512; i++)
            {
                var sp:Sprite = arr[i] as Sprite;
                var data:Number = bytes.readFloat();
                sp.alpha = data;
                sp.scaleX = data;
            }
        }
        
        private function draw():Array
        {
            var master_arr:Array = [];
            for (var i:int = 0; i < 32; i++)
            {
                for (var j:int = 0; j < 16; j++)
                {
                    var _num:int = Math.round(Math.random() * 1);
                    var sp:Sprite = new Sprite();
                    var _width:Number = stage.stageWidth / 32;
                    var _height:Number = stage.stageHeight / 16;
                    sp.graphics.beginFill(0x80ABA9);
                    sp.graphics.drawRect(0,0,_width/3,_height);
                    sp.graphics.endFill();
                    sp.x = _width * i + _width/3;
                    sp.y = _height * j;
                    addChild(sp);
                    master_arr.push(sp);
                }
            }
            return master_arr;
        }
    }
}