/**
 * Copyright applicott ( http://wonderfl.net/user/applicott )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9jhJ
 */

package {
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.utils.flash_proxy;
	
	import frocessing.color.ColorHSV;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Bounce;

	import flash.display.Graphics;
	public class Main extends Sprite
	{
		private static var  NUM:int=29;
		private static var  T:int=100;
		private var sp:Vector.<Circle> = new Vector.<Circle>(NUM*NUM);
		private var i:int;
		private var j:int;
		private var cx:int;
		private var cy:int;
		private var r:int=3;
		private var _circle:Circle;
	
		
		public function Main():void{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.LOW; 
			graphics.beginFill(0x000000);
			graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			graphics.endFill();
			for(i=0;i<NUM;i++){
				cx=i*T;
				for(j=0;j<NUM;j++){
					
					var hsv:ColorHSV = new ColorHSV(i*4+j*3,1,1);
					
					_circle = new Circle(r,hsv.toRGB().value);
					_circle.alpha=0.8;
					_circle.vx = 3+0.1*j+i;
					_circle.vy = 4;	
					_circle.vz = 3;			
					_circle.x = 50*Math.cos(i*NUM+j)+200;
					_circle.y = 50*Math.sin(i*NUM+j)+200;
					_circle.z = 50*Math.tan(i*NUM+j)+200;
					
					_circle.filters = [new BlurFilter(90, 6, 1)];
					_circle.blendMode = BlendMode.ADD;
					sp[i*NUM+j]=_circle;
					addChild(_circle);

				}
				
			}
		//	stage.addEventListener(MouseEvent.CLICK,onMouseClick);
			addEventListener(Event.ENTER_FRAME,onFrame);
		}
		
		private function onFrame(e:Event):void{
			for(i=0;i<NUM;i++){
				for(j=0;j<NUM;j++){
					sp[i*NUM+j].move();
					if(sp[i*NUM+j].x < 10 || sp[i*NUM+j].x > stage.stageWidth ){ sp[i*NUM+j].vx *= -1; }
					if(sp[i*NUM+j].y < 10 || sp[i*NUM+j].y > stage.stageHeight) { sp[i*NUM+j].vy *= -1; }
					if(sp[i*NUM+j].z < 0 || sp[i*NUM+j].z > stage.stageWidth) { sp[i*NUM+j].vz *= -1; }
				}
			}
		}
		
		private function onMouseClick(e:MouseEvent):void{		
			for(var i:int=0;i<sp.length;i++){
				sp[i].x=i*5;
				sp[i].y=50;
				sp[i].z=i*10;
				sp[i].vx=1;
				sp[i].vy=2;
				sp[i].vz=5;
				sp[i].flag*=-1;
			}
		}

	}
}


import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.Point;


class Circle extends Sprite {
	public var vx:Number;
	public var vy:Number;
	public var vz:Number;
	private var a_x:Number = 0.0; 
	private var a_y:Number = 0.2; // 重力y
	private var a_z:Number = 0.0; 
	private var rub:Number = 1.01; 
	private var ela:Number = 0.80; 
	public var radius:Number;
	public var flag:int=1;
	public function Circle(_radius:Number, _fillColor:uint = 0x000000) {
		graphics.beginFill(_fillColor);
		graphics.drawCircle(0, 0, _radius);
		graphics.endFill();
		radius = _radius
		
	}
	public function move():void {
		if(x < stage.stageWidth - width*2) vx += a_x;
		if(y < stage.stageHeight - width*2) vy += a_y;
		if(z < stage.stageHeight - width*2) vz += a_z;
		vx /= rub;
		vy /= rub;
		vz /= rub;
		if((x + vx) < 0 || (x + vx) > stage.stageWidth) {
			vx = -vx/ela;
		}
		if((y + vy) < 0 || (y + vy) > stage.stageHeight) {
			vy = -vy/ela;
		}
		if((z + vz) < 0 || (z + vz) > stage.stageWidth) {
			vz = -vz/ela;
		}
		
		x += vx;
		y += vy;
		z += vz;
		
		if(flag==1&&(Math.abs(vx) < 0.01 || Math.abs(vx) >90)) vx = 20;
		if(flag==1&&(Math.abs(vy) < 0.01 || Math.abs(vy) >90)) vy = 20;

		if(flag==-1&&(Math.abs(vz) < 0.05 || Math.abs(vz) >90)){
			vz = 20; vx=25; vy=15;
		} 
		if((Math.abs(vz) < 0.05 || Math.abs(vz) >90)) vz = 20;
		
	}
	

}