/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9jBD
 */

package  
{
	import Box2D.Collision.b2AABB;
	import Box2D.Collision.Shapes.b2PolygonDef;
	import Box2D.Collision.Shapes.b2PolygonShape;
	import Box2D.Collision.Shapes.b2Shape;
	import Box2D.Collision.Shapes.b2ShapeDef;
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import Box2D.Dynamics.b2BodyDef;
	import Box2D.Dynamics.b2DebugDraw;
	import Box2D.Dynamics.b2World;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * ...
	 * @author 9re
	 */
	[SWF(frameRate="30", backgroundColor="#666666")]
	public class CreatingWorld extends Sprite
	{
		private var world:b2World;
		private var simulator:b2World;
		
		public function CreatingWorld() 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var worldAABB:b2AABB = new b2AABB();
			worldAABB.lowerBound.Set( -10, -10);
			worldAABB.upperBound.Set(60, 60);
			
			var gravity:b2Vec2 = new b2Vec2(0, 9.8);
			var doSleep:Boolean = true;
			
			world = new b2World(worldAABB, gravity, doSleep);
			simulator = new b2World(worldAABB, gravity, doSleep);
			
			var floorDef:b2BodyDef = new b2BodyDef();
			floorDef.position.Set(20, 20);
			floorDef.angle = Math.PI / 10;
			var floor:b2Body = world.CreateBody(floorDef);
			
			var floorShapeDef:b2PolygonDef = new b2PolygonDef();
			floorShapeDef.SetAsBox(10, 0.3);
			floor.CreateShape(floorShapeDef);
			
			var floor2Def:b2BodyDef = new b2BodyDef();
			floor2Def.position.Set(30, 28);
			floor2Def.angle = -Math.PI / 8;
			
			var floor2:b2Body = world.CreateBody(floor2Def);
			floor2.CreateShape(floorShapeDef);
			
			
			var object0Def:b2BodyDef = new b2BodyDef();
			object0Def.position.Set(20, 1);
			var object0:b2Body = world.CreateBody(object0Def);
			var object0ShapeDef:b2PolygonDef = new b2PolygonDef();
			object0ShapeDef.SetAsBox(0.8, 0.8);
			object0ShapeDef.density = 1;
			object0ShapeDef.restitution = 0.25;
			
			object0.CreateShape(object0ShapeDef);
			object0.SetMassFromShapes();
			
			var object1Def:b2BodyDef = new b2BodyDef();
			object1Def.position.Set(15, 1);
			var object1:b2Body = world.CreateBody(object1Def);
			object1.SetLinearVelocity(new b2Vec2(5, 0));
			object1.SetAngularVelocity(-Math.PI * 2);
			object1.CreateShape(object0ShapeDef);
			object1.SetMassFromShapes();
			
			
			var floorInSimulator:b2Body = simulator.CreateBody(floorDef);
			floorInSimulator.CreateShape(floorShapeDef);
			var floor2InSimulator:b2Body = simulator.CreateBody(floor2Def);
			floor2InSimulator.CreateShape(floorShapeDef);
			
			
			var object0InSimulator:b2Body = simulator.CreateBody(object0Def);
			object0InSimulator.SetUserData("object0");
			object0InSimulator.CreateShape(object0ShapeDef);
			object0InSimulator.SetMassFromShapes();
		
			var object1InSimulator:b2Body = simulator.CreateBody(object1Def);
			object1InSimulator.SetUserData("object1");
			object1InSimulator.CreateShape(object0ShapeDef);
			object1InSimulator.SetLinearVelocity(new b2Vec2(5, 0));
			object1InSimulator.SetAngularVelocity(-Math.PI * 2);
			object1InSimulator.SetMassFromShapes();
			
			var j:int;
			for (var i:int = 1; i < 31; ++i) {
				for (j = 0; j < 10; ++j)
					simulator.Step(1 / 30, 8);
				drawSimulation();
			}
			
			
			var debugDraw:b2DebugDraw = new b2DebugDraw();
			debugDraw.m_alpha = 1;
			debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
			debugDraw.m_sprite = this;
			debugDraw.m_drawScale = 10;
			world.SetDebugDraw(debugDraw);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		}
		
		private function drawSimulation():void {
			for (var i:b2Body = simulator.GetBodyList(); i; i = i.GetNext()) {
				switch (i.GetUserData()) {
				case "object0":
				case "object1":
					var color:uint = (i.GetUserData() == "object0") ? 0xff0000 : 0xff;
					var sp:Sprite = new Sprite();
					sp.graphics.beginFill(color, 0.1);
					sp.graphics.drawRect( -8, -8, 16, 16);
					sp.x = i.GetPosition().x * 10;
					sp.y = i.GetPosition().y * 10;
					sp.rotation = i.GetAngle() * 180 / Math.PI;
					addChild(sp);
					break;
				default:
					break;
				}
			}
		}
		
		private function onEnterFrameHandler(e:Event):void 
		{
			world.Step(1 / 30, 8);
		}
		
	}

}