/**
 * Copyright Takema.Terai ( http://wonderfl.net/user/Takema.Terai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9id3
 */

// forked from narutohyper's nexus one pagefilp
// forked from narutohyper's turn the pages transition
package {
/*-----------------------------------------------
nexus pagefilp

iPhone的なページめくり、、をしたいという作品を見て
そういえば、昔似た感じの物作ったなーっと・・・
ひっぱり出してきてWonderfl用にごにょごにょしてみました。

でも、iPhoneは持ってないので、正確にこんなのかどうなのかはわかりませんｗ
CMなどで見る限りはただのスクロールの様な気もしますが・・・
とりあえず、ページめくりっぽくしてます。
画像を左にドラッグでページが進み、右にドラッグでページが戻ります。

ちなみにやっぱりソースは長いです^^;

▲ボタンも押せるようにしたかったけど、さらにソースが長くなるので割愛

@narutohyper

------------------------------------------------*/
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.Shape;

    import flash.system.LoaderContext;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;

    import flash.net.URLRequest;
    import flash.text.*;

    [SWF(width = 465, height = 465, frameRate = 24)]
    public class Main extends Sprite {

        //後々外部xmlからの読み込みに対応させるられるよう、XMLで、画像のURLを設定
        private var dataXml:XML =
            <menu>
                    <imgurl>http://marubayashi.net/archive/sample/images/nexus.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/21.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/22.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/23.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/24.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/25.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/26.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/27.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/28.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/29.jpg</imgurl>
                    <imgurl>http://marubayashi.net/archive/sample/images/30.jpg</imgurl>
            </menu>;

        private var backImg:Sprite;
        private var information:TextField;
        private var dataCounter:uint=0;
        private var dataArray:Array;
        private var imgArray:Array;

        private var progress:Sprite
        private var bar:Sprite

        private var nowPage:int=-1;
        private var mainFrame:Sprite;
        private var firstPos:Number=0;
        private var oldPos:Number=0;
        private var course:String;

        private var go:Sprite;
        private var back:Sprite;
            


        public function Main() {

            dataArray = new Array();
            imgArray = new Array();
            backImg=new Sprite;
            backImg.x=(464-238)/2

            mainFrame=new Sprite;
            addChild(backImg);
            addChild(mainFrame);

            //取り込んだXMLデータの中の画像URL情報を配列に収納
            for each (var item:String in dataXml.imgurl) {
                dataArray.push(item)
            }
            
            //画像の読み込み開始
            imgLoader(0)

            //簡易progressBar
            progress=new Sprite()
            progress.graphics.beginFill(0x666666,1)
            progress.graphics.drawRect(0,0,102,10)
            progress.x=(464-102)/2
            progress.y=(464-10)/2
            bar=new Sprite()
            bar.graphics.beginFill(0x6666FF,1)
            bar.graphics.drawRect(0,0,100,8)
            bar.x=1
            bar.y=1
            bar.width=0
            addChild(progress)
            progress.addChild(bar)

        }


        //画像読み込み
        private function imgLoader(no:uint):void {
            var loader:customLoader = new customLoader();
            loader.load(new URLRequest(dataArray[no]), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,loaded);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, error); 

            function loaded(e:Event):void {
                if (no==0) {
                    //最初の画像は、背景
                    backImg.addChild(loader.content)
                } else {
                    imgArray.push(loader);
                }
                nextProc()
            }

            function error(e:IOErrorEvent):void {
                nextProc()
            }

            function nextProc():void {
                dataCounter++
                bar.width+=10
                if (dataArray.length>dataCounter) {
                    loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,loaded);
                    loader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, error); 

                    imgLoader(dataCounter)
                } else {
                    init();
                }
            }
        }



        private function init():void {
            removeChild(progress)
            //メイン画像の配置

            for (var i:uint=0;i<imgArray.length;i++) {
                imgArray[i].content.scaleX=imgArray[i].content.scaleY=186/imgArray[i].content.width
                imgArray[i].visible=false;
                mainFrame.addChild(imgArray[i]);
            }

            mainFrame.buttonMode = true;
            mainFrame.useHandCursor=true
            mainFrame.addEventListener(MouseEvent.MOUSE_DOWN,imageHandler)
            stage.addEventListener(MouseEvent.MOUSE_UP,imageHandler)

            mainFrame.x=(464-mainFrame.width)/2;
            mainFrame.y=97
            var msk:Shape=new Shape()

            msk.graphics.beginFill(0xFFFFFF,1)
            msk.graphics.drawRect(0,0,mainFrame.width,mainFrame.height)
            msk.x=mainFrame.x
            msk.y=mainFrame.y
            mainFrame.mask=msk

            //P表示用
            information=new TextField();
            information.selectable=false;
            information.mouseEnabled=false;
            information.width=200
            var format:TextFormat=new TextFormat();
            format.align='center'
            format.color=0xFFFFFF
            format.size=12;
            format.font='_ゴシック';
            information.defaultTextFormat=format
            information.x=(464-200)/2
            information.y=80
            addChild(information)
            information.text="1/10"

            //ナビゲート用▲
            go=new Sprite();
            back=new Sprite();
            go.x=(464/2)-20
            go.y=357
            back.x=(464/2)+20
            back.y=357
            addChild(go)
            addChild(back)
            go.graphics.beginFill(0xFFFFFF,0.8)
            go.graphics.moveTo(-5,0)
            go.graphics.lineTo(6,-6)
            go.graphics.lineTo(6,6)
            go.graphics.endFill()

            back.graphics.beginFill(0xFFFFFF,0.8)
            back.graphics.moveTo(5,0)
            back.graphics.lineTo(-6,-6)
            back.graphics.lineTo(-6,6)
            back.graphics.endFill()
            back.visible=false
            imgArray[0].visible=true;
            nowPage=0
        }


        private function informationSet():void {
            information.text=String(nowPage+1)+'/'+String(imgArray.length)
            if (nowPage==0) {
                back.visible=false
            } else {
                back.visible=true
            }
            if (nowPage==imgArray.length-1) {
                go.visible=false
            } else {
                go.visible=true
            }
        }


        private function imageHandler(e:MouseEvent):void {
            if (e.type==MouseEvent.MOUSE_DOWN) {
                firstPos=this.mouseX;
                oldPos=this.mouseX;
                this.addEventListener(MouseEvent.MOUSE_MOVE,mouseMove)
                course='';
                mainFrame.setChildIndex(imgArray[nowPage], mainFrame.numChildren-1);

            } else if (e.type==MouseEvent.MOUSE_UP) {
                this.removeEventListener(MouseEvent.MOUSE_MOVE,mouseMove)
                if (course=='right') {
                    if (imgArray[nowPage].x<=0) {
                        imgArray[nowPage].move(course,false)
                    } else {
                        imgArray[nowPage].move(course,true)
                        nowPage--
                    }
                } else if (course=='left') {
                    if (imgArray[nowPage].x>=0) {
                        imgArray[nowPage].move(course,false)
                    } else {
                        imgArray[nowPage].move(course,true)
                        nowPage++
                    }
                }
                informationSet()
            }
        }

        private function mouseMove(e:MouseEvent):void {
            if (oldPos<this.mouseX) {
                if (nowPage==0 && 0<this.mouseX-firstPos) {
                    course='none';
                    imgArray[nowPage].x=0
                } else {
                    course='right';
                    imgArray[nowPage].x=this.mouseX-firstPos
                    oldPos=this.mouseX
                }
            } else if (oldPos>this.mouseX) {
                if (nowPage==imgArray.length-1 && 0>this.mouseX-firstPos) {
                    course='none';
                    imgArray[nowPage].x=0
                } else {
                    course='left';
                    imgArray[nowPage].x=this.mouseX-firstPos
                    oldPos=this.mouseX
                }
            }
            if (course=='left' && imgArray[nowPage].x<0) {
                if (imgArray[nowPage+1]) {
                    imgArray[nowPage+1].visible=true
                    imgArray[nowPage+1].reset()
                }
                if (imgArray[nowPage-1]) {
                     imgArray[nowPage-1].visible=false
                }
            } else if (course=='right' && imgArray[nowPage].x>0) {
                if (imgArray[nowPage+1]) {
                    imgArray[nowPage+1].visible=false
                }
                if (imgArray[nowPage-1]) {
                    imgArray[nowPage-1].visible=true
                    imgArray[nowPage-1].reset()
                }
            }
        }

    }

}








import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.display.Loader
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.*
import flash.geom.Matrix;
import flash.geom.Point;

import flash.events.Event;


//カスタムローダー
class customLoader extends Loader{
    private var nextX:Number;
    private var lastX:Number;

    //通常のローダーに、ページ送りの動作を追加
    public function move(course:String,mode:Boolean):void {

        if (course=="right") {
            if (mode) {
                nextX=186
                lastX=nextX+10
            } else {
                nextX=0
                lastX=0
            }
            addEventListener(Event.ENTER_FRAME,onEnterFrame)

        } else if (course=="left") {
            if (mode) {
                nextX=-186
                lastX=nextX-10
            } else {
                nextX=0
                lastX=0
            }
            addEventListener(Event.ENTER_FRAME,onEnterFrame)
        }

        function onEnterFrame(e:Event):void {
            x+=(lastX-x)/3;
            if (mode) {
                if ((course=="right" && nextX <= x) || (course=="left" && nextX >= x)) {
                    parent.setChildIndex(Loader(e.target),0);
                    x=0;
                    removeEventListener(Event.ENTER_FRAME,onEnterFrame)
                }
            } else {
                if (Math.floor(x)==0) {
                    x=0
                    removeEventListener(Event.ENTER_FRAME,onEnterFrame)
                }
            }
        }
    }

    public function reset():void {
        visible=true;
        x=0;
        lastX=0
        nextX=0
    }

}


