/**
 * Copyright Nowloading_ ( http://wonderfl.net/user/Nowloading_ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9iRbq
 */

package {
    import flash.display.DisplayObject;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.view.stats.*;
    import org.papervision3d.render.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.lights.*;
    import flash.events.*;
    import flash.ui.Keyboard;

    [SWF(backgroundColor = 0x000000, frameRate = 40)]
    public class mf extends BasicView {
        //Field格納用オブジェクト
        private var field:DisplayObject3D;
        
        //地形参照用配列
        //0=green,1=brown, 2=blue
        private var uField:Array = [[0,0,0,0,1],
                                    [0,0,0,1,1],
                                    [0,0,2,2,2],
                                    [0,2,2,2,1],
                                    [0,2,2,1,0],
                                   ];
        private var dField:Array = [[0,1,1,1,1],
                                    [0,0,1,1,1],
                                    [0,1,2,2,2],
                                    [1,2,2,2,1],
                                    [1,2,2,1,0],
                                   ];
        private var dcubeHeight:Array = [[3,3,3,2,2],
                                         [3,3,2,1,1],
                                         [3,3,0,0,0],
                                         [3,0,0,0,2],
                                         [3,0,0,3,3],
                                        ];
        //Cube用material,primitive
        private var light:PointLight3D = new PointLight3D(true,false);
        private var gr:FlatShadeMaterial =
                 new  FlatShadeMaterial(light,0x60ff60,0x106f10,50);
        private var br:FlatShadeMaterial =
                 new  FlatShadeMaterial(light,0xd0a080,0x705035,50);
        private var bl:FlatShadeMaterial =
                 new  FlatShadeMaterial(light,0xd0ddff,0x505d7f,50);
        private var g:MaterialsList = new MaterialsList( { all:gr } );
        private var l:MaterialsList = new MaterialsList( { all:br } );
        private var b:MaterialsList = new MaterialsList( { all:bl } );
        private var materials:Array = [g,l,b];
        private var ucube:Cube;
        private var dcube:Cube;
        //cubeの大きさ/設定
        private var cubeWide:int = 64;
        private var cubeHeight:int = 24;
        private var stan:int = 6;
        //fieldの土台表示（兼field中心座標確保用）
        private var baseMat:ColorMaterial = new ColorMaterial(0x444444);
        private var baseMatList:MaterialsList = new MaterialsList( { all:baseMat } );
        private var base:Cube;
        //plane
        private var planeMat:ColorMaterial= new ColorMaterial(0xff0000);
        //planeの設定
        private var planeWide:int = 64;
        private var planeHeight:int = 96; 
        private var plane:Plane = new Plane(planeMat,planeWide,planeHeight);        
        //radiun
        private var rad:int = 0;
        //light
        private var rad2:Number = 0;

        public function mf() {
            renderer = new QuadrantRenderEngine();
            var stats:StatsView = new StatsView(renderer);
            addChild(stats);
            //-----light-----
            scene.addChild(light);
            //----------
            init();
        }
        private function init():void{
            field = new DisplayObject3D;
            scene.addChild(field);
            
            //materialslistの作成
            for(var i:int = 0; i<uField.length; i++){
                for(var j:int = 0; j<uField[i].length; j++){
                    //materialsをmaterials2-----light
                    ucube = new Cube(materials[uField[i][j]],cubeWide,cubeWide,cubeHeight);
                    dcube = new Cube(materials[dField[i][j]],cubeWide,cubeWide,
                                                cubeHeight+cubeHeight*dcubeHeight[i][j]);
                    ucube.x = dcube.x = cubeWide/2 + ((cubeWide+stan)*i);
                    ucube.z = dcube.z = cubeWide/2 + ((cubeWide+stan)*j);
                    dcube.y = (cubeHeight+cubeHeight*dcubeHeight[i][j])/2;
                    ucube.y = (dcube.y*2)+(cubeHeight/2);
                    field.addChild(ucube,"UCx_"+i+"z_"+j);
                    field.addChild(dcube,"DCx_"+i+"z_"+j);
                    
                    if((i == 2)&&(j == 3)){
                        scene.addChild(plane);
                        plane.y = (cubeHeight*dcubeHeight[i][j]+cubeHeight*2) + (planeHeight/2);
                        planeMat.doubleSided = true;
                        plane.x = ucube.x;
                        plane.z = ucube.z;
                    }

                }
            }
            base = new Cube(baseMatList,(uField.length*(cubeWide+stan)-stan),
                                        (uField[0].length*(cubeWide+stan)-stan),cubeHeight);
            scene.addChild(base);
            base.x = (uField.length*(cubeWide+stan)-stan)/2;
            base.z = (uField[0].length*(cubeWide+stan)-stan)/2;
            base.y = -cubeHeight/2;
            camera.y = 500;
            camera.z = -600;
            camera.target = base;
            //-----light
            light.x = camera.target.x;
            startRendering();
            addEventListener(Event.ENTER_FRAME,oEF);
        }
        private function oEF(e:Event):void{
            camera.x = camera.target.x+(300*Math.sin(rad*Math.PI/180));
            camera.z = camera.target.z+(-300*Math.cos(rad*Math.PI/180));
            rad += 1;
            if(rad==360){
                rad =0;
            }
            //-----light-----
            light.z = camera.target.z+250*Math.cos(rad2*Math.PI/180);
            light.y = 250*Math.sin(rad2*Math.PI/180);
            rad2 += 0.5;
            if(rad2 >= 360){
                rad2 = 0;
            }
            //----------
        }
    }
}