/**
 * Copyright ffffine ( http://wonderfl.net/user/ffffine )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9iQr
 */

// forked from ffffine's StardustとFrocessingのお勉強[2]
// forked from ffffine's StardustとFrocessingのお勉強[1]
package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import org.libspark.betweenas3.tweens.ITween;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	import flash.utils.getTimer;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*
	//import com.flashdynamix.utils.SWFProfiler;
	
	[SWF(width = 465, height = 465, backgroundColor = 0x0, frameRate =60)]	
	
	/**
	 * ...
	 * @author ffffine
	 */
	public class Dot3D extends Sprite
	{
		private var planes:Array;
		private var planesAlt:Array;
		private var view:BasicView;
		private var bmdata:BitmapData;
		private var colorTransrform:ColorTransform;
		
		public function Dot3D() 
		{
			super();
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		public function init():void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//SWFProfiler.init(stage, this);
			var bg:Shape = addChild(new Shape()) as Shape;
			bg.graphics.clear(); bg.graphics.beginFill(0x0); bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight); bg.graphics.endFill();
			view  = new BasicView();
			bmdata = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			var bitmap:Bitmap = addChild(new Bitmap(bmdata)) as Bitmap;
			colorTransrform = new ColorTransform(0.85, 0.70, 0.85);			
			addChild(view);
			planes = new mapToDots3D(
			[
			[0,0,1,0,0,0,0,0,1,0,0],
			[1,0,0,1,0,0,0,1,0,0,1],
			[1,0,1,1,1,1,1,1,1,0,1],
			[1,1,1,0,1,1,1,0,1,1,1],
			[1,1,1,1,1,1,1,1,1,1,1],
			[0,1,1,1,1,1,1,1,1,1,0],
			[0,0,1,0,0,0,0,0,1,0,0],
			[0,1,0,0,0,0,0,0,0,1,0]
			]			
			).createDotPlane();
			planesAlt = new mapToDots3D(
			[
			[0,0,1,0,0,0,0,0,1,0,0],
			[0,0,0,1,0,0,0,1,0,0,0],
			[0,0,1,1,1,1,1,1,1,0,0],
			[0,1,1,0,1,1,1,0,1,1,0],
			[1,1,1,1,1,1,1,1,1,1,1],
			[1,0,1,1,1,1,1,1,1,0,1],
			[1,0,1,0,0,0,0,0,1,0,1],
			[0,0,0,1,1,0,1,1,0,0,0],
			]		
			).createDotPlane();			
			for (var i:int = 0; i < planes.length; i++) 
			{
				view.scene.addChild(planes[i]);
			}
			for (var j:int = 0; j < planesAlt.length; j++) 
			{
				view.scene.addChild(planesAlt[j]);
			}
			addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
			//view.camera.z = -1 * view.camera.focus * view.camera.zoom;
			view.camera.z = 100;
			view.camera.target = DisplayObject3D.ZERO;
			view.startRendering();
			tween();
			
		}
		
		private function tween():void
		{
			var tweenList:Array = [];
			for (var i:int = 0; i < planes.length; i++) 
			{
				var t:ITween = BetweenAS3.tween(planes[i], { x:planes[i].extra.tx, y:planes[i].extra.ty,z:0,rotationX:0,rotationY:0,rotationZ:0 },null,  0.2, Back.easeOut);
				tweenList.push(t);
			}
			for (var j:int = 0; j < planes.length; j++) 
			{
				var t2:ITween = BetweenAS3.tween(planes[j], { x:planes[j].extra.dx, y:planes[j].extra.dy,z:planes[j].extra.dz,rotationX:Math.random()*360,rotationY:Math.random()*360,rotationZ:Math.random()*360 },null,  0.2, Back.easeIn);
				if (j == 0) {
					t2 = BetweenAS3.delay(t2, 10);
				}
				tweenList.push(t2);
			}
			for (var k:int = 0; k < planesAlt.length; k++) 
			{
				var t3:ITween = BetweenAS3.tween(planesAlt[k], { x:planesAlt[k].extra.tx, y:planesAlt[k].extra.ty,z:0,rotationX:0,rotationY:0,rotationZ:0 },null,  0.2, Back.easeOut);
				tweenList.push(t3);
			}
			for (var m:int = 0; m < planesAlt.length; m++) 
			{
				var t4:ITween = BetweenAS3.tween(planesAlt[m], { x:planes[m].extra.dx, y:planesAlt[m].extra.dy,z:planesAlt[m].extra.dz,rotationX:Math.random()*360,rotationY:Math.random()*360,rotationZ:Math.random()*360 },null,  0.2, Back.easeIn);
				if (m == 0) {
					t4 = BetweenAS3.delay(t4, 10);
				}
				tweenList.push(t4);
			}
			var serial:ITween = BetweenAS3.serialTweens(tweenList);
			var loop:ITween = BetweenAS3.repeat(serial, 10000);
			loop.play();
		}
		
		private function EnterFrameHandler(e:Event):void 
		{
			view.camera.x = Math.sin(getTimer() / 5000) * 150;
			view.camera.y = Math.cos(getTimer() / 5000) * 150;
			view.camera.z = -Math.cos(getTimer() / 2000) * 50 + 100;
			bmdata.draw(view);
			bmdata.colorTransform(bmdata.rect, colorTransrform);
		}
		
	}

}
import flash.filters.BlurFilter;
import flash.display.BitmapData;
import flash.filters.GlowFilter;
import org.papervision3d.materials.BitmapMaterial;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.WireframeMaterial;
import org.papervision3d.objects.primitives.Plane;

//Mapデータぶっこんでドット絵データ作るクラス
//3Dバージョン

class mapToDots3D {
	public var map:Array = [];
	public var list:Array = [];
	
	public function mapToDots3D(Map:Array = null) {
		if (map != null) { map = Map;}
	}
	
	public function createDotPlane():Array
	{
		var width:Number = map[0].length;
		var height:Number = map.length;
		var peaceWidth:Number = 10;
		var peaceHeight:Number = 10;
		var margin:Number = 3;		
		
		for (var i:int = 0; i < width; i++) 
		{
			for (var j:int = 0; j < height; j++) 
			{	
					var material:BitmapMaterial = new BitmapMaterial(new mapToDots(map).createBitmapData());
					//material.smooth = true;
					//var material:WireframeMaterial = new WireframeMaterial(0xccffff);
					material.doubleSided = true;
					var plane:Plane = new Plane(material, peaceWidth, peaceHeight);
					plane.useOwnContainer = true;
					plane.filters = [new GlowFilter(0xFFFFFF,0.8,10,10)];
					//座標
					var tx:Number = i * (peaceWidth + margin) - peaceWidth*width/2;
					var ty:Number = j * -(peaceHeight + margin) + peaceHeight * height / 2;
					plane.x  = Math.random() * 500 - 250;
					plane.y = Math.random() * 500 - 250;
					plane.z = Math.random() * 500 - 250;
					plane.rotationX = Math.random() * 360;
					plane.rotationY = Math.random() * 360;
					plane.rotationZ = Math.random() * 360;				
				if (map[j][i] == 1) {
					plane.extra = { tx:tx, ty:ty, tz:0 ,dx:plane.x, dy:plane.y, dz:plane.z };					
					list.push(plane);
					
				}
			}
		}
		trace("list : " + list[0]);
		return list ;
	}
}

class mapToDots {
	public var map:Array = [];
	public function mapToDots(Map:Array = null) {
		if (map != null) { map = Map;}
	}
	
	public function createBitmapData():BitmapData
	{
		var width:uint = map[0].length;
		var height:uint = map.length;		
		var bitmapdata:BitmapData = new BitmapData( width, height, true, 0x00FFFFFF);
		for (var i:int = 0; i < width; i++) 
		{
			for (var j:int = 0; j < height; j++) 
			{	
				if(map[j][i] == 1){
				bitmapdata.setPixel32(i, j, 0xFFFFFFFF);
				}
			}
		}
		return bitmapdata ;
	}
}