/**
 * Copyright tororo_zz ( http://wonderfl.net/user/tororo_zz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9hJq
 */

/* ---------------------------------------------------------------------------
 * クウォータービューのマップチップの敷き詰め
 * 
 * 今作ろうとしてるゲームのマップ表示をwonderflで表示できるかテスト
 * なんだか色々考えた結果こんなごちゃごちゃしたコードになってしまいました。
 * もっと効率&管理が楽なコードがあるなら教えていただけるとうれしいです！
 *
 * マップを並べるだけなので１マップ毎の情報格納とか無視してます。
 * このコードは凡用性ゼロのコードだと・・・
 *
 * 一応MapAddMakeの部分でマップエディットできます。
 *
 * どうも画像読み込みが面倒なことになってみるたいですね
 * せっかくのpngの透過が意味をなしてない・・・
 * ---------------------------------------------------------------------------
 */

/* ---------------------------------------------------------------------------
 * Main
 * --------------------------------------------------------------------------- */
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

    //[SWF(width="400", height="400")]
    
    public class Main extends MovieClip
    {
        //*--クラスとステージ
        public var main:Main
        public var sT:Stage = stage;
        public var baseSp:Sprite = new Sprite;
        
        //*--インターフェイスファンクション
        public var mapMake:Function
        
        //*--インターフェイスオブジェクト
        public var mapObj:Object = { } //マップ管理情報格納
        public var chipObj:Object = { } //マップBitmapData格納
        public var noMapObj:Object = { num:1, ch: { chParty:null } } //ノーマルマップ管理情報格納 ctl:{ at:{ atType:0 }, ch:{ chType:null }
        public var nullObj:Object = //マップ管理Null情報格納
        {
            map:null,
            poin:null,
            swap:null,
            dcost: { "1":null, "2":null },
            ctl: { num:null, ch: { chType:null } }
        }
        
        //*--チップサイズ
        public var chipSize:int = 32; //チップサイズ
        
        //*--全体のマップサイズ --MapAddで値の格納
        public var mapx:int;
        public var mapy:int;
        
        //*--マップ:標準位置修正 --MapAddで値の格納
        public var mapW:Number; //微調整値
        public var mapH:Number; //微調整値
        
        //*---URLの格納
        public var urlAry:Array = [ "http://assets.wonderfl.net/images/related_images/1/11/1157/115788a12fac5d8b0718afabcb03aea566690e8b" ]//map_chip
        
        //*--画像アクセスプロパティ
        public var bmdObj:Object = { } //一時的に読込クラスの格納
        public var mapNum:int = 0
        
        //*--繰返し使用
        public var point:Point = new Point( 0, 0 )
        public var rct:Rectangle = new Rectangle( 0, 0, 32, 32 )
        public var chbmd:BitmapData = new BitmapData( 32, 32, true, 0x00ffffff )
        //*----------
        
        public var vecx:Array = [ , 0, 1 , 0, -1 ]; //*方向情報修正値 メモ：職業によって状況確認を変えるように
        public var vecy:Array = [ , 1, 0 , -1, 0 ]; //*
        
        public function Main():void
        {
            main = this
            
            sT.addChildAt( baseSp, 0);
            baseSp.addChildAt( new Sprite, 0 )
            
            //*--インターフェイスファンクション
            mapMake = new MapAdd( main ).mapMake
                        
            init();
        }//Main
        
        public function init():void
        {
            //*--EventGroupでイベント登録
            var eGrp:EventGroup = new EventGroup( imgLoadEnd );
            
            //*--画像読込
            new LoaderMap( main, mapNum, eGrp )

        }//init

        
        public function imgLoadEnd( event:Event ):void
        {
            new MapAtObj( main )           
            mapMake();

        }//mgLoadEnd
        
        /* ---------------------------------------------------------------------------
         * Main　function関連
         * --------------------------------------------------------------------------- */

        //*--深度指定したスクリプトにアクセス
        public function getAdd( swap:int ):Sprite { return baseSp.getChildAt( swap ) as Sprite }//getAdd
        
        public function mapOut( nx:int, ny:int ):Boolean
        {
            return ( nx <= mapx && nx > 0 && ny <= mapy && ny > 0 )? true : false
        }//mapOut
        
        //*--方向の管理情報マップオブジェ格納チェック
        public function mapCkObj( nx:int, ny:int ):Object
        {
            return ( mapOut( nx, ny ) )? mapObj[ nx ][ ny ] : nullObj //移動方向の情報
        }//mapCkObj
        
    }//class Main
}//package

/* ---------------------------------------------------------------------------
 * LoaderMap
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    /**-public**/ class LoaderMap  extends Bitmap
    {
        public var main:Main;
        public var bmdObj:Object = { }
        public var loader:Loader = new Loader();
        public var loaderB:Loader = new Loader();
        public var bmdc:BitmapData//雛形コピー用
        public var chip:int;
        
        public function LoaderMap( _main:Main, num:int, eGrp:EventGroup ):void
        {
            main = _main
            chip = main.chipSize
            bmdc = new BitmapData(chip, chip, true, 0xffffffff);//雛形コピー用
            
            main.bmdObj[num] = this
            
            eGrp.addEvent(this, Event.COMPLETE);
          
            loader.load( new URLRequest( main.urlAry[num] ) );
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
            

        }//LoaderMap
        
        private function initHandler(event:Event):void
        {    
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, completeHandler);
            loaderB.loadBytes(loader.contentLoaderInfo.bytes);
        }
        
        public function completeHandler( event:Event ):void
        {
            var num:int
            
            var loadimg:Loader = event.currentTarget.loader;
            var bmp:Bitmap = new Bitmap();
            var bd:BitmapData = new BitmapData(loadimg.width, loadimg.height, false);
            bd.draw(loadimg);
            bmp.bitmapData = bd
            
            for ( var i:int = 0; i < 5; i++ )
            {
                for ( var v:int = 0; v < 6; v++ )
                {
                    bmdObj[num++] = bmpch( bmp, v, i ); //読込んだ画像をBitmapDataに変換
                }
            }

            dispatchEvent(new Event(Event.COMPLETE));
            
        }//completeHandler
        
        /**-ビットマップデータ切取
         * @param tage　読込んだBitmap
         * @param v　X軸修正値
         * @param i　Y軸修正値**/
        public function bmpch(tage:Bitmap, w:int = 0, h:int = 0):BitmapData
        {

            var tagebmd:BitmapData = tage.bitmapData;
            var clipbmd:BitmapData = bmdc.clone()
            clipbmd.copyPixels( tagebmd, tagebmd.rect, new Point( ( -chip) * w, ( -chip) * h ) );//clipbmdに描画
            
            //透過処理                                   
            for ( var w:int = 0 ; w <= chip ; w++ )
            {
                for ( var h:int = 0 ; h <= chip ; h++ )                
                {
                    if ( clipbmd.getPixel32(w,h) == 0xffffffff ){ clipbmd.setPixel32(w,h,0x00ffffff); } //白部分を指定の色に書変え
                }
            }

            return clipbmd
        }//bmpch

        public function retnObj():Object
        {
            return bmdObj;
        }//completeHandler
        
    }//class LoaderMap
//}package

/* ---------------------------------------------------------------------------
 * EventGroup
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.events.EventDispatcher;
    import flash.events.Event;
    
    /**-public**/ class EventGroup extends EventDispatcher
    {
        private var eventCount:uint;
        
        /**-コンストラクタ
         * @param func　DispatchEventで起動させる関数**/
        public function EventGroup( func:Function ):void
        {
            this.addEventListener(Event.COMPLETE, func);
        }//EventGroup
        
        /**-イベント追加
         * @param target　イベント追加するオブジェクト
         * @param type　イベント追加するイベント名**/
        public function addEvent( target:EventDispatcher, type:String ) : void
        {
            target.addEventListener(type, onEvent);
            eventCount++;
        }//addEvent
        
        /**-イベント発生**/
        private function onEvent( event:* ):void
        {
            event.target.removeEventListener( event.type, onEvent );
            eventCount--;
            if (eventCount == 0)
            {
                dispatchEvent(new Event(Event.COMPLETE));//グループイベント完了
            }
        }//onEvent
    }//class EventGroup
//}package

/* ---------------------------------------------------------------------------
 * MapAtObj
 * --------------------------------------------------------------------------- */
//package 
//{
    import flash.display.*;
    
    /**-public**/ class MapAtObj
    {
        protected var main:Main
        
        /**
         *--コントラクタ マップアーティファクトの整理格納
        **/
        public function MapAtObj( _main:Main ):void
        {
            main = _main
            var atObj:Object = main.bmdObj[main.mapNum].retnObj() //画像読込chipObjに格納
                        
            main.chipObj["MapFace"] = atStorage( atObj , 0 , 23) //マップ
            main.chipObj["Frame"] = atStorage( atObj , 24 , 29) //マップ    
            
        }//MapAtObj
        
        public function atStorage( atObj:Object, v:int, w:int ):Object
        {
            var acObj:Object = { }
            var num:int
            
            for ( var i:int = v; i <= w; i++){ acObj[++num] = atObj[i] }
            
            return acObj
        }//atStorage    
    }//class MapAtObj
//}

/* ---------------------------------------------------------------------------
 * MapAdd
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.geom.*;

    /**-public**/ class MapAdd
    {
        protected var main:Main
        
        /**-コントラクタ**/         
        public function MapAdd( _main:Main ):void
        {
            main = _main
        }//MapAdd
        
        /**-main.mapObjに情報格納**/
        public function mapMake():void
        {
            //*--マップ読込み
            var mapData:Object = mapMake_10_10() 
            //var mapData:Object = mapMake_10_10z() 
            //var mapData:Object = mapMake_10_5()
            
            //*--座標初期処理
            mapAdj( mapData )
            
            //*--マップ情報の表示と格納
            var sortAry:Array = mapAlign( mapData ) //マップ位置情報格納
            mapInfoStorage( sortAry )
            mapFrame( sortAry )
        }//MapMake
        
        //*--マップ位置の調整 //MapAddからのアクセス
        public function mapAdj( mapData:Object ):void
        {
            var mapP:Object = mapData["dataP"]
            
            //*--全体のマップサイズ( マップ数 )
            main.mapx = mapP.x
            main.mapy = mapP.y
            main.mapW = main.sT.stageWidth/2 - main.chipSize/2 + 24;
            main.mapH = main.sT.stageHeight/2 - main.chipSize/2 - main.mapy * 6 - 2.5;
            

        }//mapAdj
        
        /**-マップ配置情報格納 深度、座標**/
        public function mapAlign( mapData:Object ):Array
        {
            var sortAry:Array = [ ]
            for ( var xp:int=1; xp <= main.mapx; xp++ )
            {
                main.mapObj[xp] = { }
                for ( var yp:int= 1; yp <= main.mapy; yp++ )
                {
                    var cd:int = ((( xp + yp - 1) & 0xff ) << 16 | ( xp & 0xff ) << 8 | ( yp & 0xff ) << 0 ) //X軸、Y軸、Z軸を16進法に変換
                    var wd:int = ( xp - yp - 2 ) * 12
                    var hd:int = ( xp + yp - 2 ) * 6
                    
                    var mapInt:int = mapData.dataC[xp][yp]
                    
                    var zp:int = ( mapInt >> 16 ) & 0xFF;
                    var fp:int = ( mapInt >> 8 ) & 0xFF;
                    var atp:int = ( mapInt >> 0 ) & 0xFF;
                    
                    main.mapObj[xp][yp] = { }
                    sortAry.push( { cv:cd, wv:wd, hv:hd, xv:xp, yv:yp, zv:zp, fv:fp, atv:atp } )
                }
            }
            
            return sortAry.sortOn( "cv", Array.NUMERIC ) //深度を奥から描画していくためソートしてリターン
        }//mapAlign
        
        /**-マップ情報格納、マップ表示**/
        public function mapInfoStorage( sortAry:Array ):void
        {
            var sortLen:int = sortAry.length
            var chpMap:Object = main.chipObj["MapFace"]
            
            //*--マップ情報格納、マップ表示
            for ( var v:int = 0 ; v < sortLen ; v++ )
            {
                var obj:Object = sortAry[v]
                var face:int = obj.fv
                var atv:int = obj.atv
                var wv:int = obj.wv
                var hv:int = obj.hv
                var xv:int = obj.xv
                var yv:int = obj.yv
                var zv:int = obj.zv
                var sv:int = v * 4 + 1
                
                /**--管理情報格納**/
                main.mapObj[xv][yv] =
                {
                    map: { x:xv, y:yv, z:zv },
                    poin: { w:wv, h:hv },
                    swap: { mp:sv, pn:sv + 1, ch:sv + 2, ef:sv + 3 }, //マップ、ポインタ、キャラ、エフェクトの標準深度
                    dcost: { 1:0, 2:0 },
                    ctl: main.noMapObj
                }
                
                //*--マップ、ポイント、キャラ、エフェクト深度用の空スプリット
                for ( var s:int = 0; s <= 3; s++ ) { main.baseSp.addChild( new Sprite ) }
                var spr:Sprite = main.getAdd( sv )  //main.baseSp.getChildAt( sv ) as Sprite
                spr.x = wv + main.mapW;
                spr.y = hv + main.mapH;
                
                //*--マップ表示
                var zp:int = 3 * zv
                var clipBmd:BitmapData = new BitmapData( main.chipSize, 16 + zp, true, 0x00ffffff );//0x00ffffff 0x0F0000FF
                var clipBmp:Bitmap = new Bitmap( clipBmd );
                var bmd:BitmapData = chpMap[face]
                
                obj.bmd = clipBmd //縁用表示用にsortAryにBitmapDataを格納しておく
                clipBmp.y = 14 - zp
                spr.addChild( clipBmp )
                
                for ( var i:int = zv ; i >= 0 ; i-- )
                {
                    main.point.y = -14 + i * 3
                    clipBmd.copyPixels( bmd, bmd.rect, main.point, null, null, true );
                }
                
            }
        }//mapInfoStorage
        
        /**-マップ縁　段差縁　表示**/
        public function mapFrame( sortAry:Array ):void
        {
            
            var sortLen:int = sortAry.length
            for ( var v:int = 0 ; v < sortLen ; v++ )
            {
                var objs:Object = sortAry[v]
                var xp:int = objs.xv
                var yp:int = objs.yv
                var zp:int = objs.zv
                var bmd:BitmapData = objs.bmd
                                
                rb: for ( var i:int = 1; i <= 4; i++ )
                {
                    var obj:Object = main.mapCkObj( xp + main.vecx[i], yp + main.vecy[i] )
                    var dBln:Boolean = ( obj.map == null )? true : false
                    var cBln:Boolean = ( i > 2 )? true : false
                    if ( dBln && cBln ) { fraAdd( bmd, zp, i ) } //外枠上
                    else if ( dBln && !cBln ) { fraAdd( bmd, zp, i, false ) } //外枠下
                    else if ( zp - obj.map.z > 0 && cBln ) { fraAdd( bmd, zp, i ) } //段差上
                }
            }
            
            main.point.y = 0 //メインポイントの初期化
        }//mapFrame
        
        public function fraAdd( bmd:BitmapData, zp:int, i:int, bln:Boolean = true ):void
        {
            var bmdF:BitmapData = main.chipObj["Frame"][ i ]
            if ( bln ) { main.point.y = -14 } else { main.point.y = -14 + zp * 3 }
            bmd.copyPixels( bmdF, bmdF.rect, main.point, null, null, true );
        }//frameAdd
        
        /* ---------------------------------------------------------------------------
         * MapAddMake
         * --------------------------------------------------------------------------- */
        //( mapInt >> 16 ) & 0xFF;　高さ
        //( mapInt >> 8 ) & 0xFF;　チップナンバー
        //( mapInt >> 0 ) & 0xFF;　アーティファクトナンバー
                
        //*--x10*y5マップ
        public function mapMake_10_5():Object
        {
            return {
            
            dataP:{ x:10, y:5 },
                
            dataC:[ ,
            [ 0x000E01, 0x000E01, 0x000E00, 0x000E02, 0x000E02,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x020E02, 0x000E00,,].reverse(),
            [ 0x000F00, 0x030F00, 0x010E00, 0x020E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E04, 0x000E00, 0x000E00, 0x000E00,,].reverse(),
            [ 0x010E00, 0x010E00, 0x020E03, 0x000E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x000E02, 0x000E02,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x020E02, 0x000E00,,].reverse(),
            [ 0x000F00, 0x030F00, 0x010E00, 0x020E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E04, 0x000E00, 0x000E00, 0x000E00,,].reverse(),
            [ 0x010E00, 0x010E00, 0x020E03, 0x000E00, 0x000E00,,].reverse()]}
        }//mapMake_10_5
        
        //*--x10*y10マップ
        public function mapMake_10_10():Object
        {
            return {
            
            dataP:{ x:10, y:10 },
                
            dataC:[ ,
            [ 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x010200, 0x020200, 0x010200,,].reverse(),
            [ 0x000200, 0x040A00, 0x050A00, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x000400, 0x000400, 0x020200,,].reverse(),
            [ 0x000200, 0x030A00, 0x020A00, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x000400, 0x000400, 0x010200,,].reverse(),
            [ 0x000200, 0x000E00, 0x010F00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000300, 0x000300, 0x000E00, 0x000E00, 0x000E00, 0x010F00, 0x021600, 0x051600, 0x000200,,].reverse(),
            [ 0x000200, 0x000300, 0x000300, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x031600, 0x041600, 0x000200,,].reverse(),
            [ 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200,,].reverse()]}
        }//mapMake_10_10
        
        //*--x10*y10マップ
        public function mapMake_10_10z():Object
        {
            return {
            
            dataP:{ x:10, y:10 },
                
            dataC:[ ,
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse()]}
        }//mapMake_10_10z
        
    }//class MapAdd
//}package