/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9hHs
 */

package {
    import flash.display.*;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            draw();
            
            var tf : TextField = new TextField();
            tf.autoSize = "left";
            tf.text = "REDRAW";
            tf.border = true;
            tf.selectable = false;
            addChild(tf);
            tf.addEventListener(MouseEvent.CLICK, function(e : MouseEvent) : void { draw(); });
        }
        
        public function draw() : void 
        {
            var xs : Array = [];
            var vs : Array = [];
            var i : int, j : int;
            
            var N : int = 10;
            for(i = 0;i < N;i++){
                xs.push(new Point(Math.random() * 10 - 5, Math.random() * 10 - 5));
                vs.push(new Point(Math.random() * 2 - 1, Math.random() * 2 - 1));
            }
            
            var g : Graphics = graphics;
            g.clear();
            g.lineStyle(1);
            g.moveTo(230 + 3 * 70, 300);
            g.lineTo(230 + (-3) * 70, 300);
            g.moveTo(230 + 3 * 70, 400);
            g.lineTo(230 + (-3) * 70, 400);
            var vy : Point, vv : Point;
            var t : Number, v : Number;
            var y : Number;
            for(y = -3.0;y <= 3.0;y+=0.01){
                vy = new Point(0, y);
                v = 0.0;
                for(i = 0;i < N;i++){
                    vv = vs[i].subtract(vy);
                    t = mint(xs[i], vv);
                    if(t >= 0){
                        v += f(mind2(xs[i], vv, t)) / (t + 1.0);
                    }
                }
                v += (y * 0.3) * (y * 0.3);
                
                g.lineTo(230 + y * 70, 400 - v * 100);
            }
            
            // MC
            var min : Number = Number.MAX_VALUE;
            var miny : Number = -5.0;
            var M : int = 100;
            for(j = 0;j < M;j++){
                y = -3.0 + j / M * 6.0;
                vy = new Point(0, y);
                v = 0.0;
                for(i = 0;i < N;i++){
                    vv = vs[i].subtract(vy);
                    t = mint(xs[i], vv);
                    if(t >= 0){
                        v += f(mind2(xs[i], vv, t)) / (t + 1.0);
                    }
                }
                v += (y * 0.3) * (y * 0.3);
                
                if(v < min){
                    min = v;
                    miny = y;
                }
            }
            g.lineStyle(1, 0xff0000);
            g.moveTo(230 + miny * 70, 400);
            g.lineTo(230 + miny * 70, 100);
        }
        
        private function mint(x : Point, v : Point) : Number
        {
            if(v.x * v.x + v.y * v.y < 0.0001){
                return 0.0;
            }
            return -(x.x * v.x + x.y * v.y) / (v.x * v.x + v.y * v.y);
        }
        
        private function mind2(x : Point, v : Point, t : Number) : Number
        {
            var xx : Number = x.x + v.x * t;
            var yy : Number = x.y + v.y * t;
            return xx * xx + yy * yy;
        }
        
        private function f(d2 : Number) : Number
        {
//            return d2 < 5 ? 1 : (d2 < 7 ? -0.1 : 0);
            return d2 < 5 ? 1 : 0;
//            return 1 / (1 + Math.exp(-(d2 - 5)));
//            return Math.exp(-d2 / 2);
        }
        
        /*
        private function mint(x : Vector3D, v : Vector3D) : Number
        {
            if(Math.abs(v.length) < 0.01){
                return 0.0;
            }
            return -x.dotProduct(v) / (v.length * v.length);
        }
        
        private function mind(x : Vector3D, v : Vector3D, t : Number) : Number
        {
            var ret : Vector3D = v.clone();
            ret.scaleBy(t);
            ret.incrementBy(x);
            return ret.length;
        }
        */
    }
}