/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9gpK
 */

//
//    MouseDownイベントを擬似的にリピートで発生させるテスト
//
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private static const LOGSIZE:int = 40;
        
        private var button:RepeatButton;
        private var downbuf:Array = new Array(LOGSIZE);
        private var edgebuf:Array = new Array(LOGSIZE);
        private var relbuf:Array = new Array(LOGSIZE);
        private var reptbuf:Array = new Array(LOGSIZE);
        
        private var downText:TextField;
        private var edgeText:TextField;
        private var relText:TextField;
        private var reptText:TextField;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            button = new RepeatButton();
            button.x = 465 / 2 - button.width/2;
            button.y = 300;
            
            addChild( button );
            
            for ( var i:int = 0; i < LOGSIZE; i++ )
            {
                downbuf[i] = false;
                edgebuf[i] = false;
                relbuf[i] = false;
                reptbuf[i] = false;
            }
            
            downText = new TextField();
            downText.text = "押されている限り反応";
            downText.autoSize = "left";
            downText.x = 465 / 2 - downText.width / 2;
            downText.y = 25;
            downText.selectable = false;
            addChild( downText );

            reptText = new TextField();
            reptText.text = "押されている限りかつリピートタイミングで反応";
            reptText.autoSize = "left";
            reptText.x = 465 / 2 - reptText.width / 2;
            reptText.y = 75;
            reptText.selectable = false;
            addChild( reptText );
            
            
            
            edgeText = new TextField();
            edgeText.text = "押された瞬間に反応";
            edgeText.autoSize = "left";
            edgeText.x = 465 / 2 - edgeText.width / 2;
            edgeText.y = 125;
            edgeText.selectable = false;
            addChild( edgeText );
            
            reptText = new TextField();
            reptText.text = "離された瞬間に反応";
            reptText.autoSize = "left";
            reptText.x = 465 / 2 - reptText.width / 2;
            reptText.y = 175;
            reptText.selectable = false;
            addChild( reptText );
            
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( event:Event ) : void
        {
            var i:int = 0;
            for ( i = LOGSIZE-1; i > 0; i-- )
            {
                downbuf[i] = downbuf[i - 1];
                edgebuf[i] = edgebuf[i - 1];
                relbuf[i] = relbuf[i - 1];
                reptbuf[i] = reptbuf[i - 1];
            }
            downbuf[0] = button.repeatButtonData.IsButtonDown();
            edgebuf[0] = button.repeatButtonData.IsButtonPrs();
            relbuf[0] = button.repeatButtonData.IsButtonRelease();
            reptbuf[0] = button.repeatButtonData.IsButtonRepeat();
            
            graphics.clear();
            graphics.lineStyle(1, 0xAAAAAA);            
            for ( i = 0; i < LOGSIZE; i++ )
            {
                if (downbuf[i]) graphics.beginFill( 0 );
                else             graphics.beginFill( 0, 0 );
                graphics.drawRect(465/2 - (LOGSIZE*10/2) + i * 10, 50, 10, 10);
                graphics.endFill();

                if (reptbuf[i]) graphics.beginFill( 0 );
                else             graphics.beginFill( 0, 0 );
                graphics.drawRect(465 / 2 - (LOGSIZE * 10 / 2) + i * 10, 100, 10, 10);
                graphics.endFill();                
                
                
                if (edgebuf[i]) graphics.beginFill( 0 );
                else             graphics.beginFill( 0, 0 );
                graphics.drawRect(465/2 - (LOGSIZE*10/2) + i * 10, 150, 10, 10);
                graphics.endFill();                
                
                if (relbuf[i]) graphics.beginFill( 0 );
                else             graphics.beginFill( 0, 0 );
                graphics.drawRect(465 / 2 - (LOGSIZE * 10 / 2) + i * 10, 200, 10, 10);
                graphics.endFill();                
                
            }
        }
        
    }
    
}
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.Event;
    /**
     * リピート処理が入っているボタンで使用するデータ構造をまとめた物
     * @author 
     */
    class RepeatButtonData
    {
        public  var down:uint = 0;    
        public  var up:uint = 0;        
        
        private var back:uint = 0;
        private var edge:uint = 0;        //    押された瞬間を表す
        private var sepr:uint = 0;        //    離された瞬間を表す
        
        private var rept:uint = 0;
        private var count:uint = 0;
        private var wait:uint = 0;
        
        private static const REPEAT_DELAY:int = 20;        //    リピートが開始されるまでのフレーム数
        private static const REPEAT_SPAN:int = 2;        //    リピート間のフレーム数
        
        /**
         * ボタンカーソルが押された時に呼ばれる
         */
        public function Down() : void
        {
            down = 1;
            up = 0;
            
            back = 0;
            edge = 0;
            sepr = 0;
            rept = 0;
            count = 0;
            wait = 0;
        }
        /**
         * ボタンカーソルが離された時に呼ばれる
         */
        public function Up() : void
        {
            if( down != 0 )    up = 1;
            down = 0;
            
            back = 0;
            edge = 0;
            sepr = 0;
            rept = 0;
            count = 0;
            wait = 0;            
        }
        
        public function Update() : void
        {
            var data:uint = 0;
            
            if ( up != 0 )    data = 0;
            else            data = down;

            edge = (data ^ back) & data;    //    押しっぱなしだったら0になる
            sepr = up;
            up = 0;
            
            back = data;
            
            if ( data != 0 )
            {
                if ( count == 0 || count == REPEAT_DELAY )
                {
                    rept = data;
                }else
                {
                    rept = 0;
                }
                
                if ( count++ > REPEAT_DELAY )
                {
                    if ( wait++ > REPEAT_SPAN )
                    {
                        rept = data;
                        wait = 0;
                    }else {
                        rept = 0;
                    }
                }
                
            }else
            {
                rept = 0;
                count = 0;
                wait = 0;
            }
        }
        
        /**
         * ボタンが押されているかどうかを調べる
         * @return
         */
        public function IsButtonDown() : Boolean
        {
            return    ( down != 0 );
        }
        
        /**
         * ボタンが押された瞬間かどうかを調べる
         * @return
         */
        public function IsButtonPrs() : Boolean
        {
            return    ( edge != 0 );
        }
        
        /**
         * ボタンが離された瞬間かどうかを調べる
         * @return
         */
        public function IsButtonRelease() : Boolean
        {
            return    ( sepr != 0 );
        }
        /**
         * ボタンが押されているかどうかを調べる（リピート処理用）
         * @return
         */
        public function IsButtonRepeat() : Boolean
        {
            return    ( rept != 0 );
        }
        
    }

    /**
     * リピート処理が入っているボタン
     * @author 
     */
    class RepeatButton extends Sprite
    {
        public var repeatButtonData:RepeatButtonData;
        
        public function RepeatButton() 
        {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, 60, 20);
            graphics.endFill();
            
            repeatButtonData = new RepeatButtonData();
            
            addEventListener( MouseEvent.MOUSE_DOWN, MouseDownHandler );
            addEventListener( MouseEvent.MOUSE_UP, MouseUpHandler );
            addEventListener( MouseEvent.ROLL_OUT, MouseUpHandler );
            addEventListener( Event.ENTER_FRAME, Update );
        }
        private function Update(event:Event) : void
        {
            repeatButtonData.Update();    
        }
        private function MouseDownHandler( event:MouseEvent ) : void
        {
            repeatButtonData.Down();
        }
        private function MouseUpHandler( event:MouseEvent ) : void
        {
            repeatButtonData.Up();
        }
    }