/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9gnu
 */

package 
{
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextField;
	import com.bit101.components.PushButton;
	import flash.display.Sprite;

	public class SkewTransitionEffectDoc extends Sprite
	{
		public function SkewTransitionEffectDoc()
		{
			var spr1:Sprite = createTF("あのイーハトーヴォのすきとおった風、", 50, 120);
			var spr2:Sprite = createTF("夏でも底に冷たさをもつ青いそら、", 50, 150);
			var spr3:Sprite = createTF("うつくしい森で飾られたモリーオ市、", 50, 180);
			var spr4:Sprite = createTF("郊外のぎらぎらひかる草の波。", 50, 210);
			var id:String = "hogeId";
			new PushButton(this, 10, 10, "fade in", function():void
			{
				SkewTransitionEffect.addFadeIn(id, spr1, spr2, spr3, spr4);
				SkewTransitionEffect.play(id);
			});
			new PushButton(this, 120, 10, "fade out", function():void
			{
				SkewTransitionEffect.addFadeOut(id, spr1, spr2, spr3, spr4);
				SkewTransitionEffect.play(id);
			});
			new PushButton(this, 230, 10, "abort", function():void
			{
				SkewTransitionEffect.abort(id);
			});
			
			SkewTransitionEffect.addFadeIn(id, spr1, spr2, spr3, spr4);
			SkewTransitionEffect.play(id);
		}

		private function createTF(str:String, _x:Number, _y:Number):Sprite 
		{
			var txt:TextField = new TextField();
			txt.autoSize = TextFieldAutoSize.LEFT;
			var tf:TextFormat = txt.defaultTextFormat;
			tf.size=18;
			txt.defaultTextFormat = tf;
			txt.text = str;
			var spr:Sprite = new Sprite();
			spr.x = _x;
			spr.y = _y;
			addChild(spr);
			spr.addChild(txt);
			return spr;
		}
	}
}
import flash.display.DisplayObject;
import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.Expo;
import org.libspark.betweenas3.BetweenAS3;
import frocessing.core.F5Graphics2D;
import flash.display.Graphics;
import flash.display.Shape;
import flash.utils.Dictionary;
import flash.display.Sprite;

class SkewTransitionEffect
	{
		private static var displayObjectDic:Dictionary;
		private static var completedoDic:Dictionary;
		private static var twDic:Dictionary;

		{
			displayObjectDic = new Dictionary(true);
			completedoDic = new Dictionary(true);
			twDic = new Dictionary(true);

		}

		public function SkewTransitionEffect()
		{
			throw new Error("no instance");
		}

		public static function addFadeIn(id:String, ...dios:Array):void
		{
			addFadeInByArray(id, dios);
		}
		
		public static function addFadeInByArray(id:String, dios:Array):void
		{
			if(displayObjectDic[id])
			{
				return;
			}
			var len:uint = dios.length;
			var doVec:Vector.<DisplayObject> = Vector.<DisplayObject>([]);
			for (var i:uint=0; i<len; i++) 
			{
				var dio:DisplayObject = dios[i];
				var maskShape:SkewMaskObj = new SkewMaskObj();
				maskShape.x = dio.x;
				maskShape.y = dio.y;
				var g:Graphics = maskShape.graphics;
				var f5g:F5Graphics2D = new F5Graphics2D(g);
				f5g.lineStyle(0,0,0);
				f5g.fillColor = 0x00ff00;
				f5g.rect(0, 0, dio.width, dio.height);
				f5g.triangle(dio.width, 0, dio.width*2, 0, dio.width, dio.height);
				dio.parent.addChild(maskShape);
				doVec.push(dio);
				maskShape.x -= maskShape.width;
				maskShape.targetX = dio.x;
				dio.mask = maskShape;
				
			}

			displayObjectDic[id] = doVec;
		}

		public static function addFadeOut(id:String, ...dios:Array):void
		{
			addFadeOutByArray(id, dios);
		}
		
		public static function addFadeOutByArray(id:String, dios:Array):void
		{
			if(displayObjectDic[id]||!dios.length)
			{
				return;
			}
			var len:uint = dios.length;
			var doVec:Vector.<DisplayObject> = Vector.<DisplayObject>([]);
			for (var i:uint=0; i<len; i++) 
			{
				var dio:DisplayObject = dios[i];
				if(!dio)continue;
				var maskShape:SkewMaskObj = new SkewMaskObj();
				maskShape.x = dio.x;
				maskShape.y = dio.y;
				var g:Graphics = maskShape.graphics;
				var f5g:F5Graphics2D = new F5Graphics2D(g);
				f5g.lineStyle(0,0,0);
				f5g.rect(0, 0, dio.width, dio.height);
				f5g.triangle(dio.width, 0, dio.width*2, 0, dio.width, dio.height);
				if(dio)
				{
					if(dio.parent)dio.parent.addChild(maskShape);
				}
				doVec.push(dio);
				maskShape.targetX = -dio.width*2;
				dio.mask = maskShape;
			}
			displayObjectDic[id] = doVec;
		}

		public static function abort(id:String):void
		{
			if(displayObjectDic[id])
			{
				var vec:Vector.<DisplayObject> = displayObjectDic[id];
				var len:uint = vec.length;
				for (var i:uint = 0; i<len; i++)
				{
					var dio:DisplayObject = vec[i];
					var msk:SkewMaskObj = dio.mask as SkewMaskObj;
					msk.graphics.clear();
					dio.mask.parent.removeChild(dio.mask);
					dio.mask = null;
					msk = null;
					dio = null;
				}
				delete displayObjectDic[id];
			}

			if(twDic[id])
			{
				twDic[id].stop();
				delete twDic[id];
			}

			if(completedoDic[id])
			{
				delete completedoDic[id];
			}
		}

		public static function play(id:String, time:Number=3, easing:IEasing = null, complete_func:Function=null) : void 
		{
			if(!displayObjectDic[id]||completedoDic[id]||twDic[id])return;
			completedoDic[id] = Vector.<DisplayObject>([]);
			var ve:Vector.<DisplayObject> = displayObjectDic[id];
			var len:uint = ve.length;
			var twAr:Array = [];
			var _easing:IEasing=(easing)? easing:Expo.easeOut;
			for (var i:int=0; i<len; i++) 
			{
				var dio:DisplayObject = ve[i];
				var msk:SkewMaskObj= dio.mask as SkewMaskObj;
				var tw:ITween = BetweenAS3.to(msk,{x:msk.targetX}, time, _easing);
				tw.onComplete = function(dio:DisplayObject):void
				{
					completedoDic[id].push(dio);
				};
				tw.onCompleteParams = [dio];
				twAr.push(tw);
			}
			twDic[id] = BetweenAS3.parallelTweens(twAr);
			twDic[id].onComplete = function(id:String):void
			{
				if(complete_func != null)complete_func();
				removeMask(id);
				delete displayObjectDic[id];
				delete twDic[id];
			};
			twDic[id].onCompleteParams = [id];
			twDic[id].play();
		}

		private static function removeMask(id:String):void
		{
			var vec:Vector.<DisplayObject> = completedoDic[id];
			var len:uint = vec.length;
			for (var i:uint = 0; i<len; i++)
			{
				var dio:DisplayObject = vec[i];
				var msk:SkewMaskObj = dio.mask as SkewMaskObj;
				if(msk)msk.graphics.clear();
				if(dio.mask)
				{
					if(dio.mask.parent)dio.mask.parent.removeChild(dio.mask);
					dio.mask = null;
				}
				msk = null;
				dio = null;
			}
			delete completedoDic[id];
		}
}

class SkewMaskObj extends Shape
{
	public var targetX:Number;
}