/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ghi
 */

// forked from cpu_t's 槍が降ったらオーロラが出た
// 思いつきで作ったらこんなんなった。
// 
package {
    import adobe.utils.CustomActions;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    public class Pillars extends Sprite
    {
        private var bdView:BitmapData;
        private var movingpillars:Array;
        private var filter:BlurFilter;
        
        public function Pillars()
        {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            bdView = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            addChild(new Bitmap(bdView));
            
            filter = new BlurFilter(2, 8);
            
            reset();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void
            {
                count = 0;
                isStop = false;
                
                //bdView.fillRect(bdView.rect, 0);
                for (var index:int = 0; index < movingpillars.length; index++)
                {
                    removeChild(movingpillars[index]);
                }
                
                removeEventListener(Event.ENTER_FRAME, onUpdate);
                
                reset();
            });
        }
        
        private function reset():void
        {
            movingpillars = new Array();
            addEventListener(Event.ENTER_FRAME, onUpdate);
        }
        
        private var count:Number = 0;
        private var isStop:Boolean = false;
        private function onUpdate(e:Event):void 
        {
            if (count > bdView.height + 40)
            {
                isStop = true;
            }
            
            for (var index:int = 0; index < movingpillars.length; index++)
            {
                var item:Sprite = movingpillars[index];
                item.x += Math.cos((90+item.rotation) * Math.PI / 180)*20;
                item.y += Math.sin((90+item.rotation) * Math.PI / 180)*20;
                if (item.y > bdView.height-count)
                {
                    count += .04;
                    var mat:Matrix = new Matrix();
                    mat.rotate((item.rotation) * Math.PI / 180);
                    mat.translate(item.x, item.y);
                    bdView.draw(item, mat, null, "add");
                    removeChild(item);
                    movingpillars.splice(index, 1);
                    index--;
                }
            }
            bdView.applyFilter(bdView, bdView.rect, bdView.rect.topLeft, filter);
            for (var i:int = 0; i < 16&&!isStop; i++)
            {
                var sp:Sprite = new Sprite();
                var color:uint = 0xFFFFFF*0;
                var h:Number = Math.random() * 3;
                if (h < 1)
                {
                    color += int(0xFF * h) << 16;
                    color += int(0xFF * (1-h)) << 8;
                }
                else if (h < 2)
                {
                    color -= 1;
                    color += int(0xFF * h) << 8;
                    color += int(0xFF * (1 - h));
                }
                else
                {
                    color -= 2;
                    color += int(0xFF * h)
                    color += int(0xFF * (1-h)) << 16;
                }
                sp.graphics.beginFill(color);
                sp.graphics.drawRect( -1, -30, 2, 30);
                addChild(sp);
                sp.x = Math.random() * bdView.width;
                sp.y = Math.random() * -10 - 20;
                sp.rotation = (Math.random() - .5) * 30;
                var w:Number = Math.random() * 8;
                sp.filters = [new BlurFilter(w, w)];
                movingpillars.push(sp);
            }
        }
    }
}