/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9g6o
 */

// forked from tepe's typing trainer -タイプの達人-
// forked from tepe's forked from: typing game　-たいぷの達人-
// forked from tepe's typing game　-たいぷの達人-
// forked from tepe's forked from: flash on 2013-3-26
// forked from tepe's flash on 2013-3-26

/*
---予定---

文字出現方法を修正する

大文字を別の色にする

評価画面を用意する
    成績確認
    獲得ポイント

ゲームの進行とともに選択肢が増える
モード選択：イージーモード(ロストなし、ミスタッチなし) トレーニングモード(ロストなし,ミスタッチあり)  ノーマルモード(ロストカウントあり) ハードモード(ミスタッチ&ロストカウントあり)
モード選択 -> 曲選択


￥の入力を修正する：2つのキーコード、文字コード
文字の重なりを修正する：密集して表示されると読みづらい
動画再生部分と出題部分を分離する：出題方法を切り替えやすい状態にする
キーボードのロスト状態での文字を暗くする：出題されてるのかロストしたのか判断しにくい
曲選択画面を用意する：マウス入力とキー入力に対応する
ランキングリストから選曲
マイリストから選曲
    マイリスト画面
        登録順リスト
タグリストから選曲
    曲（動画）にタグをつける：タグ編集
検索リストから選曲
    マイリストに追加
スタート画面を用意する：スタート画面にメニューを表示
単語を出題する：単語を登録、編集する
アカウントを作成する：サーバーでユーザーデータを管理する
    ユーザーのパラメータデータ管理
    マイリスト管理
    
    
チャット機能：ユーザー間でのやりとり

キーボードの設定
    文字設定：通常,＋Shift,＋Ctrl
    入力待ち状態、ロスト状態、通常、未使用状態、
    文字コード設定、キーコード設定
*/
package{
    import flash.display.*;
    import flash.filters.GlowFilter;
    import flash.system.*;
    import flash.text.*;
    import flash.net.*;
    import flash.media.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.geom.Matrix;
    import org.libspark.betweenas3.BetweenAS3;
    import net.wonderfl.utils.FontLoader;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class Main extends Sprite{
        //システムカラー
        private const color1:uint = 0x223388;//青
        private const color2:uint = 0x44aaff;
        
        private const color3:uint = 0x00ff00;
        //動画リクエストサイズ
        private const WIDTH:int = 300;
        private const HEIGHT:int = 225;
        
        private var par:Number;//再生進捗率
        private var t1:Number = 0;//動画の終了時間
        
        private var player:Object;
        private var players:Array;
        private var videoState:int = -1;//プレイヤー状態
        //youtube動画ID
        private var movie:Array = ["kZAIwipsxo8"];

        //読み込んだ効果音を保持する
        private var sndList:Object = new Object();
        
        
        private var i:int = 0;
        private var seekWidth:Number = WIDTH;//シークバーの幅
        private var list:Array = new Array();//タイミングのリスト
        private var codeList:Array;
        //セーブデータ
        private var so:SharedObject;
        private var saveData:Object;
        
        
        private var seekBar:Sprite = new Sprite();//シークバー
        private var line:Sprite = new Sprite();//タイミングライン
        private var timeLine:Sprite = new Sprite();//タイムライン
        //デバッグテキスト
        private var txt:TextField = new TextField();
        private var txt2:TextField = new TextField();
        private var tls:Number = 100;//タイムラインが流れる速さを調整 
        private var lxp:Number = 70;//タイミングラインの位置
        private var skill:int = 10;
        private var score:int =0;//得点
        private var combo:int=0;//コンボ数
        private var hit:int=0;//ヒット
        private var miss:int=0;//ミス回数　※入力できなかった文字数
        private var level:int = 0;
        private var levelUP:Array;

        private var repeat:Boolean = false;
        private var shuffle:Boolean = true;
        
        private var timeIn:Number=2;//入力受付開始時間
        
        private var charCnt:int=0;//次のタイピング文字
        
        private var movieNum:int=0;//再生動画選択
                
        //public static const FONT:String = "Bebas";
        //public static const EMBED:Boolean = true;
        
        
        //ステージスコア
        private var stageScore:int = 0;
        private var stageScoreMax:int = 300;
        
        private var stageNum:int = 1;
        
        private var kb:KeyBoardBtn;// = new KeyBoardBtn();
        
        private var videoBase:Sprite = new Sprite();
        private var videoId:String;
        
        //コンストラクタ
        public function Main(){
            /*
            levelUP = setLevelUP();
            var fontLoader:FontLoader = new FontLoader();
            fontLoader.addEventListener(Event.COMPLETE, init);
            fontLoader.load(Main.FONT);
            movieNum = Math.floor(Math.random()*movie.length);
            
            //init();
            //*/
            ///*
            initSelectMode();
            //*/
        }
        
//----動画選択画面------------------------------------------------------------------------------------
        private var playlist:Playlist;
        private var keyString:String = "MMDPV";
        private function initSelectMode():void{ 
            graphics.clear();
            stage.removeEventListener(KeyboardEvent.KEY_DOWN,onKey);
            stage.removeEventListener(KeyboardEvent.KEY_UP,offKey);
            while(1<stage.numChildren)stage.removeChildAt(1);
            
            
            var box:InputBox = new InputBox();
            box.text = keyString;
            if(playlist==null){
                playlist = new Playlist();
                playlist.addEventListener(MouseEvent.CLICK,selectVideo);
                playlist.search(keyString);
            }
            else{
                //box.text
            }
            playlist.x = 10;
            playlist.y = 50;
            stage.addChild(playlist);
            box.addEventListener(KeyboardEvent.KEY_DOWN,function(e:KeyboardEvent):void{
                if(e.keyCode==13){ 
                    playlist.search(box.text);
                    keyString = box.text;
                }
            });
            
 
            stage.addChild(box);
            box.x = 350;
            box.y = 30;
            box.scaleX = box.scaleY = 0.5;
        }
        
        private function initGameMode():void{ 
            kb = null;
            while(1<stage.numChildren)stage.removeChildAt(1);
            levelUP = setLevelUP();
            init();
            stageInit();
        }
        
        //ステージスコア上限
        private function setStageScoreMax():void{
            stageScoreMax = 100+t1*stageNum*0.8;
        }
        private function selectVideo(e:MouseEvent):void{
            videoId = playlist.id;
            if(videoId!=null)initGameMode();
        }

        private function stageInit():void{
            resetLostkey();
                    stageScore = 0;
                    drawScoreBar();
                    if(stageNum==4)new ScoreIndicator(videoBase,230,100,"final stage",0xffffff,0xaaaaff,40);
                    else new ScoreIndicator(videoBase,230,100,"stage  "+stageNum.toString(),0xffffff,0xaaaaff,40);
 
                    //スクロールスピード設定
                    tls += stageNum*30;
                    if(400<tls)tls=400;//スピード上限
                    //stageNum++;
                    t1 = player.getDuration();
                    setStageScoreMax();
                    //createTimeline(t1,0.9,2.5);
                    var a:Number = (1-level/10);//出題密度
                    createTimeline(t1,a,1.5);
                    charList = new Array();
                    textList = new Array();
                    lostList = new Array();
        }
        
//レベル管理-------------------------------------------------------------------        
        private function setLevelUP(maxLevel:int=99):Array{
            var n:Number = 50;
            var n2:Number = n/4;
            var expList:Array = new Array();
            for(var i:int=1;i<maxLevel;i++){
                expList.push(n);
                n2 = i*75-(i-1)*3;
                n += Math.floor(n2);
            }
            return expList;
        }

        private function checkLevel(exp:int):Boolean{
            var b:Boolean = false;
            while(levelUP[level] < exp && level < levelUP.length){ 
                level++;
                b=true;;
            }
            return b;
        }
//--------------------------------------------------レベル管理-----------------
//初期化----------------------------------------------------------------------

        private function stageInit2():void{
            if(kb==null)kb = new KeyBoardBtn();
            kb.x = 5; kb.y = 330;
            kb.scaleX = 1.2;//kb.scaleY = 1.2;
            stage.addChild(kb);
            
            //バックグラウンドカラー
            with(graphics){
                beginFill(0x000000); 
                drawRect(-400,0,1400,460);
                endFill();
            }
            
            //キーボード入力
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
            stage.addEventListener(KeyboardEvent.KEY_UP,offKey); 
            stage.addChild(scoreBar);
            stage.focus = kb;
        }
        
        private function init(e:Event=null):void{ 
            
            stageInit2();
             
            loadUserData();//セーブデータ取得
            checkLevel(saveData.exp)
            openKeyset(skill);//入力可能なキーを設定する
            
            Security.loadPolicyFile('http://ozworks.dip.jp/crossdomain.xml');            
///*return; 
            var loader:Loader;
            loader = new Loader();
            //loader.name = i.toString();
            loader.contentLoaderInfo.addEventListener(Event.INIT, onLoaderInit);
            const req:String = "http://www.youtube.com/apiplayer?enablejsapi=1&version=3";
            loader.load(new URLRequest(req));//youtubeプレイヤー読み込み
    //        stage.addEventListener(MouseEvent.CLICK,onClick);
//*/ 
            stage.addEventListener(Event.ENTER_FRAME,onFrame);
            
txt2.text = "";
            //videoBase.addChild(txt); 
            //videoBase.addChild(txt2);
            
        }
        
        //開始準備2
        private function init2():void{
            const scale:Number =1.45;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;
            
            //スコアバー
            scoreBar.x = (stage.stageWidth - w)/2;
            drawScoreBar();
            
            //シークバー
            seekBar.x=(stage.stageWidth - w)/2;
            seekBar.y=h-15;
                       
            var seekGlow:Shape = new Shape();
            seekBar.addChild(seekGlow);
            seekGlow.graphics.beginFill(0x000000);
            seekGlow.graphics.drawRect(0,0,seekWidth,10);
            seekGlow.graphics.endFill();
            var glow:GlowFilter = new GlowFilter(color2, 0.2, 4, 8, 2, 4, false, true);
            seekGlow.filters =  [glow]
            stage.addChild(seekBar);    
            //preloadSnd("http://ozworks.dip.jp/sound/c.mp3");
            //preloadSnd("http://ozworks.dip.jp/sound/l.mp3");
            
            
        }
        
        
//動画管理----------------------------------------------------------------------------
        //ローダー初期化
        private function onLoaderInit(event:Event):void{
            const scale:Number =1.45;
            const w:Number = WIDTH*scale;
            const h:Number = HEIGHT*scale;
            seekWidth = w;
            var loader:Loader = event.currentTarget.loader;
            loader.content.addEventListener("onReady", onPlayerReady);
            loader.content.addEventListener("onStateChange",onChangeState);
            
            loader.scaleX = scale;
            loader.scaleY = scale;
            loader.x = (stage.stageWidth - w)/2;
            //loader.y = (stage.stageHeight - h)/2;
            videoBase.y = 0//kb.height+30;
            videoBase.addChild(loader);
            videoBase.addChild(txt); 
            //videoBase.addChild(txt2);
            
            videoBase.addChild(timeLine);//タイムライン配置
            timeLine.y=30;
            stage.addChild(videoBase);
            //stage.addEventListener(MouseEvent.MOUSE_DOWN,onPause);
            
            txt2.textColor = color1;
            txt2.alpha = 0.5;
            txt.textColor = color2;
            txt.alpha=0.5;
            txt.selectable = false;
            //txt2.selectable= false;
            //txt.y=350;
            txt.x=380;
            txt.y = 30;
            txt.width = 300;
            txt.height = 300;
            txt2.height = 300;
        }
        
        
        private function addText():void{
            var seek:Number = player.getCurrentTime();//先頭からの経過時間
            //有効文字を追加
            for(var i:int=0;i<20;i++){
                var n:int = charCnt+i;
                if(charList.length<=n){//文字生成
                    var n2:int = skill/3;
                    charList.push(rndChar(n2));
                    createStr(String.fromCharCode(charList[n]), list[n]);
                }

                if(list[list.length-1]<seek)break;//最後の文字を過ぎていたらスルー
                if(list.length<=n)break;
                if(seek+timeIn<list[n])break;
                if(textList[n].textColor == color2){ 
                    setKey(charList[n],true,color2);
                    continue;
                }
                if(textList[n].textColor != 0xffffff){ 
                    textList[n].textColor = color2;
                    setKey(charList[n],true);
                    break;
                }
                
            }//for
        }
        
        //出題文字が全てなくなったら実行
        private function showStageScore():void{
            var seek:Number = player.getCurrentTime();//先頭からの経過時間
            if(list[list.length-1]<seek){ 
                if(combo==0)return;
                if(199<combo){
                    new ScoreIndicator(videoBase,150,150,"Excellent!",0xffff00,0xaaaa00,50);
                }
                else if(99<combo){
                    new ScoreIndicator(videoBase,150,150,"great!",0xffff00,0xaaaa00,50);
                }
                else if(49<combo){
                    new ScoreIndicator(videoBase,150,150,"good job!",0xffff00,0xaaaa00,50);
                }
                combo=0;
                hit = 0;
                //player.stopVideo(); 
                return;
            }
        }

        
//---------------------------------------------初期化--------------------        
//ゲームメイン-----------------------------------------------------------        
        //エンターフレーム
        private function onFrame(event:Event):void{
txt.text ="";//String.fromCharCode(charList[charCnt]);
            var seek:Number = player.getCurrentTime();//先頭からの経過時間
            //txt.appendText("\n"+seek.toString());
            par = (seek / t1);//再生進捗率更新
            //txt.appendText("\n"+list[charCnt].toString());
txt.appendText("Level:"+(1+level).toString()+"\n");
txt.appendText("Score:"+score.toString());
            //txt.appendText("\ncombo:"+combo.toString());
txt.appendText("\nmiss:"+miss.toString());
txt.appendText("\nExp:"+saveData.exp.toString());
txt.appendText("\nSkill:"+skill.toString());
txt.appendText("\n"+player.getVideoBytesLoaded().toString()+"byte");
txt.appendText("\n"+player.getVideoStartBytes().toString()+"byte");
txt.appendText("\n"+stageNum.toString()+"stage");
txt.appendText("\nscoreMax:"+stageScoreMax.toString()); 
            //txt.appendText("\nchoiceKey:"+choiceKey.length.toString());
            //txt.appendText("\n"+(list[charCnt]-player.getCurrentTime()).toString());
            draw1();
            timeLine.x = -seek * tls + lxp - 50;//タイムライン移動
            
            addText();//出題文字追加
            
            //ステージ終了判定:文字出現位置が再生時間より後ろなら終了
            if(list[charCnt] < seek){
                //ロスト
                lostText();
                charCnt++;
                charCnt%=list.length;
                //textList[charCnt].textColor = color2;
                //textList[charCnt].alpha = 1;
            }
            
            
        }
 //----------------------------------------------------------       
        private function lostText():void{
            //ロスト
                if(textList[charCnt].textColor==color2){ 
                    combo=0;
                    if(0<skill){
                        skill--;
                        openKeyset(skill);
                    }
                    if(lostCount!=true){
                        setKey(charList[charCnt],false);
                        
                        charCnt++;
                        charCnt%=list.length; 
                        return;
                    }
                    textList[charCnt].textColor = 0x000000;
                    drawScoreBar(-3);
                   //textList[charCnt].textColor = 0x000000;
                    setKey(charList[charCnt],true,0xff3300);
                    var lostChar:int = charList[charCnt];
                    lostList.push(lostChar); 
                    miss++;
                    var btn:Object;
                    if(97<=charList[charCnt] && charList[charCnt]<=122){ 
                        btn = kb.getKey(String(charList[charCnt]-32));
                    }
                    else if(33<=charList[charCnt] && charList[charCnt]<=41){// ! " # $ % & ' ( )
                       btn = kb.getKey(String(charList[charCnt]+16));
                    }
                    else if(42<=charList[charCnt] && charList[charCnt]<=47){// * + , - . /
                        btn = kb.getKey(String(charList[charCnt]+144)); 
                    }
                    else if(58<=charList[charCnt] && charList[charCnt]<=64){// : ; < = > ? @
                        btn = kb.getKey(String(charList[charCnt]+128)); 
                    }
                    else if(charList[charCnt]==92)btn = kb.getKey(String(220));
                    else{
                        btn = kb.getKey(String(charList[charCnt]));
                    }

                    new ScoreIndicator(kb,btn.x+5,btn.y+20,"LOST",0xffaaaa,0xff0000,10,3);
                    if(0<skill){
                        skill--;
                        //lost++; 
                        openKeyset(skill);
                        new ScoreIndicator(videoBase,350,250,"[  "+textList[charCnt].text+"  ]"+"   lost",0xff5500,0x333333,30);
                    }
                }
        }
        
        private var lostCount:Boolean = true;//ロスト判定を有効にする
        
        private var lostList:Array = new Array();　
        
        //タイムラインを自動生成する
        private function createTimeline(ti:Number,min:Number=0.5,max:Number=3,stTime:Number=5,lastTime:Number=0.5):int{
txt2.appendText("createTimeline:\n"+ti.toString()+"\n");
            var ti2:Number = stTime;
            var ti3:Number = 0;//前回の文字出現時間
            list = new Array();
            while(ti2<ti){
                //txt2.appendText(ti2.toString()+"\n");
                var add:Number = Math.random()*max;
                add *= 1000;
                add = Math.floor(add);
                add /= 1000;
                ti2 += add;
                if(ti3+min < ti2 && ti2<ti-lastTime){ 
                    list.push(ti2);
                    ti3=ti2;
                    //txt2.appendText("["+(list.length-1).toString()+"]"+list[list.length-1].toString()+"\n");
                    //txt2.scrollV = txt2.maxScrollV;
                }

            }
            list.sort(Array.NUMERIC);  
            return list.length; 

        }

        
        //シークバー描画
        private function draw1():void{
            
            with(seekBar.graphics){1
                clear();
                beginFill(color1,0.7);
                drawRect(0,0,seekWidth,10);
                endFill();
                
                beginFill(color2,0.5);
                //drawRect(0,0,seekWidth*par,10);
                drawRect(seekWidth*par,0,seekWidth*(1.0-par),10);
                endFill();
                
            }
        }
        
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        private var scoreBar:Sprite = new Sprite();
        private var barGlow:Shape = new Shape();
        private function drawScoreBar(pt:int=0):void{
            stageScore += pt;
            if(stageScore<0)stageScore=0;
            else if(stageScoreMax < stageScore)stageScore=stageScoreMax;
            
            var par:Number = (stageScore/stageScoreMax);
            with(scoreBar.graphics){
                clear();
                beginFill(0x555555,0.7);
                drawRect(0,0,seekWidth,20);
                endFill();
                
                beginFill(0x00ff33);
                drawRect(0,0,seekWidth*par,20);
                endFill();
                
                beginFill(0xff0000);
                drawRect(seekWidth*0.8,0,2,20);
                endFill();
                
            }
            var col:uint = Math.random()*0xffffff;
            var glow:GlowFilter = new GlowFilter(col, 0.5, 5, 10, 2, 6, false, true);
            barGlow.filters =  [glow];
            with(barGlow.graphics){
                clear();
                beginFill(0x555555);
                drawRect(0,0,seekWidth,20);
                endFill();
            }
            scoreBar.addChild(barGlow);
        }
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^        
        
        //データロード
        private function loadUserData():void{
            so = SharedObject.getLocal("userdata");
            if(so){
               var obj : Object = so.data;
               if(obj.hasOwnProperty("exp") == false) obj.exp = 0;
               if(obj.hasOwnProperty("score") == false) obj.score = 0;
               if(obj.hasOwnProperty("skill")==false) obj.skill = 40;
               saveData = obj;
               score = obj.score;
               skill = obj.skill;
//経験値リセット               
//obj.exp = 0;
//obj.skill = 40;
//skill = 40;
               
            }
        }
        
//-------------------------------------------        
        private var charList:Array;//タイピングコードの配列
        private var textList:Array;//表示文字の配列
        private function _setKeyCode():void{
            var len:int = list.length;
            charList = new Array();
            textList = new Array();
            var i:int;
            for(i=0;i<len;i++) charList.push(rndChar());            
            for(i=0;i<len;i++) createStr(String.fromCharCode(charList[i]), list[i]);
        }
//-----------------------------------------        
        //表示文字生成
        private function createStr(str:String,timestamp:Number,fontSize:int=50):void{
                var c:TextField = new TextField();//表示文字
                var c2:TextField = new TextField();//グローフィルター用
                var base:Sprite = new Sprite();//ベース
                
                //テキスト設定
                var tf:TextFormat = new TextFormat();//テキストフォーマット
                tf.size = fontSize;//サイズ
                tf.bold = true;//太字
                c.defaultTextFormat = c2.defaultTextFormat = tf;//フォーマット適用
                c.text = c2.text = str;
                
                c.width = c2.width = c.textWidth+3;
                c.height = c2.height = c.textHeight+2;
                c.x = c2.x = -c.width/2;
                c.y = c2.y = -c.height/2;
                c.textColor = 0x000000; //フォントカラー
                c2.selectable = c.selectable= false;//文字選択無効
                
                //グローフィルター設定
                var glow:GlowFilter = new GlowFilter(color1, 0.7, 13, 13, 5, 5, false, true);
                c2.filters = [glow];
                
                base.addChild(c); 
                base.addChild(c2);
                base.graphics.beginFill(0x000000,0.3);
                //base.graphics.drawRoundRect(0,base.height/2,base.width,base.height/2,10,10);
                base.graphics.drawCircle(0,0,c.height/2);
                base.graphics.endFill(); 
                
                base.x = timestamp*tls;//タイムラインの位置
                base.y = Math.random()*HEIGHT;
                textList.push(c);
                timeLine.addChild(base);//タイムラインに配置
                //videoBase.addChild(base);
                /*base.addEventListener(Event.ENTER_FRAME,function(e:Event):void{
                    base.x-=base.y*0.03;
                });
                //*/
        } 
        
        
        //表示文字生成
        private function createStr2(str:String,y:Number=0,speed:Number=1,fontSize:int=50):void{
                var c:TextField = new TextField();//表示文字
                var c2:TextField = new TextField();//グローフィルター用
                var base:Sprite = new Sprite();//ベース
                
                //テキスト設定
                var tf:TextFormat = new TextFormat();//テキストフォーマット
                tf.size = fontSize;//サイズ
                tf.bold = true;//太字
                c.defaultTextFormat = c2.defaultTextFormat = tf;//フォーマット適用
                c.text = c2.text = str;
                
                c.width = c2.width = c.textWidth+3;
                c.height = c2.height = c.textHeight+2;
                c.x = c2.x = -c.width/2;
                c.y = c2.y = -c.height/2;
                c.textColor = color2; //フォントカラー 
                c2.selectable = c.selectable= false;//文字選択無効
                
                //グローフィルター設定
                var glow:GlowFilter = new GlowFilter(color1, 0.7, 13, 13, 5, 5, false, true);
                c2.filters = [glow];
                
                base.addChild(c); 
                base.addChild(c2);
                base.graphics.beginFill(0x000000,0.3);
                //base.graphics.drawRoundRect(0,base.height/2,base.width,base.height/2,10,10);
                base.graphics.drawCircle(0,0,c.height/2);
                base.graphics.endFill(); 
                
                base.x = 300;//タイムラインの位置
                base.y = Math.random()*HEIGHT;//＊要修正＊重なりを最小限にするように変更する
                textList.push(c);
                //timeLine.addChild(base);//タイムラインに配置
                videoBase.addChild(base);
                base.addEventListener(Event.ENTER_FRAME,function aa(e:Event):void{
                    base.x-=speed;
                    if(base.x<0){ 
                        base.removeEventListener(Event.ENTER_FRAME,aa);
                        videoBase.removeChild(base);
                    }
                });
                
        }
        
//-----------------------------------------        
        //キーボード入力
        private function onKey(e:KeyboardEvent):void{
            if(Capabilities.hasIME)IME.enabled = false;//IME無効
            if(e.keyCode==32){//space
                //new ScoreIndicator(stage,WIDTH/2,150,"test",0xffff00,0xaaaa00,30); 
                onPause();
                combo=0;
                return;
            }
            if(e.keyCode==16){
                return;
            }
            if(e.keyCode == 13){ 
                var n3:int = skill/3;
                charList.push(rndChar(n3));
                //createStr(String.fromCharCode(charList[n]), list[n]);
                createStr2(String.fromCharCode(charList[charList.length-1]),50,10,60);
                setKey(charList[charList.length-1],true,color2);
                return; 
            }
            const c1:uint = 0xffffff; const c2:uint = 0xaaaaff;
            var btn:Object = kb.getKey(String(e.keyCode));
            //playSnd("http://ozworks.dip.jp/sound/c.mp3");
            //playSnd("http://ozworks.dip.jp/sound/aa/dong.mp3");

            //表示されている文字のどれかに適合すればOK。一番手前のものから調べる
            for(var j:int=0;j<20;j++){
                var n2:int = charCnt+j;
                if(timeIn+1 < list[n2]-player.getCurrentTime())break;
                var a:Boolean = checkKey(charList[n2],e.keyCode,e.charCode,e.shiftKey);
                if(a == true && textList[n2].textColor == color2){//ヒット
                    setKey(charList[n2],false);
                    combo++;
                    hit++;
                    drawScoreBar(3);
                    
                    //playSnd("http://ozworks.dip.jp/sound/c.mp3");
                    textList[n2].textColor = 0xffffff;
                    textList[n2].alpha = 0.9;
                    //textList[n2].parent.graphics.clear();
                    var s:Sprite = textList[n2].parent;
                    new ScoreIndicator(timeLine,s.x,s.y+10,combo.toString()+" hit",c1,c2,18,0.5);
                    s.addEventListener(Event.ENTER_FRAME,function a(e:Event):void{ 
                        s.graphics.clear();
                        s.graphics.beginFill(0xffffff);
                        s.graphics.drawCircle(0,0,10/s.alpha);
                        s.graphics.drawCircle(0,0,10/s.alpha-2);
                        s.graphics.endFill();
                        s.alpha *= 0.8;
                        if(s.alpha<0.01)s.removeEventListener(Event.ENTER_FRAME,a);
                    });
                    //charCnt++;
                    //charCnt%=list.length;
                    
                    
                    
                    new ScoreIndicator(kb,btn.x+5,btn.y+20,combo.toString()+" hit",0xffffff,0x00aaff,10,0.3);
                    
                    saveData.exp++;
                    score+=combo*10;
                    saveData.score = score;
                    var pt:int = hit;
                    
                    new ScoreIndicator(scoreBar,10,20,pt.toString()+" hit",c1,c2,20);
                    //new ScoreIndicator(stage,100,290,"hit",c1,c2,30);
                    new ScoreIndicator(videoBase,400,290,"    "+score.toString(),0xaaaff,0x0000ff,20);
                    
                    //ロストキー復活
                    if(1<Math.random()*2 && combo%5==0 && 0<lostList.length){
                        var rnd:int = Math.random()*lostList.length-1;
                        var n:int = lostList.splice(rnd,1);
                        setKey(n,false);
                        new ScoreIndicator(kb,350,130,"repair  key",0xaaffaa,0x33aa33,20);
                    }

                    comboCheck();//コンボ
                    
                    openKeyset(skill);
                    saveData.skill = skill;
                    return;
                }

            }
            
            combo=0;
            skill--;
            openKeyset(skill);
            new ScoreIndicator(kb,btn.x+5,btn.y+20,"miss",0xffaa00,0xff0000,10,0.3);
            //ミスタッチ判定
            if(missCount==true){
                drawScoreBar(-1);
            }
        }
        
        private var missCount:Boolean = false;//ミスタッチの判定をする
        
        
        //コンボ処理
        private function comboCheck():void{
            const str:String = "http://ozworks.dip.jp/sound/bb/";
            var sound1:Sound;
            //var url2:URLRequet;
            //var btn:Object = kb.getKey(String(e.keyCode));
            var num:int = Math.floor(Math.random())+1;
            var b:String = "c"+combo.toString()+".mp3";
            var url2:URLRequest;
            //コンボ
                    if(combo==list.length){//フルコンボ
                        playSnd(str+"full.mp3");
                        new ScoreIndicator(videoBase,300,150,"full combo",0xffffff,0xaaaaff,50);
                        saveData.exp += combo*50;
                       //combo=0; 

                        skill+=10;
                    }
                    else if(combo%100 == 0){//100
                        new ScoreIndicator(videoBase,300,150,combo.toString()+"  combo",0xffffff,0xaaaaff,40);
                        saveData.exp += combo*10;
                        //skill+=3;
                        skill+=combo/10;
                        //tl += 10;
                        //var url2:URLRequest = new URLRequest(str+b);
                        playSnd(str+b);
                        b = "c"+(combo+50).toString()+".mp3";
                        preloadSnd(str+b);
                    }
                    else if(combo%50==0){//50
                        playSnd(str+b);
                        b = "c"+(combo+50).toString()+".mp3";
                        preloadSnd(str+b);
                        new ScoreIndicator(videoBase,300,150,combo.toString()+"  combo",0xffffff,0xaaaaff,40);
                        saveData.exp += combo*5;
                        //skill+=2;
                        skill+=combo/10;
                    }
                    else if(combo%10==0){//10
                        if(combo<100){  
                            playSnd(str+b);
                            if(combo+10<100){
                                b = "c"+(combo+10).toString()+".mp3";
                                preloadSnd(str+b);
                            }
                            
                        }
                        new ScoreIndicator(videoBase,300,150,combo.toString()+"  combo",0xffffff,0xaaaaff,30);
                        saveData.exp += combo;
                        skill+=combo/10;
                        
                     }
        }
        
        
//効果音読み込み---------------------------------------------------------------------
        
        private function preloadSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
                //txt2.appendText(url+"\n");
            }
        }

        private function playSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
                txt2.appendText(url+"\n");
            }
            sndList[url].play();
        }
//---------------------------------------------------------------------------------
        
        //キーリリース
        private function offKey(e:KeyboardEvent):void{
            kb.text = "";
            //textList[charCnt].textColor = color2;
            //textList[charCnt].alpha = 1;
        }
        //リトライ
        private function retry():void{
            player.seekTo(0);//先頭に移動
            charCnt=0;
            miss=0;
            combo=0;
            for(var i:int=0;i<list.length;i++){
                textList[i].textColor = 0x000000;
            }
        } 
        

//--------------------------------------------------ゲームメイン-------------------------------------        
        //ロストキーリセット
        private function resetLostkey():void{
            while(0<lostList.length){ 
                var n:int = lostList.splice(0,1);
                setKey(n,false);
            }
        }
//----------------------------------        
        
        //動画ステータス変化
        private function onChangeState(e:Event):void{
            
            
            videoState = player.getPlayerState()
txt2.appendText("change:"+videoState.toString()+"\n");
txt2.appendText("stage:"+stageNum.toString()+"\n");
            txt2.scrollV = txt2.maxScrollV;
            //動画終了
            if(videoState == 0){
                
                showStageScore();
                
                //レベルアップ
                if(checkLevel(saveData.exp)==true){
                    new ScoreIndicator(videoBase,350,200,"LEVEL   UP",0xffffff,0xaaaaff,30);
                }
                
                
                if(stageScoreMax * 0.8 < stageScore && stageNum < 4){ 
                    new ScoreIndicator(videoBase,220,100,"stage clear!",0xffffff,0xaaaaff,50);
                    stageNum++;
                    //スクロールスピード設定
                    tls += stageNum*30;
                    if(400<tls)tls=400;//スピード上限
                    kb.getKey("32").text = "Next >>";
                    //kb.getKey("32").setColor(color2);
                }
                else {
                    if(stageScoreMax * 0.8 < stageScore)new ScoreIndicator(videoBase,220,100,"stage clear!",0xffffff,0xaaaaff,50);
                    tls = 100;
                    stageNum = 1;
                    kb.getKey("32").text = "<< Back";
                    //kb.getKey("32").setColor(color2);                    
                }
                
                //saveData.score = score;
                //onPause();
                
                
                               
                kb.getKey("32").setLight(true);
                kb.getKey("32").setColor(color1);
                if(repeat == true)retry();//リトライ
                return;
                
            }
            //動画再生開始
            else if(videoState == 1){
                kb.getKey("32").setLight(true);
                kb.getKey("32").setColor(color1);
                kb.getKey("32").text = "PAUSE";
                if(t1 == 0){
                    resetLostkey();
                    stageScore = 0;
                    drawScoreBar();
                    if(stageNum==4)new ScoreIndicator(videoBase,230,100,"final stage",0xffffff,0xaaaaff,40);
                    else new ScoreIndicator(videoBase,230,100,"stage  "+stageNum.toString(),0xffffff,0xaaaaff,40);
 
                    //スクロールスピード設定
                    tls += stageNum*30;
                    if(400<tls)tls=400;//スピード上限
                    //stageNum++;
                    t1 = player.getDuration();
                    setStageScoreMax();
                    //createTimeline(t1,0.9,2.5);
                    
                    charList = new Array();
                    textList = new Array();
                    lostList = new Array();
                    var a:Number = (1-level/10);//出題密度
                    createTimeline(t1,a,1.5);
//                    setKeyCode();
                }
                t1 = player.getDuration(); 

            }
            //バッファリング中
            else if(videoState == 3){
                new ScoreIndicator(videoBase,WIDTH/2,80,"now   loading...",0xffff00,0xaaaa00,20);
txt2.appendText("loading.....\n");
            }

            else if(videoState == 5){//頭出し済み  
                init2();
                kb.getKey("32").setLight(true);
                kb.getKey("32").setColor(color1);
                kb.getKey("32").text = "START";
txt2.appendText("loading.....\n");
            }  
        }
        


        
        
        //一時停止
        private function onPause(e:MouseEvent=null):void{
            videoState = player.getPlayerState();
            
            if(videoState == 0){ 
                kb.getKey("32").setColor(color2);
                kb.getKey("32").setLight(true);
                kb.getKey("32").text = "START";
                initSelectMode();
            }
            else if(videoState == 1){ 
                player.pauseVideo();
               
                new ScoreIndicator(videoBase,WIDTH/2,80,"pause",0xffffff,0xaaaaff,30);
                kb.getKey("32").setColor(color2);
                kb.getKey("32").setLight(true);
                kb.getKey("32").text = "START";
            }
            else if(videoState == 2){ 
                player.playVideo();
                new ScoreIndicator(videoBase,WIDTH/2,80,"start",0xffffff,0xaaaaff,30);
                kb.getKey("32").setColor(color1);
                kb.getKey("32").setLight(true);
                kb.getKey("32").text = "PAUSE";
            }
            else{//動画のリロード
                reloadVideo();
            }

        }
        private function reloadVideo():void{
            if(shuffle == true){
                    var num:int = Math.floor(Math.random()*movie.length);
                    if(movieNum == num)movieNum = num+1;
                    else movieNum = num; 
                    //動画選択
                    movieNum%=movie.length;
                    player.clearVideo();
                    player.cueVideoById(videoId);
                    //player.cueVideoById(movie[movieNum]);//動画ID
                    player.playVideo();//再生
                    t1 = 0;
                    while(timeLine.numChildren > 0){  
                        timeLine.removeChildAt(0);
                    }
                    retry();
                }
        }


        
        
        //プレイヤー設定
        private function onPlayerReady(event:Event):void{
            player = event.currentTarget;
            player.setSize(WIDTH, HEIGHT);//サイズ
            
            //player.cueVideoById(movie[movieNum]);//動画ID
            player.cueVideoById(videoId);//動画ID
            //player.playVideo();//再生
            //players.push(player);//配列に追加
            //t1 = player.getDuration();
txt2.appendText("onPlayerReady:\n"+"t1:"+t1.toString()+"\n");
            txt2.scrollV = txt2.maxScrollV; 
        }
        
        
//-----------------------------動画管理--------------------------------------------------        
//-------------------------------------------------------------------------------------        
        //出現文字と出現頻度を調整
        private var choiceKey:Array = [ 102,106,111,101,117, 102,106,97,101,105,
                                        107,103,104,110,114, 101,110,111,115,119,
                                        87+32,83+32,65+32,90+32,83+32, 68+32,71+32,72+32,84+32,67+32,
                                        88+32,80+32,87+32,76+32,77+32, 86+32,89+32,66+32,81+32,
                                        102,106,111,101,117, 102,106,97,101,105,
                                        107,103,104,110,114, 101,110,111,115,119,
                                        87+32,83+32,65+32,90+32,83+32, 68+32,71+32,72+32,84+32,67+32,
                                        88+32,80+32,87+32,76+32,77+32, 86+32,89+32,66+32,81+32,
                                        //記号(shiftなし)
                                        64,64,64,64,64,64,//@
                                        44,46,44,46,44,46,44,46,//,.
                                        59,58,59,58,59,58,59,58,//;:
                                        92,92,
                                        //記号(shiftあり)
                                        42,43,42,43,42,43,
                                        //数字
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        50,51,52,53,54,55,56,57,48,49,
                                        
                                        
                                        //大文字
                                        70,74,85,73,79, 75,72,78,82,69, 
                                        87,83,65,90,83, 68,71,72,84,67,
                                        88,80,87,76,77, 86,89,66,81 ];
        
        private function openKeyset(_skill:int=1):void{
            var n:int = _skill/3;
            if(n<2)n=2;
            if(39 < n)return;
            for(var i:int=12;i<=59;i++){
                var key:Object = kb.getKey2(i);
                key.setLight(false);
                key.enabled = false;// = char.charAt(i-12); 
            }
            for(var j:int=0;j<n;j++){ 
                var n2:int =choiceKey[j] -32;

                kb.getKey(n2.toString()).enabled = true;
                //kb.getKey(n2.toString()).setColor = color1;
            }
        }

        //文字変更
        private function rndChar(level:int=2):int{
            
            
            //var code:int;
            //文字設定
            //var rnd:int =Math.random()*5;
            
            var n:int = Math.random()*level;
            n %= choiceKey.length;
            //ロストリスト
            for(var i:int=0;i<lostList.length;i++){
                if(choiceKey[n]==lostList[i])return 119;
            }

            return choiceKey[n];
            
        }


        private function selectKey(name:String,select:Boolean=true,color:uint=0xaaaaff):void{
            //keys.push(name);
            kb.getKey(name).setColor(color);
            kb.getKey(name).setLight(select);
            
        }
        
        
        private function keyToCode(CODE:int):int{
            var code:int;
            if(97<=CODE && CODE<=122){
                code = CODE-32;
            }
            //記号
            else{
                if(33<=CODE && CODE<=41){// ! " # $ % & ' ( )
                    //selectKey(String(CODE+16),onLight,color);
                    code = CODE+16;
                }
                else if(42<=CODE && CODE<=47){// * + , - . / 
                    //selectKey(String(CODE+144),onLight,color);
                    code = CODE+144;
                }
                else if(58<=CODE && CODE<=64){// : ; < = > ? @
                    //selectKey(String(CODE+128),onLight,color);
                    code = CODE+128;
                }
                // [ \ ] ^ _ `
                else if(CODE==91)code = 219;//selectKey("219",onLight,color);
                else if(CODE==92)code = 220;//{selectKey("220");selectKey("226",onLight,color);}
                else if(CODE==93)code = 221;//selectKey("221",onLight,color);
                else if(CODE==94)code = 222;//selectKey("222",onLight,color);
                else if(CODE==95)code = 226;//selectKey("226",onLight,color);
                else if(CODE==96)code = 192;//selectKey("192",onLight,color);
                // { | } ~
                else if(CODE==123)code = 219;//selectKey("219",onLight,color);
                else if(CODE==124)code = 220;//selectKey("220",onLight,color);
                else if(CODE==125)code = 221;//selectKey("221",onLight,color);
                else if(CODE==126)code = 222;//selectKey("222",onLight,color);
/*
                //　shiftキー
                if(33<=CODE && CODE<=43){// ! " # $ % & ' ( ) * + 
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(60<=CODE && CODE<=63){// < = > ?
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(CODE==95 || CODE==96){// _ `
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(123<=CODE && CODE<=126){// { | } ~
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
*/
                //大文字 数字
                else code = CODE;
                
            }
            return code;
        }


        //キーボード入力ガイド表示
        private function setKey(CODE:int,onLight:Boolean,color:uint=0xaaaaff):void{
            
            var code:int;
            //小文字
            if(97<=CODE && CODE<=122){
                selectKey(String(CODE-32),onLight,color);// a-z
                return;
            }
            //大文字
            else if(65<=CODE && CODE<=90){
                selectKey("16",onLight,color); selectKey("shift",onLight,color);
                selectKey(String(CODE),onLight,color);// A-Z
                return;

            }
            //数字
            else if(47<CODE && CODE<58){
                selectKey(String(CODE),onLight,color);// 0-9
                return;
            }
            //記号
            else{
                if(33<=CODE && CODE<=41){// ! " # $ % & ' ( )
                    selectKey(String(CODE+16),onLight,color);
                }
                else if(42<=CODE && CODE<=47){// * + , - . / 
                    selectKey(String(CODE+144),onLight,color);
                }
                else if(58<=CODE && CODE<=64){// : ; < = > ? @
                    selectKey(String(CODE+128),onLight,color);
                }
                // [ \ ] ^ _ `
                else if(CODE==91)selectKey("219",onLight,color);
                else if(CODE==92){selectKey("226",onLight,color);selectKey("220",onLight,color);}
                else if(CODE==93)selectKey("221",onLight,color);
                else if(CODE==94)selectKey("222",onLight,color);
                else if(CODE==95)selectKey("226",onLight,color);
                else if(CODE==96)selectKey("192",onLight,color);
                // { | } ~
                else if(CODE==123)selectKey("219",onLight,color);
                else if(CODE==124)selectKey("220",onLight,color);
                else if(CODE==125)selectKey("221",onLight,color);
                else if(CODE==126)selectKey("222",onLight,color);

                //　shiftキー
                if(33<=CODE && CODE<=43){// ! " # $ % & ' ( ) * + 
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(60<=CODE && CODE<=63){// < = > ?
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(CODE==95 || CODE==96){// _ `
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                else if(123<=CODE && CODE<=126){// { | } ~
                    selectKey("16",onLight,color); selectKey("shift",onLight,color);
                }
                
                return;
            }

        }
        
        /*
        * CODE:正解コード　keyCode:入力キー charCode:入力文字コード shiftKey:シフトキー
        */
        private function checkKey(CODE:int,keyCode:int,charCode:int,shiftKey:Boolean):Boolean{
            var code:int = 0;//キーコード
            
            if(CODE == charCode){
                return true;
            }
            //記号１
            else if(33<=CODE && CODE<=47){
               
                if(CODE == 33 && shiftKey==true)code=49;// !
                else if(CODE == 34 && shiftKey==true)code=50;// "
                else if(CODE == 35 && shiftKey==true)code=51;// #
                else if(CODE == 36 && shiftKey==true)code=52;// $
                else if(CODE == 37 && shiftKey==true)code=53;// %
                else if(CODE == 38 && shiftKey==true)code=54;// &
                else if(CODE == 39 && shiftKey==true)code=55;// '
                else if(CODE == 40 && shiftKey==true)code=56;// (
                else if(CODE == 41 && shiftKey==true)code=57;// )
                else if(CODE == 42 && shiftKey==true)code=186;// *
                else if(CODE == 43 && shiftKey==true)code=187;// +
                else if(CODE == 44 && shiftKey==false)code=188;// ,
                else if(CODE == 45 && shiftKey==false)code=189;// -
                else if(CODE == 46 && shiftKey==false)code=190;// .
                else if(CODE == 47 && shiftKey==false)code=191;// /
                if(code == keyCode)return true;
                return false;
            }
            //記号２
           else if(57<CODE && CODE<65){
               
                if(CODE == 58 && shiftKey==false)code=186;// :
                else if(CODE == 59 && shiftKey==false)code=187;// ;
                else if(CODE == 60 && shiftKey==true)code=188;// <
                else if(CODE == 61 && shiftKey==true)code=189;// =
                else if(CODE == 62 && shiftKey==true)code=190;// >
                else if(CODE == 63 && shiftKey==true)code=191;// ?
                else if(CODE == 64 && shiftKey==false)code=192;// @
                
                if(code == keyCode) return true;
                return false; 
            }
            //記号３
            else if(91<=CODE && CODE<=96){
                if(CODE == 91 && shiftKey==false)code=219;// [
                else if(CODE == 92 && shiftKey==false)code=226;// \
                else if(CODE == 93 && shiftKey==false)code=221;// ]
                else if(CODE == 94 && shiftKey==false)code=222;// ^
                else if(CODE == 95 && shiftKey == true)code=226;// _
                else if(CODE == 96 && shiftKey == true)code=192;// `
                else code = 0;
                if(keyCode == code) return true; 
                else if(CODE==92 && shiftKey==false){
                    if(keyCode == 226 || keyCode == 220) return true;
                }
                return false; 
            }
            //記号４
            else if(122<CODE && CODE<127){
                if(CODE == 123 && shiftKey == true)code=219// {
                if(CODE == 124 && shiftKey == true)code=220// |
                if(CODE == 125 && shiftKey == true)code=221// }
                if(CODE == 126 && shiftKey == true)code=222// ~

                if(code == keyCode)return true;
                return false; 
            }
            
 
            return false;
        }//function
    }//class
}//package





// -----------------------------------------------------------------------------------------

// ScoreIndicator

// -----------------------------------------------------------------------------------------

//package {
    import flash.display.*;
    import flash.events.Event; 
    import flash.text.TextField;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;    

    //public
    class ScoreIndicator extends Sprite {
        private var _chars:Vector.<TextField>;
        private var _charIndex:int;
        private var _numCompleted:int;
        //private var color1:uint = 0x0000ff;
        private var color1:uint = 0xffffff;
        //private var color2:uint = 0x00007f;
        private var color2:uint = 0xaaaaff;
        private var _size:Number;
        private var _time:Number;
        
        public function ScoreIndicator(parent:DisplayObjectContainer, centerX:int, bottomY:int, text:String,
                            c1:uint=0xffffff,c2:uint=0xaaaaff,size:Number=50,time:Number=2.3) {
            parent.addChild(this);
            this.mouseEnabled = false;
            x = centerX;
            y = bottomY;
            _size = size;
            _time = time;            
            color1 = c1;
            color2 = c2;          
            _chars = new Vector.<TextField>();
            _charIndex = 0;
            _numCompleted = 0;
            
            splitText(text);//文字列を文字に分割
            alignChars();
            playTween();
            
            addEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
        }
        
        //文字列分割
        private function splitText(text:String):void {
            //this.scaleX = 2;
            //this.scaleY = 2;
            // 文字のスタイルを設定する
            var builder:TextBuilder = new TextBuilder();
            builder.autoCorrect(false).autoSize().bold();
            
            //カラー設定
            //var dmg : Number = Number(text);
            //var c : uint = 256 * (1 - dmg / 10000);
            //builder.font(Main.FONT, Main.EMBED).fontColor(color1 | c<<8 | c).fontSize(50);
            builder.font().fontColor(color1).fontSize(_size);
//            builder.textBorder(true, 0x404040, 2, 4);
            //var d : uint = c / 2;
            //builder.textBorder(true, color2 | d<<8 | d, 10, 20);
            builder.textBorder(true, color2, 10, (_size/6));
           
            for (var i:int = 0; i < text.length; i++) {
                _chars.push(builder.build(text.charAt(i)));
            }
        }
        
        private function alignChars():void {
            var i:int, charsWidth:Number = 0;
            
            for (i = 0; i < _chars.length; i++) {
                charsWidth += _chars[i].textWidth;
            }
2            
            if(_chars[0]){
                _chars[0].x = -int(charsWidth / 2);
                _chars[0].y = -_chars[0].textHeight;
            }
            
            for (i = 1; i < _chars.length; i++) {
                _chars[i].x = _chars[i - 1].x + _chars[i - 1].textWidth;
                _chars[i].y = -_chars[i].textHeight;
            }
        }
        
        //モーショントゥイーン
        private function playTween(event:Event = null):void {
            if (event) { removeEventListener(Event.ENTER_FRAME, playTween); }
            
            var char:TextField = _chars[_charIndex++];
            addChild(char);
            
            // 各文字に適用するトゥーイン
            var tween:ITween = BetweenAS3.bezierTo(char, { y: char.y }, { $y: -(char.textHeight * 2) }, 0.3, Sine.easeInOut);
            tween.onComplete = tweenCompleteHandler;
            tween.play();
            
            if (_charIndex < _chars.length) {
                addEventListener(Event.ENTER_FRAME, playTween);
            }
        }
        
        //
        private function tweenCompleteHandler():void {
            _numCompleted++;
        }
        
        private function checkEveryTweenCompleted(event:Event):void {
            if (_numCompleted == _chars.length) {
                removeEventListener(Event.ENTER_FRAME, checkEveryTweenCompleted);
                BetweenAS3.serial(
                    BetweenAS3.to(this, { alpha: 0 }, _time, Quint.easeInOut),
                    BetweenAS3.removeFromParent(this)
                ).play();
            }
        }
    }
//}


// -----------------------------------------------------------------------------------------

// TextBuilder
/// -----------------------------------------------------------------------------------------
//package {
    import flash.filters.GlowFilter;
    import flash.text.*;
    
    //public
    class TextBuilder {
        public static const ALIGN_LEFT:String = "left";
        public static const ALIGN_RIGHT:String = "right";
        public static const ALIGN_CENTER:String = "center";
        
        private var _posX:Number;
        private var _posY:Number;
        
        private var _width:Number;
        private var _height:Number;
        
        private var _background:Boolean;
        private var _backgroundColor:uint;
        
        private var _border:Boolean;
        private var _borderColor:uint;
        
        private var _fontName:String;
        private var _embedFonts:Boolean;
        private var _advancedAntiAlias:Boolean;
        
        private var _fontSize:int;
        private var _fontColor:uint;
        private var _bold:Boolean;
        
        private var _textBorder:Boolean;
        private var _textBorderColor:uint;
        private var _textBorderBlur:Number;
        private var _textBorderStrength:Number;
        
        private var _align:String;
        private var _autoSizeEnabled:Boolean;
        private var _autoCorrectPositionY:Boolean;
        private var _wordWrap:Boolean;
        
        public function TextBuilder() {
            clear();
        }
        
        public function clear():TextBuilder {
            _posX = 0;
            _posY = 0;
            _width = 100;
            _height = 100;
            _background = false;
            _backgroundColor = 0xffffff;
            _border = false;
            _borderColor = 0x000000;
            _fontName = "Arial";
            _embedFonts = false;
            _advancedAntiAlias = false;
            _fontSize = 12;
            _fontColor = 0x000000;
            _bold = false;
            _textBorder = false;
            _textBorderColor = 0xffff00;
            _textBorderBlur = 4;
            _textBorderStrength = 2;
            _align = TextBuilder.ALIGN_LEFT;
            _autoSizeEnabled = false;
            _autoCorrectPositionY = true;
            _wordWrap = false;
            return this;
        }
        
        public function position(x:Number, y:Number):TextBuilder {
            _posX = x;
            _posY = y;
            return this;
        }
        
        public function size(width:Number, height:Number):TextBuilder {
            _width = width;
            _height = height;
            return this;
        }
        
        public function background(enabled:Boolean, color:uint = 0xffffff):TextBuilder {
            _background = enabled;
            _backgroundColor = color;
            return this;
        }
        
        public function border(enabled:Boolean, color:uint = 0x000000):TextBuilder {
            _border = enabled;
            _borderColor = color;
            return this;
        }
        
        public function font(name:String="Arial", embed:Boolean = false, advancedAntiAlias:Boolean = false):TextBuilder {
            _fontName = name;
            _embedFonts = embed;
            _advancedAntiAlias = advancedAntiAlias;
            return this;
        }
        
        public function fontSize(size:int):TextBuilder {
            _fontSize = size;
            return this;
        }
        
        public function fontColor(color:uint):TextBuilder {
            _fontColor = color;
            return this;
        }
        
        public function bold(enabled:Boolean = true):TextBuilder {
            _bold = enabled;
            return this;
        }
        
        public function textBorder(enabled:Boolean, color:uint = 0xffff00, blur:Number = 4, strength:Number = 2):TextBuilder {
            _textBorder = enabled;
            _textBorderColor = color;
            _textBorderBlur = blur;
            _textBorderStrength = strength;
            return this;
        }
        
        public function align(value:String = TextBuilder.ALIGN_LEFT):TextBuilder {
            _align = value;
            return this;
        }
        
        public function autoSize(enabled:Boolean = true):TextBuilder {
            _autoSizeEnabled = enabled;
            return this;
        }
        
        public function autoCorrect(positionY:Boolean = true):TextBuilder {
            _autoCorrectPositionY = positionY;
            return this;
        }
        
        public function wordWrap(enabled:Boolean = true):TextBuilder {
            _wordWrap = enabled;
            return this;
        }
        
        public function build(text:String):TextField {
            var textField:TextField = new TextField();
            
            textField.x = _posX;
            textField.y = _posY;
            textField.width = _width;
            textField.height = _height;
            
            var format:TextFormat = new TextFormat(_fontName, _fontSize, _fontColor, _bold);
            if (_autoSizeEnabled) {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { textField.autoSize = TextFieldAutoSize.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { textField.autoSize = TextFieldAutoSize.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { textField.autoSize = TextFieldAutoSize.CENTER; break; }
                }
            }else {
                switch(_align) {
                    case TextBuilder.ALIGN_LEFT: { format.align = TextFormatAlign.LEFT; break; }
                    case TextBuilder.ALIGN_RIGHT: { format.align = TextFormatAlign.RIGHT; break; }
                    case TextBuilder.ALIGN_CENTER: { format.align = TextFormatAlign.CENTER; break; }
                }
            }
            
            textField.embedFonts = _embedFonts;
            textField.antiAliasType = (_advancedAntiAlias ? AntiAliasType.ADVANCED : AntiAliasType.NORMAL);
            textField.defaultTextFormat = format;
            textField.text = text;
           
            if (textField.background = _background) { textField.backgroundColor = _backgroundColor; }
            if (textField.border = _border) { textField.borderColor = _borderColor; }
            if (_textBorder) { textField.filters = [new GlowFilter(_textBorderColor, 1, _textBorderBlur, _textBorderBlur, _textBorderStrength)]; }
            if (!(textField.wordWrap = _wordWrap) && _autoCorrectPositionY) { textField.y += Math.max(0, Math.ceil((_height - (textField.textHeight + 4)) / 2)); }
            textField.mouseEnabled = textField.selectable = false;
            
            return textField;
        }
        
        public function clone():TextBuilder {
            var clone:TextBuilder = new TextBuilder();
            clone._posX = _posX;
            clone._posY = _posY;
            clone._width = _width;
            clone._height = _height;
            clone._background = _background;
            clone._backgroundColor = _backgroundColor;
            clone._border = _border;
            clone._borderColor = _borderColor;
            clone._fontName = _fontName;
            clone._embedFonts = _embedFonts;
            clone._advancedAntiAlias = _advancedAntiAlias;
            clone._fontSize = _fontSize;
            clone._fontColor = _fontColor;
            clone._bold = _bold;
            clone._textBorder = _textBorder;
            clone._textBorderColor = _textBorderColor;
            clone._textBorderBlur = _textBorderBlur;
            clone._textBorderStrength = _textBorderStrength;
            clone._align = _align;
            clone._autoSizeEnabled = _autoSizeEnabled;
            clone._autoCorrectPositionY = _autoCorrectPositionY;
            clone._wordWrap = _wordWrap;
            return clone;
        }
    }
//}





/////////////////////////////////////////////////////////

//    キーボード表示

/////////////////////////////////////////////////////////

import flash.system.*;

import flash.events.*;
import flash.filters.GlowFilter;
import flash.ui.*;

class KeyBoardBtn extends Sprite{
    private var btn:Btn;
    
    private var _caps:Boolean = false;
    private var _alt:Boolean = false;
    private var _ctrl:Boolean = false;
    private var _shift:Boolean = false;
    
    private var keyList:Array = new Array();
    private var keyLength:int;//キーの数
    private var _color1:uint = 0x0000ff;
    private var _color2:uint = 0x000000;//キーボードベースカラー
    
    public var _charset1:String = " 1234567890-^￥qwertyuiop@[asdfghjkl;:]zxcvbnm,./\\";
    public var _charset2:String = " !\"#$%&'() =~|QWERTYUIOP`{ASDFGHJKL+*}ZXCVBNM<>?_"; 
    private var _text:String = new String();
    
    public function KeyBoardBtn():void{
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    
    private function init(e:Event=null):void{        
        var i:int;
        // BackSpace
        btn = new Btn();
        btn.name = "8";
        btn.x = 355;        btn.y = 0;
        btn.text = "Bs"; 
        
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text = _text.substr(0,_text.length-1);
        });
       
        // Tab
        btn = new Btn(30);
        btn.name = "9";
        btn.x = 0;        btn.y = 25;
        btn.text = "Tab"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\t";
        });
        
        // Enter
        btn = new Btn(30,45);
        btn.name = "13";
        btn.x = 345;        btn.y = 25;
        btn.text = "Enter"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\r";
        });
 
        // Caps Lock
        btn = new Btn(40);
        btn.name = "240";
        btn.x = 0;        btn.y = 50;
        btn.text = "Caps"; 
        addChild(btn);
        keyList.push(btn);
        
        // Shift (左)    
        btn = new Btn(54);
        btn.name = "16";
        btn.x = 0;        btn.y = 75;
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("16").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
            
        });
        
        // Shift (右)
        btn = new Btn(40);
        btn.name = "shift";
        btn.x = 335;        btn.y = 75; 
        btn.text = "Shift"; 
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_shift==false){
                shift = true;
                getKey("shift").setLight(true);
            }
            else{ 
                shift = false;
                getKey("shift").setLight(false);
                getKey("16").setLight(false);
            }
        });
      
        // Ctrl (左)
        btn = new Btn(30);
        btn.name = "17";
        btn.x =0;        btn.y = 100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("17").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
        
        // Ctrl (右)
        btn = new Btn(30);
        btn.name = "ctrl";
        btn.x =345;        btn.y =100;
        btn.text = "Ctrl";
        addChild(btn);
        keyList.push(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            if(_ctrl==false){
                _ctrl = true;
                getKey("ctrl").setLight(true);
            }
            else{ 
                _ctrl = false;
                getKey("ctrl").setLight(false);
                getKey("17").setLight(false);
            }
        });
 
        // space
        btn = new Btn(90);
        btn.name = "32";
        btn.x =135;        btn.y =100;
        addChild(btn);
        keyList.push(btn);

        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += " ";
        });
        
        // Alt
        btn = new Btn(30);
        btn.name = "18";
        btn.x =65;        btn.y =100;
        btn.text = "Alt";
        addChild(btn);
        keyList.push(btn);
        
        // Alt2
        btn = new Btn();
        btn.name = "alt";
        btn.x =275;        btn.y =100;
        btn.text = "Alt";
        addChild(btn);    
        keyList.push(btn);  
        
        // 半角/全角
        btn = new Btn();
        btn.name = "244";
        btn.x = 0;        btn.y = 0; 
        addChild(btn);
        keyList.push(btn);

        

        
        var key:Array = new Array();
        key.push("49"); key.push("50"); key.push("51"); key.push("52"); key.push("53");
        key.push("54"); key.push("55"); key.push("56"); key.push("57"); key.push("48");
        key.push("189"); key.push("222"); key.push("220");   
        
        
        for(i=0;i<13;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+25;            btn.y = 0;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("81"); key.push("87"); key.push("69"); key.push("82"); key.push("84");
        key.push("89"); key.push("85"); key.push("73"); key.push("79"); key.push("80");
        key.push("192"); key.push("219");
        
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+35;            btn.y = 25;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("65"); key.push("83"); key.push("68"); key.push("70"); key.push("71");
        key.push("72"); key.push("74"); key.push("75"); key.push("76"); key.push("187");
        key.push("186"); key.push("221");    
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+45;            btn.y = 50;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        key = new Array();
        key.push("90"); key.push("88"); key.push("67"); key.push("86"); key.push("66");
        key.push("78"); key.push("77"); key.push("188"); key.push("190"); key.push("191");
        key.push("226");
            
        for(i=0;i<11;i++){
            btn = new Btn();
            btn.name = key[i];
            btn.x = i*25+60;            btn.y = 75;
            addChild(btn);
            keyList.push(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown); 
        }
        
        shift = false;
        
        keyLength = keyList.length;
        stage.addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        stage.addEventListener(KeyboardEvent.KEY_UP,offKey);
        stage.stageFocusRect = false;
        color = 0x0000ff;
    }

    



    

    private function onKey(e:KeyboardEvent):void{
        var name:String = e.keyCode.toString();            
        if(0 < e.keyLocation){
            if(e.shiftKey==true)shift=true;
            //if(e.ctrlKey==true)ctrl=true;
        }

        
        if(1 < e.keyLocation){
            if(e.keyCode==16)getKey("shift").press();
            if(e.keyCode==17)getKey("ctrl").press();
            if(e.keyCode==18)getKey("alt").press();
        }
        else{
            getKey(name).press();
            if(33<=e.charCode && e.charCode<=126 && getKey(name).text!=" ")_text += getKey(name).text;
            //スペース
            if(e.keyCode == 32)_text += " ";
            //バックスペース
            if(e.keyCode == 8 && 0<_text.length)_text = _text.substring(0,_text.length-1);
            //エンター
            if(e.keyCode == 13)_text += "\n";
            //半角/全角
            if(e.keyCode == 244)_text += getKey(name).text;
            //タブ
            if(e.keyCode == 9)_text += "\t";
        }
    }

    

    public function set color(col:uint):void{
        _color1 = col;
        for(var i:int=0;i<keyLength;i++){
            var key:Object = getKey2(i);
            key.setColor(_color1);           
        }
    }



    

    public function offKey(e:KeyboardEvent):void{
            var name:String = e.keyCode.toString();
            getKey(name).release();
            if(name == "16")getKey("shift").release();
            if(name == "17")getKey("ctrl").release();
            if(name == "18")getKey("alt").release();
            //if(name == "13")kb.getBtn("enter").release();
            if(e.shiftKey==false)shift=false;
        }



    

    private function set shift(b:Boolean):void{
        
            var char:String;
            _shift = b;
            if(_shift==true)char = _charset2;
            else char = _charset1;

            for(var i:int=11;i<=59;i++){
                var key:Object = getKey2(i);
                key.text = char.charAt(i-11); 
            }
    }
    
    public function get length():int{
        return keyLength;
    }

    public function getKey2(keyNum:int):Object{
        return keyList[keyNum];
    }


    
    public function getKey(name:String):Object{
        //return this.btn.getChildByName(name); 
        return this.getChildByName(name);
    }


    
    private function onKeyDown(e:MouseEvent):void{
            _text += e.currentTarget.text;
    }
    
    public function get text():String{
        return _text;
    }
    public function set text(str:String):void{
        _text = str;
    }

    

    

    private var selectKeys:Array = new Array();
    public function selectKey(n:int,color:uint=0x00ff00):void{
        var key:Object = this.getChildAt(n);
        key.setColor(color);
        key.setLight(true);
        selectKeys.push(key);
    }
    public function resetKey():void{
        for(var i:int=0;i<selectKeys.length;i++){
            var key:Object = selectKeys[i];
            key.setLight(false);
        }
        while(0<selectKeys.length)selectKeys.pop();
    }


        
    

    
}



//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import caurina.transitions.Tweener;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private var _width:uint = 60;
    private var _height:uint = 20;
    private static var corner:uint = 3;
    private var type:uint = 1;
    private static var bColor:uint = 0x000000;
    private static var sColor:uint = 0xccccff;
    private static var upColor:uint = 0x333333;
    private static var overColor:uint = 0xccccff;
    private static var offColor:uint = 0x111111;
    private var gColor:uint = 0x00ff00;
    private var glow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;
    public var lightOn:Boolean = false;
    private var onSelected:Boolean = false;    
    private var isEnterKey:Boolean = false;

    public function Btn(width:Number=20,height:Number=20) {
        _width = width;
        _height = height;
        draw();
    }

    private function draw():void {

        glow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);

        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [glow];
        
        createBase(base, _width, _height, corner, bColor);

        //txt.x = -_width*0.5;
        txt.y = _height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        //tf.font = fontType;
        //tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    
    private var preColor:uint=0x000000;
    public function setColor(c:uint):void{
        preColor = gColor;
        gColor = c;
        var glow:GlowFilter = new GlowFilter(gColor, 0.7, 8, 8, 2, 3, false, true); 
        light.filters = [glow];
    }

    private var gColor2:uint;    
    private function changeColor(c:uint):void{
        gColor2 = c;
        var glow:GlowFilter = new GlowFilter(gColor2, 0.7, 8, 8, 2, 3, false, true); 
        light.filters = [glow];
    }

    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
    }
    public function set fontSize(n:int):void{
        var tf:TextFormat = new TextFormat();
        //tf.font = fontType;
        tf.size = n;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        
    }
    public function textColor(c1:uint,c2:uint):void{
        overColor = c1;
        upColor = c2;
        txt.textColor = c2;//_off();
    }
    
    public function setLight(s:Boolean):void{
        this.addEventListener(Event.ENTER_FRAME,offEffect);
        lightOn = s;
        light.visible = s;
        if(s)txt.textColor = overColor;
        else txt.textColor = upColor;
    }
    
    public function get select():Boolean{
        return lightOn;
    }

    //イベント
    private function rollOver(evt:MouseEvent):void {
        _over();
    }    
    private function rollOut(evt:MouseEvent):void {
        _up();    
    }
    public function press(evt:MouseEvent=null):void {
        _down();
    }
    public function release(evt:MouseEvent=null):void {
        _up();
        
        this.addEventListener(Event.ENTER_FRAME,offEffect);
    }
    private function click(evt:MouseEvent):void {
    }
    
    private function _up():void {
        txt.y = 0;
        
        if(this.lightOn ==false)txt.textColor = upColor;//テキストカラー
        if(this.lightOn ==false)light.visible = false;//ライト
        light.y = -1;
        base.y = -1;
        //cnt1=0;
        //this.addEventListener(Event.ENTER_FRAME,offEffect);
    }
    private var glowTime:int = 60;
    private var cnt1:int;
    private function offEffect(e:Event):void{
        var n:Number = 1 / (cnt1/glowTime);
        var r:uint = preColor & 0xff0000;
        var g:uint = preColor & 0x00ff00;
        var b:uint = preColor & 0x0000ff;
        
        var r2:uint = gColor & 0xff0000;
        var g2:uint = gColor & 0x00ff00;
        var b2:uint = gColor & 0x0000ff;
        
        var col:uint = 0x000000;
        col+= ((uint)((r*n)+r2)/2)<<16;
        col+= ((uint)((g*n)+g2)/2)<<8;
        col+= ((uint)((b*n)+b2)/2);
        changeColor(col);
        cnt1++;
        if(glowTime<cnt1){ 
            setColor(gColor);
            if(this.lightOn ==false)light.visible = false;//ライト
            this.removeEventListener(Event.ENTER_FRAME,offEffect);
            cnt1=0;
        }
    }


    private function _over():void {
        txt.y = 0;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
        //cnt1=0;
    }
    private function _off():void {
        txt.y = 0;
        if(this.lightOn ==false)txt.textColor = offColor;
        base.y = 0;
        if(this.lightOn ==false)light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }

    

    public function get enabled():Boolean {
        return _enabled;
    }
    

    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(0,0, w, h, c*2);
        target.graphics.endFill();
    }
}




import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;

class InputBox extends Sprite {
        
    private var 
        w:int,
        h:int =  66,
        b:int =  10,
        inputBackground:Sprite = new Sprite,
        inputField:TextField = new TextField,
        labelField:TextField = new TextField;


    public function InputBox(hint:String = "search...", width:int = 380) {
        
        //var g:Graphics = graphics; g.lineStyle(0,0,0.1); g.drawCircle(0,0,10);
        
        addChild(inputBackground);
        
        w = width;
        
        inputField.defaultTextFormat = new TextFormat("Trebuchet MS", 30, 0x808080);
        inputField.htmlText = "<font color='#808080'>"+hint+"</font>";
        inputField.width = w - b*2 - (h-b*2);
        inputField.height = h - b*2;
        inputField.x = -inputField.width >>1;
        inputField.y = 4 - (inputField.height>>1);
        inputField.type = TextFieldType.INPUT;
        //inputField.embedFonts = true;
        addChild(inputField);
        
        draw();
        
        inputField.addEventListener(FocusEvent.FOCUS_IN, function (e:Event):void {
            inputField.defaultTextFormat = new TextFormat("Trebuchet MS", 30, 0x808080); 
            inputField.text="";
        });
        
        inputField.addEventListener(Event.CHANGE, function (e:Event):void {
            dispatchEvent(new Event(Event.CHANGE));
        });
        
        addEventListener(Event.ADDED_TO_STAGE, function(e:Event):void {
            stage.addEventListener(Event.RESIZE, resize);
            resize();
        }); 

    }
    
    
    public function get text():String {
        return inputField.text;
    }
    public function set text(str:String):void{
        inputField.text = str;
    }
    
    
    private function resize(e:Event = null):void {
        x= stage.stageWidth/2;
        y= stage.stageHeight-height;
    }
    
    
    private function draw():void {
        
        var g:Graphics = graphics;
        g.clear();
        var m:Matrix = new Matrix;
        m.createGradientBox(h,h,Math.PI/2,0,0);
        g.beginGradientFill(GradientType.LINEAR, [0xDEDEDE, 0xA5A5A5], [1,1], [0,255], m);
        g.drawRoundRect(-w>>1, -h>>1, w, h, h, h);
        g.endFill()

        g = inputBackground.graphics;
        g.clear();
        m.createGradientBox(h,h,Math.PI/2,0,0);
        g.beginFill(0xFFFFFF);
        var ww:int = w-b*2;
        var hh:int = h-b*2;
        g.drawRoundRect(-ww>>1, -hh>>1, ww, hh, hh, hh);
        g.endFill()
        inputBackground.filters = [new DropShadowFilter(4,45,0,0.4,10,10,1,2,true)];
    }    
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------
import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
//package{
    class Playlist extends Sprite{ 
        public var loader:TubeLoader;
        private var s1:Sprite = new Sprite();
        //private var t3:TextField = new TextField();
        //private var t2:InputBox = new InputBox();
        private var selectId:String;
        private var lastY:int=0;
        private var scrY:int = 0;
        private var listCnt:int=0;
        private var key:String;
        private var nowLoading:Boolean = false;
        private var upBtn:Btn = new Btn(100,20);
        private var downBtn:Btn = new Btn(100,20);
        private var _upScroll:Boolean;
        private var _downScroll:Boolean;
        public function Playlist():void{
            addChild(s1);
            loader = new TubeLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);
            //upBtn.alpha = 0.8;
            upBtn.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                _upScroll=true;
                addEventListener(Event.ENTER_FRAME,onFrame);
            });
            upBtn.addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                _upScroll=false;
                removeEventListener(Event.ENTER_FRAME,onFrame);
            });
            downBtn.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                _downScroll=true;
                addEventListener(Event.ENTER_FRAME,onFrame);
            });
            downBtn.addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                _downScroll=false;
                removeEventListener(Event.ENTER_FRAME,onFrame);
            });
            upBtn.x = 100;
            upBtn.text = "▲";
            downBtn.text = "▼";
            downBtn.x = 100;
            downBtn.y = 390;
            addChild(upBtn);
            addChild(downBtn);
        }
        private function onFrame(e:Event):void{ 
            var n:int = 13;
            if(_downScroll==true) n *= -1;
            
            s1.y += n;
            scrY += n;
            
            if(s1.y>0)s1.y=0;
            if(scrY<200 && nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key); 
            }
        }
        public function get id():String{
            return selectId;
        }
        
        public function search(str:String):void{ 
            key = str;
            if(nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key);
            }
        }

        private function onWheel(e:MouseEvent):void{
            var scr:int = e.delta*10;
            s1.y += scr;
            scrY += scr;
            if(0<s1.y)s1.y = 0;
            if(scrY<200 && nowLoading == false){ 
                nowLoading = true;
                loader.requestWords(key);
            }
        }
        
        private function onComplete(e:Event):void{ 
            nowLoading = false;            
            //t.text = "";
            if(loader.idList.length<=listCnt){
                while(0<s1.numChildren)s1.removeChildAt(0);
                lastY=0;
                listCnt=0;
                scrY=0;
                s1.y=0;
            }

            for(var i:int=listCnt;i<loader.idList.length;i++){                 
                var w:int=480;//320;
                var h:int=360;//180;
                var base:Sprite = new Sprite();
                s1.addChild(base);
                var m:Shape = new Shape();
                m.graphics.beginFill(0x000000);
                m.graphics.drawRect(0,0,w,h);
                m.graphics.endFill();
                //m.y = lastY;
                base.addChild(m);
                var sh:Shape = new Shape();
                sh.graphics.beginFill(0x000000,0.2);
                sh.graphics.drawRect(0,0,w,h);
                sh.graphics.endFill();
                sh.filters = [new DropShadowFilter(15, 35, 0x000000, 3,3,3,3)];
                base.addChild(sh);
                base.scaleX = 0.8;
                base.scaleY = 0.8;
                
                var id:String = loader.idList[i].toString();
                var s:Sprite = loader.getImage(id,3);
                //s.scaleX = 0.5;
                //s.scaleY = 0.5;
                s.mask = m;
                base.addChild(s);
                
                
                base.y = lastY;
                var t:TextField = new TextField();
                t.defaultTextFormat = new TextFormat("_sans", 18, 0x000000);
                t.antiAliasType  = flash.text.AntiAliasType.ADVANCED;
                //t.border=true;
                t.text+=loader.titleList[i]+"  ";
                
                var n:int = loader.durationList[i];
                var min:int = n/60;
                var sec:int = n%60;
                t.text+= min.toString()+":"+sec.toString()+"\n";
                //t.text+= "投稿者 :  "+loader.authorList[i]+"\n";
                //t.text+=loader.idList[i].toString()+"\n";
                t.width=w//t.textWidth+5;
                t.wordWrap=true;
                t.height=t.textHeight+5;
                
                t.textColor = 0xffffff;
                t.filters = [new DropShadowFilter(0, 0, 0x000000, 3,3,2,2)];

                t.selectable=false;
                //t.y=lastY;
                //t.x=130;
                base.addChild(t);
                
                var sh2:Sprite = new Sprite();
                sh2.graphics.lineStyle(0,0x000000);
                sh2.graphics.beginFill(0x000000,0);
                sh2.graphics.drawRect(0,0,w,h);
                sh2.graphics.endFill();
                
                sh2.addEventListener(MouseEvent.CLICK,onClick);
                sh2.name = id;
                sh2.buttonMode = true;
                base.addChild(sh2);
                base.y = lastY;
                
                lastY+=h+10;//t.height;
                
            }
            /*
            t = new TextField();
            t.text = loader.idList.length.toString();
            //t.height = 20;
            t.width = 300;
            t.y = lastY;
            //t.text+="\n";
            //t.scrollV = t.maxScrollV;
            t.text += loader._xml;
            lastY+= t.height;
            s1.addChild(t);
            //*/
            lastY+=20;
            
            scrY = lastY+s1.y-400;
            listCnt = loader.idList.length;
            
            s1.graphics.clear();
            s1.graphics.beginFill(0x000000,0);
            s1.graphics.drawRect(0,0,s1.width,s1.height);
            s1.graphics.endFill();
            
        }
        private function onClick(e:MouseEvent):void{
            selectId = e.currentTarget.name;
        }
        
    }
//}//package



import flash.text.*;
import flash.display.*;
import flash.net.*;
import flash.events.*;
import flash.utils.*;
import flash.system.*;
class TubeLoader extends Sprite{

        //動画ID取得
        //投稿者取得
        //動画タイトル取得
        //再生時間取得
        
        //キーワード検索
        //投稿者検索
        
        private var loader:URLLoader;
        public var idList:Array;
        public var titleList:Array;
        public var authorList:Array;
        public var durationList:Array;
        private var _words:String = "";//前回の検索ワード
        private var cnt:int=0;//リクエスト回数
        private var _results:int = 20;        
        public function TubeLoader() {
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
        }
        
        public function clear():void{
            idList = new Array();
            titleList = new Array();
            authorList = new Array();
            durationList = new Array();
            cnt=0;
        }
        
        public function set results(n:int):void{
            _results = n;
            clear();
        }
        
        public function requestWords(key:String):void{            
            //var str:String = "http://gdata.youtube.com/feeds/api/videos/-/";
            var str:String = "http://gdata.youtube.com/feeds/api/videos?"
            if(_words != key){ 
                _words = key;
                clear();
            }
            str += "q="+escapeMultiByte(_words);//検索ワード
            //str += escapeMultiByte(_words)+"?";//検索ワード
            str += "&max-results="+_results.toString();//件数
            str += "&start-index="+(cnt*_results+1).toString();//インデックス
            str += "&v=2";
            //var loader:URLLoader = new URLLoader();
            
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE,onComplete);
            var url:URLRequest = new URLRequest(str);
            loader.load(url);
            cnt++;
        }
        
        public function getImage(id:String,num:int=1):Sprite{
            var loader:Loader;
            loader = new Loader();
            const str1:String = "http://i.ytimg.com/vi/";
            const str3:String = "/default.jpg";
            const str4:String = "/0.jpg";
            const str5:String = "/hqdefault.jpg";
            var req2:String;
            switch(num){
                case 0:
                    req2 = str1+id+str4;
                    break;
                case 1:
                    req2 = str1+id+"/mqdefault.jpg";
                    break;
                case 2:
                    req2 = str1+id+"/2.jpg";
                    break;
                case 3:
                    req2 = str1+id+str5;
                    break;
            }

            
            loader.load(new URLRequest(req2));//youtubeプレイヤー読み込み
            var s:Sprite = new Sprite();
            s.addChild(loader);
            return s;
        }


        
        public var _xml:String;
        private function onComplete(e:Event):void{
            loader.removeEventListener(Event.COMPLETE,onComplete);
            var res:XML = new XML(e.target.data);
            var list:XMLList = res.children();
            //var str:String = "";
            var cnt:int=0;
            
            for(var i:int=0;i<list.length();i++){
                if(list[i].localName()!="entry")continue;
                var list3:XMLList = list[i].elements();
                for(var j:int=0;j<list3.length();j++){
                    if(list3[j].localName()=="title"){ //タイトル抽出
                        //str += list3[j].text()+"\n";
                        var title:String = new String();
                        title += list3[j].text();
                        titleList.push(title);
                    }
                    else if(list3[j].localName()=="id"){ //ID抽出
                        var str3:String = list3[j].text();
                        var n:int = str3.indexOf("video:")+6;
                        //var n:int = str3.indexOf("videos/")+7;
                        var id:String = str3.substring(n);
                        //str += id+"\n";
                        idList.push(id);
                    }
                    else if(list3[j].localName()=="author"){//投稿者名
                        var str4:String;
                        var list2:XMLList = list3[j].elements();
                        str4 = list2[0].text();
                        authorList.push(str4);
                    }
                    else if(list3[j].localName()=="group"){//再生時間
                        var str5:String = list3[j].toXMLString();
                        var n2:int = str5.indexOf('duration="')+10;
                        var n3:int = str5.indexOf('"',n2);
                        var n4:int = parseInt(str5.substring(n2,n3));
                        durationList.push(n4);
                    }
                    
                }

                //str += list3.elements("id").toXMLString()+"\n\n";
                //str += i.toString()+" "+list[i].localName()+"\n";
                //str += list[i].toXMLString()+"\n\n";
                //str += "\n";
                _xml = res.toXMLString();
            }
            
            //コンプリートイベント発行
            var event:Event = new Event(Event.COMPLETE);
            this.dispatchEvent(event);
        }
    }
//}
