/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9fXN
 */

// forked from curvedstraightline's blendmode.add＆blur円の浮遊
// forked from curvedstraightline's invertした円が気ままに動く
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    public class FlashTest extends Sprite 
    {
        private const CANVAS_WIDTH:int=stage.stageWidth;
        private const CANVAS_HEIGHT:int=stage.stageHeight;
        private const CANVAS_COLOR:uint=0x000000;
        private const CIRCLE_NUMBER:int=20;
        
        public function FlashTest() 
        {
            stage.quality=StageQuality.LOW;
            createCanvas();
        }
        private function createCanvas():void
        {
            var canvas_data:BitmapData=new BitmapData
            (
                CANVAS_WIDTH,
                CANVAS_HEIGHT,
                false,
                CANVAS_COLOR
            );
            addChild(new Bitmap(canvas_data));
            createCircle();
        }
        private function createCircle():void
        {
            Circle.setting(CANVAS_WIDTH,CANVAS_HEIGHT,BlendMode.ADD);
            for(var i:int=0;i<CIRCLE_NUMBER;++i)
            {
                addChild(new Circle());
            }
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.filters.BlurFilter;
import gs.TweenLite;
import gs.easing.Sine;
class Circle extends Bitmap
{
    private static const CIRCLE_MAX_SIZE:int=300;
    private static const CIRCLE_MIN_SIZE:int=120;
    private static const BLUR_SIZE:int=64;
    private static const BLUR_QUALITY:int=2;
    private static const COLOR_MAX:uint=0x80;
    private static var CANVAS_WIDTH:int;
    private static var CANVAS_HEIGHT:int;
    private static var BLEND_MODE:String;
    
    private static var reuseShape:Shape;
    private static var reuseBlur:Array;
    
    public static function setting(canvasWidth:int,canvasHeight:int,blendMode:String):void
    {
        CANVAS_WIDTH=canvasWidth;
        CANVAS_HEIGHT=canvasHeight;
        BLEND_MODE=blendMode;
        reuseShape=new Shape();
        reuseBlur=[new BlurFilter(BLUR_SIZE,BLUR_SIZE,BLUR_QUALITY)];
        reuseShape.filters=reuseBlur;
    }
    
    private var posX:int;
    private var posY:int;
    private var sizeW:int;
    private var sizeH:int;
    private var time:int;
    
    public function Circle()
    {
        create();
    }
    
    private function setProperty():void
    {
        posX=int(Math.random()*CANVAS_WIDTH);
        posY=int(Math.random()*CANVAS_HEIGHT);
        sizeW=int(Math.random()*(CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)+CIRCLE_MIN_SIZE);
        sizeH=int(Math.random()*(CIRCLE_MAX_SIZE-CIRCLE_MIN_SIZE)+CIRCLE_MIN_SIZE);
        time=int(Math.random()*10)+1;
    }
    
    private function create():void
    {
        setProperty();
        
        var color:uint=Math.random()*COLOR_MAX<<16|Math.random()*COLOR_MAX<<8|Math.random()*COLOR_MAX<<0;
        var ir:int=CIRCLE_MIN_SIZE;
        var or:int=ir+(BLUR_SIZE*BLUR_QUALITY)/2;
        
        reuseShape.graphics.clear();
        reuseShape.graphics.beginFill(color,1);
        reuseShape.graphics.drawCircle(or,or,ir);
        reuseShape.graphics.endFill();
        
        bitmapData=new BitmapData(or*2,or*2,false,0x000000);
        bitmapData.draw(reuseShape);
        
        x=posX-sizeW;
        y=posY-sizeH;
        width=sizeW*2;
        height=sizeH*2;
        blendMode=BLEND_MODE;
        
        motion();
    }
    
    private function motion():void
    {
        setProperty();
        TweenLite.to(this,time,
            {
                ease:Sine.easeInOut,
                x:posX-sizeW,
                y:posY-sizeH,
                width:sizeW*2,
                height:sizeH*2,
                onComplete:motion
            }
        );
    }
}
