/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9fP30
 */

// forked from mutantleg's Texture Matrix
package {
    import flash.geom.Vector3D;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix3D;
    import flash.utils.ByteArray;
    import flash.events.ErrorEvent;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProfile;
    import flash.display3D.Context3DRenderMode;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DBlendFactor;
    import flash.display3D.Context3DCompareMode;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DTriangleFace;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.VertexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.textures.Texture;
    public class FlashTest extends Sprite {
        
        public static var deb:TextField;
        
        public function FlashTest() {
 
            deb = new TextField();
            addChild(deb);
            deb.width = 400;
            deb.text = " debug ";
            
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }//ctor
        
        public function init(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //if (stage == null) { deb.text = "stage null"; }
           // else { deb.text = "stage exist"; }
            //deb.text = "stage > " + stage.stage3Ds[0];
            
            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contReady);
            stage.stage3Ds[0].addEventListener(ErrorEvent.ERROR, onError);
            stage.stage3Ds[0].requestContext3D(Context3DRenderMode.AUTO);
            
           // deb.text = " reach ";
        }//init
    
        private var context:Context3D;
        
        public function onError(e:ErrorEvent):void
        {
            deb.text = e.text;
            deb.textColor = 0xFF0000FF;
        }//onerror
        
        public function contReady(e:Event):void
        {
            deb.text = "context ready ";
            
            context = stage.stage3Ds[0].context3D;
            deb.text = context.driverInfo;
            //deb.textColor = 0xFFffFFff;
            
            context.addEventListener(ErrorEvent.ERROR, onError);
            
            context.configureBackBuffer(465, 465, 2, true);
        
        
            initProgram(context);    
           
            createBuffer(context);
            
            myTex = new wTex();
       
                myTex.genTex(myTex.getXor(1024,1024), context);
           

            var pic:Bitmap;
            pic = new Bitmap(new BitmapData(200,200,false,0));
            context.clear();
            draw(context);
            context.drawToBitmapData(pic.bitmapData);
            //context.present();            
           // addChild(pic);
            pic.x = 200;
        
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//contready
        
        public var prog:Program3D;
        public var bufVert:VertexBuffer3D;
        public var bufCol:VertexBuffer3D;
        public var bufFace:IndexBuffer3D;
        public var myTex:wTex;
        public var bufUv:VertexBuffer3D;
        
        public function createBuffer(c:Context3D):void
        {
            var p:Number;
            var n:Number;
            var scale:Number;
            var vecFace:Vector.<uint>;
            var vecVert:Vector.<Number>;
            var vecCol:Vector.<Number>;
            var vecUv:Vector.<Number>;
            
            scale = 4.0;

            p = 0.5 * scale;
            n = -0.5 * scale;
            
            vecFace  = Vector.<uint>([1, 0, 2, 1, 2, 3]);

            vecVert  = Vector.<Number>([
             n, n, 0.0,
             p, n, 0.0,
             n, p, 0.0,
             p, p, 0.0 ]);
             
            vecCol = Vector.<Number>([
            1.0, 0, 0, 1.0,
            0, 1.0, 0, 1.0,
            0, 0, 1.0, 1.0,
            1.0, 1.0, 1.0, 0  ]); 
            
            vecUv =  Vector.<Number>([
            0.0, 0.0,
            1.0, 0.0,
            0.0, 1.0,
            1.0, 1.0  ]);
            
             bufVert = c.createVertexBuffer(4, 3);
             bufFace = c.createIndexBuffer(2 * 3);
             bufCol = c.createVertexBuffer(4, 4);
             bufUv = c.createVertexBuffer(4, 2);
             
             bufVert.uploadFromVector(vecVert, 0, 4);
             bufFace.uploadFromVector(vecFace, 0, 2 * 3);
             bufCol.uploadFromVector(vecCol, 0, 4);
            bufUv.uploadFromVector(vecUv, 0, 4);
        }//createbuffer
        
        public function initProgram(c:Context3D):void
        { 
            prog = c.createProgram();
                       
            var vert:ByteArray;
            var frag:ByteArray;
            var assembler:AGALMiniAssembler = new AGALMiniAssembler();
            
            var code:String;
                code = "";
                code += "m44 op, va0, vc0\n";
               // code += "m44 v0, va1, vc4\n";
                code += "move v0, va1\n";
                code += "m44 v1, va2, vc4\n"
              //  code += "move v1, va2\n";
                
                    vert = assembler.assemble(Context3DProgramType.VERTEX, code);
                
                code = "";
                code += "tex ft0 v1, fs0 <2d, linear, miplinear, wrap>\n";
                //code += "move oc, v0\n";
                //code += "mov oc, ft0\n";
                code += "mul oc, ft0, v0\n";
                //code += "mul oc, v0, fc0\n";
                //code += "move oc, fc0\n";
                
                    frag = assembler.assemble(Context3DProgramType.FRAGMENT, code);

            prog.upload(vert, frag);
 
        }//initprogram;
        
        
        public function onEnter(e:Event):void
        {
            context.clear();
            
            draw(context);          
                      
            context.present();
        }//onenter
        
        
        public var mat:Matrix3D = new Matrix3D();
        public var texMat:Matrix3D = new Matrix3D();
        public var ang:Number = 0;
        public function draw(c:Context3D):void
        {
            var color:Vector.<Number> = Vector.<Number>([1.0,1.0,1.0,1.0]);
            
            c.setCulling(Context3DTriangleFace.BACK);
            c.setProgram(prog);
            
            mat.identity();
           // mat.appendTranslation(0.25,0,0);
            mat.appendRotation(ang*20, Vector3D.Z_AXIS);
            ang += 0.03;
            
            var vec:Vector.<Number>;
            var s:Number;
            
            texMat.identity()
            texMat.appendTranslation(-0.5,-0.5,0);
            //texMat.appendScale(0.7,0.15,0.15);
          //  texMat.appendTranslation(Math.cos(ang), 0, 0);
            
            texMat.appendRotation(Math.cos(ang)*180.0, Vector3D.Z_AXIS);
              s = Math.sin(ang)+2;
            texMat.appendScale(s,s,s);  
              
            texMat.appendTranslation(0.5,0.5,0);
            
       //     vec = texMat.rawData;
            
          
         //   texMat.appendScale(s,s,s);
            
            //texMat.appendRotation(ang, Vector3D.Z_AXIS);
            //texMat.appendTranslation(s,s,s);
            
            
            c.setTextureAt(0, myTex.tex);
            
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mat, true); 
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 4, texMat, true);
            c.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, color);

            c.setVertexBufferAt(0, bufVert, 0, Context3DVertexBufferFormat.FLOAT_3);    
            c.setVertexBufferAt(1, bufCol, 0, Context3DVertexBufferFormat.FLOAT_4);
            c.setVertexBufferAt(2, bufUv, 0, Context3DVertexBufferFormat.FLOAT_2);
            
            c.drawTriangles(bufFace, 0, 2);
    
            
        }//draw
        
        
        
    }//classend
}
import flash.events.ErrorEvent;
import flash.geom.Matrix;
import flash.display.BitmapData;

  import flash.display3D.textures.Texture;
  import flash.display3D.*;

internal class wTex
{
    public var tex:Texture = null;
    
    
    public function wTex() {}
    
    public function getXor(w:int, h:int):BitmapData
    {
        var bm:BitmapData;
        var k:int;
        var i:int;
        
        bm = new BitmapData(w,h,false,0);
        
        for (i = 0; i < h; i++)
        {
            for (k = 0; k < w; k++)
            {
                bm.setPixel(k,i, (i^k)<<16 | (i ^ k) << 8 | (i^k));
                
            }//nextk
        }//nexti
        
        return bm;
    }//getxor
   
    
    public function genTex(bm:BitmapData, c:Context3D):void
    {
      var s:int; //scale
      var m:int; //miplevel
            
                      
      if (bm.width % 2 != 0 || bm.height %2 != 0 || bm.width != bm.height) 
      {
           bm = getResized(bm, 64, 64);   
      }//endif
      
      tex = c.createTexture(bm.width, bm.height, Context3DTextureFormat.BGRA, false);
      
    
      tex.uploadFromBitmapData( bm , 0);
      
   
       m = 1;
       s = bm.width*0.5;

      while (s > 0)
      {
            tex.uploadFromBitmapData(getResized(bm, s, s), m);
            m += 1;
            s *= 0.5;
      }//wend
        
    }//gentex
    
    private var tempMat:Matrix = new Matrix();

    private function getResized(bm:BitmapData, w:int, h:int):BitmapData
        {
            var ret:BitmapData;
            var mat:Matrix;
            
            mat = tempMat;
            //mat.identity();
            mat.a = w / bm.width;
            mat.d = h / bm.height;

            ret = new BitmapData(w, h, bm.transparent, 0);
            ret.draw(bm, mat, null, null, null, true);

            return ret;
        }//getresized
    
};//classend




